/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSTab;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSTabTest
extends TestBase {
    static IMSTab imsTab = null;

    @TestBase.STI(value=1)
    public void testCreateIMSTab() throws XPSException {
        String string = "IMSTab" + SetupConnection.random;
        imsTab = SetupConnection.builder.makeIMSTab(string);
        this.createObject((XPSObject)imsTab);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSTab() {
        SetupConnection.fetchByAttr(IMSTab.ddclass, "Tag", imsTab.getTag());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSTab() throws XPSException {
        imsTab.setTag("update" + imsTab.getTag());
        this.updateObject((XPSObject)imsTab);
    }

    @TestBase.STI(value=4)
    public void testIMSTabDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsTab);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSTab() throws XPSException {
        this.deleteObject((XPSObject)imsTab);
        imsTab = null;
    }

    @TestBase.STI(value=6)
    public void testIMSTabWithoutTag() throws XPSException {
        String string = "IMSTab2" + SetupConnection.random;
        imsTab = SetupConnection.builder.makeIMSTab(string);
        imsTab.clearTag();
        this.failCreate((XPSObject)imsTab, "Tag");
    }

    @TestBase.STI(value=7)
    public void testIMSTabWithoutExecutionOrder() throws XPSException {
        String string = "IMSTab3" + SetupConnection.random;
        imsTab = SetupConnection.builder.makeIMSTab(string);
        imsTab.clearExecutionOrder();
        this.failCreate((XPSObject)imsTab, "ExecutionOrder");
    }

    @TestBase.STI(value=8)
    public void testIMSTabWithoutTask() throws XPSException {
        String string = "IMSTab4" + SetupConnection.random;
        imsTab = SetupConnection.builder.makeIMSTab(string);
        imsTab.clearTask();
        this.failCreate((XPSObject)imsTab, "Task");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSTabTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSTabTest.class);
    }
}

