/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRole;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSRoleTest
extends TestBase {
    static IMSRole imsRole = null;

    @TestBase.STI(value=1)
    public void testCreateIMSRole() throws XPSException {
        String string = "IMSRole" + SetupConnection.random;
        imsRole = SetupConnection.builder.makeIMSRole(string);
        this.createObject((XPSObject)imsRole);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSRole() {
        SetupConnection.fetchByName(IMSRole.ddclass, imsRole.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSRole() throws XPSException {
        imsRole.setName("update" + imsRole.getName());
        imsRole.setDescription("update" + imsRole.getDescription());
        this.updateObject((XPSObject)imsRole);
    }

    @TestBase.STI(value=4)
    public void testIMSRoleDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsRole);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSRole() throws XPSException {
        this.deleteObject((XPSObject)imsRole);
        imsRole = null;
    }

    @TestBase.STI(value=6)
    public void testIMSRoleWithoutName() throws XPSException {
        imsRole = SetupConnection.builder.makeIMSRole(null);
        this.failCreate((XPSObject)imsRole, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSRoleWithoutTypeId() throws XPSException {
        String string = "IMSRole2" + SetupConnection.random;
        imsRole = SetupConnection.builder.makeIMSRole(string);
        imsRole.clearTypeId();
        this.failCreate((XPSObject)imsRole, "TypeId");
    }

    @TestBase.STI(value=8)
    public void testIMSRoleWithoutEnabled() throws XPSException {
        String string = "IMSRole3" + SetupConnection.random;
        imsRole = SetupConnection.builder.makeIMSRole(string);
        imsRole.clearEnabled();
        this.failCreate((XPSObject)imsRole, "Enabled");
    }

    @TestBase.STI(value=9)
    public void testIMSRoleWithoutAssignable() throws XPSException {
        String string = "IMSRole4" + SetupConnection.random;
        imsRole = SetupConnection.builder.makeIMSRole(string);
        imsRole.clearAssignable();
        this.failCreate((XPSObject)imsRole, "Assignable");
    }

    @TestBase.STI(value=10)
    public void testIMSRoleWithoutAdminAssignable() throws XPSException {
        String string = "IMSRole5" + SetupConnection.random;
        imsRole = SetupConnection.builder.makeIMSRole(string);
        imsRole.clearAdminAssignable();
        this.failCreate((XPSObject)imsRole, "AdminAssignable");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSRoleTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSRoleTest.class);
    }
}

