/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSManagedObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSManagedObjectTest
extends TestBase {
    static IMSManagedObject imsManagedObject = null;

    @TestBase.STI(value=1)
    public void testCreateIMSManagedObject() throws XPSException {
        String string = "IMSManagedObject" + SetupConnection.random;
        imsManagedObject = SetupConnection.builder.makeIMSManagedObject(string);
        this.createObject((XPSObject)imsManagedObject);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSManagedObject() {
        SetupConnection.fetchByName(IMSManagedObject.ddclass, imsManagedObject.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSManagedObject() throws XPSException {
        imsManagedObject.setName("update" + imsManagedObject.getName());
        imsManagedObject.setDescription("update" + imsManagedObject.getDescription());
        this.updateObject((XPSObject)imsManagedObject);
    }

    @TestBase.STI(value=4)
    public void testIMSManagedObjectDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsManagedObject);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSManagedObject() throws XPSException {
        this.deleteObject((XPSObject)imsManagedObject);
        imsManagedObject = null;
    }

    @TestBase.STI(value=6)
    public void testIMSManagedObjectWithoutName() throws XPSException {
        imsManagedObject = SetupConnection.builder.makeIMSManagedObject(null);
        this.failCreate((XPSObject)imsManagedObject, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSManagedObjectWithoutObjectType() throws XPSException {
        String string = "IMSManagedObject2" + SetupConnection.random;
        imsManagedObject = SetupConnection.builder.makeIMSManagedObject(string);
        imsManagedObject.clearObjectType();
        this.failCreate((XPSObject)imsManagedObject, "ObjectType");
    }

    @TestBase.STI(value=8)
    public void testIMSManagedObjectWithoutObjectClass() throws XPSException {
        String string = "IMSManagedObject3" + SetupConnection.random;
        imsManagedObject = SetupConnection.builder.makeIMSManagedObject(string);
        imsManagedObject.clearObjectClass();
        this.failCreate((XPSObject)imsManagedObject, "ObjectClass");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSManagedObjectTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSManagedObjectTest.class);
    }
}

