/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSIdentityPolicy;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSIdentityPolicyTest
extends TestBase {
    static IMSIdentityPolicy imsIdentityPolicy = null;

    @TestBase.STI(value=1)
    public void testCreateIMSIdentityPolicy() throws XPSException {
        String string = "IMSIdentityPolicy" + SetupConnection.random;
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(string);
        this.createObject((XPSObject)imsIdentityPolicy);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSIdentityPolicy() {
        SetupConnection.fetchByName(IMSIdentityPolicy.ddclass, imsIdentityPolicy.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSIdentityPolicy() throws XPSException {
        imsIdentityPolicy.setName("update" + imsIdentityPolicy.getName());
        this.updateObject((XPSObject)imsIdentityPolicy);
    }

    @TestBase.STI(value=4)
    public void testIMSIdentityPolicyDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsIdentityPolicy);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSIdentityPolicy() throws XPSException {
        this.deleteObject((XPSObject)imsIdentityPolicy);
        imsIdentityPolicy = null;
    }

    @TestBase.STI(value=6)
    public void testIMSIdentityPolicyWithoutName() throws XPSException {
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(null);
        this.failCreate((XPSObject)imsIdentityPolicy, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSIdentityPolicyWithoutPolicyApplication() throws XPSException {
        String string = "IMSIdentityPolicy2" + SetupConnection.random;
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(string);
        imsIdentityPolicy.clearPolicyApplication();
        this.failCreate((XPSObject)imsIdentityPolicy, "PolicyApplication");
    }

    @TestBase.STI(value=8)
    public void testIMSIdentityPolicyWithoutPolicy() throws XPSException {
        String string = "IMSIdentityPolicy3" + SetupConnection.random;
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(string);
        imsIdentityPolicy.clearPolicy();
        this.failCreate((XPSObject)imsIdentityPolicy, "Policy");
    }

    @TestBase.STI(value=9)
    public void testIMSIdentityPolicyWithoutMemberRule() throws XPSException {
        String string = "IMSIdentityPolicy4" + SetupConnection.random;
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(string);
        imsIdentityPolicy.clearMemberRule();
        this.failCreate((XPSObject)imsIdentityPolicy, "MemberRule");
    }

    @TestBase.STI(value=10)
    public void testIMSIdentityPolicyWithoutFlags() throws XPSException {
        String string = "IMSIdentityPolicy5" + SetupConnection.random;
        imsIdentityPolicy = SetupConnection.builder.makeIMSIdentityPolicy(string);
        imsIdentityPolicy.clearFlags();
        this.failCreate((XPSObject)imsIdentityPolicy, "Flags");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSIdentityPolicyTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSIdentityPolicyTest.class);
    }
}

