/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.SAMLAffiliation;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SAMLAffiliationTest
extends TestBase {
    static SAMLAffiliation sAMLAffiliation;

    @TestBase.STI(value=1)
    public void testCreateSAMLAffiliation() throws XPSException {
        String string = "SAMLAffiliation" + SetupConnection.random;
        sAMLAffiliation = this.makeSAMLAffiliation(string);
        this.createObject((XPSObject)sAMLAffiliation);
    }

    @TestBase.STI(value=2)
    public void testCreateSearchAffiliation() throws XPSException {
        SetupConnection.fetchByName(SAMLAffiliation.ddclass, sAMLAffiliation.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateSAMLAffiliation() throws XPSException {
        sAMLAffiliation.setName("update" + sAMLAffiliation.getName());
        sAMLAffiliation.setDescription("update" + sAMLAffiliation.getDescription());
        this.updateObject((XPSObject)sAMLAffiliation);
    }

    @TestBase.STI(value=4)
    public void testSAMLAffiliationDeployment() {
        SAMLAffiliationTest.skip("Raised RTC defect 138701 to see why this is consistently failing");
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)sAMLAffiliation);
    }

    @TestBase.STI(value=5)
    public void testDeleteSAMLAffiliation() throws XPSException {
        this.deleteObject((XPSObject)sAMLAffiliation);
        sAMLAffiliation = null;
    }

    @TestBase.STI(value=6)
    public void testSAMLAffiliationWithoutName() throws XPSException {
        sAMLAffiliation = this.makeSAMLAffiliation(null);
        this.failCreate((XPSObject)sAMLAffiliation, "Name");
    }

    private SAMLAffiliation makeSAMLAffiliation(String string) throws XPSException {
        SAMLAffiliation sAMLAffiliation = (SAMLAffiliation)SetupConnection.policyData.newObject((IClass)SAMLAffiliation.ddclass);
        if (string != null) {
            sAMLAffiliation.setName(string);
        }
        sAMLAffiliation.setADSearchSpec("dc=testing,dc=com");
        sAMLAffiliation.setCustomSearchSpec("dc=custome");
        sAMLAffiliation.setDescription("XPSAPI JUnit Sample SAMLAffiliatio");
        sAMLAffiliation.setKEY_AffiliationID("Product");
        sAMLAffiliation.setLDAPSearchSpec("dc=testing");
        sAMLAffiliation.setNameIdAttrName("NameID");
        sAMLAffiliation.setNameIdDNSpec("NamedDNTesting");
        sAMLAffiliation.setNameIdFormat("NameIDFormat");
        sAMLAffiliation.setNameIdType(Integer.valueOf(1));
        sAMLAffiliation.setSAMLMajorVersion(Integer.valueOf(2));
        sAMLAffiliation.setSAMLMinorVersion(Integer.valueOf(0));
        return sAMLAffiliation;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SAMLAffiliationTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SAMLAffiliationTest.class);
    }
}

