/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class EPMODBCQueryTest
extends TestBase {
    static ODBCQuery oDBCQuery;

    @TestBase.STI(value=1)
    public void testCreateODBCQuery() throws XPSException {
        String string = "ODBCQuery" + SetupConnection.random;
        oDBCQuery = this.makeODBCQuery(string);
        this.createObject((XPSObject)oDBCQuery);
    }

    @TestBase.STI(value=2)
    public void testSearchODBCQuery() throws XPSException {
        SetupConnection.fetchByName(ODBCQuery.ddclass, oDBCQuery.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateODBCQuery() throws XPSException {
        oDBCQuery.setName("update" + oDBCQuery.getName());
        oDBCQuery.setDesc("update" + oDBCQuery.getDesc());
        this.updateObject((XPSObject)oDBCQuery);
    }

    @TestBase.STI(value=4)
    public void testODBCQueryDeployment() throws XPSException {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)oDBCQuery);
    }

    @TestBase.STI(value=5)
    public void testDeleteODBCQuery() throws XPSException {
        this.deleteObject((XPSObject)oDBCQuery);
        oDBCQuery = null;
    }

    private ODBCQuery makeODBCQuery(String string) throws XPSException {
        ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
        if (string != null) {
            oDBCQuery.setName(string);
        }
        oDBCQuery.setDesc("XPSAPI JUnit Sample ODBCQuery");
        oDBCQuery.setQueryEnumerate("Select Name,'Group' as Class from SmGroup order by Name");
        oDBCQuery.setQueryGetObjInfo("select Name, 'User' from SmUser where Name = '%s' Union select Name, 'Group' from SmGroup where Name = '%s'");
        oDBCQuery.setQueryLookup("select Name, 'User' as Class from SmUser where Name %s Union select Name, 'Group' as Class from SmGroup where Name %s order by Class");
        oDBCQuery.setQueryInitUser("select Name from SmUser where Name = '%s'");
        oDBCQuery.setQueryAuthenticateUser("select Name from SmUser where Name = '%s' and Password = '%s'");
        oDBCQuery.setQueryGetUserProp("select %s from SmUser where Name = '%s'");
        oDBCQuery.setQuerySetUserProp("update SmUser set %s = '%s' where Name = '%s'");
        oDBCQuery.setQueryGetUserProps("Name, UserID, FirstName, LastName, TelephoneNumber, EmailAddress, Disabled, PIN, Mileage, PasswordData");
        oDBCQuery.setQueryLookupUser("select Name, 'User' as Class from SmUser where %s");
        oDBCQuery.setQueryGetGroups("select SmGroup.Name from SmGroup, SmUser, SmUserGroup where SmUser.Name = '%s' and SmUser.UserID  = SmUserGroup.UserID and SmGroup.GroupID = SmUserGroup.GroupID");
        oDBCQuery.setQueryIsGroupMember("select ID from SmUserGroup where UserID = (select UserID from SmUser where Name = '%s') and GroupID = (select GroupID from SmGroup where Name = '%s')");
        oDBCQuery.setQueryGetGroupProp("select %s from SmGroup where Name = '%s'");
        oDBCQuery.setQuerySetGroupProp("update SmGroup set %s = '%s' where Name = '%s'");
        oDBCQuery.setQueryGetGroupProps("Name, GroupID");
        oDBCQuery.setQueryLookupGroup("select Name, 'Group' as Class from SmGroup where %s");
        oDBCQuery.setQuerySetPassword("update SmUser set Password = '%s' where Name = '%s'");
        return oDBCQuery;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)EPMODBCQueryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(EPMODBCQueryTest.class);
    }
}

