/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.cds;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.cds.Certificate;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.textui.TestRunner;

public class CertTest
extends TestBase {
    static Certificate cert;
    private static String pkData1;
    private static String pkData2;
    private static final String PRIV_KEY_SEQID_SEP = ":";

    @TestBase.STI(value=1)
    public void testCreateCert() throws XPSException {
        String string = "Cert" + SetupConnection.random;
        cert = CertTest.makeCertificate(string);
        this.createObject((XPSObject)cert);
    }

    @TestBase.STI(value=2)
    public void testSearchCertificate() {
        SetupConnection.fetchByAttr((IAttribute)Certificate.ALIAS, cert.getAlias());
    }

    @TestBase.STI(value=3)
    public void testEncryption() {
        Certificate certificate = (Certificate)SetupConnection.fetchByAttr((IAttribute)Certificate.ALIAS, cert.getAlias());
        List list = certificate.getPrivateKey();
        Iterator iterator = list.iterator();
        int n = list.size();
        CertTest.assertEquals((String)"Incorrect number of privatekey parts", (int)n, (int)2);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CertTest.assertTrue((String)"PrivateKey parts should be retrieved in encrypted form", (string.startsWith("{AES}") || string.startsWith("{RC2}") ? 1 : 0) != 0);
        }
    }

    @TestBase.STI(value=4)
    public void testDecryption() {
        Certificate certificate = (Certificate)SetupConnection.fetchByAttr((IAttribute)Certificate.ALIAS, cert.getAlias());
        String string = Certificate.PRIVATEKEY.getFQName();
        String string2 = certificate.getXid();
        List list = SetupConnection.session.getSecurity().decryptSensitiveAttribute(string2, string);
        Iterator iterator = list.iterator();
        int n = list.size();
        CertTest.assertEquals((String)"Incorrect number of privatekey parts", (int)n, (int)2);
        StringTokenizer stringTokenizer = null;
        String[] stringArray = new String[n];
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            stringTokenizer = new StringTokenizer(string3, PRIV_KEY_SEQID_SEP);
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            stringArray[n2] = stringTokenizer.nextToken();
        }
        CertTest.assertEquals((String)"PrivateKey part 1 is incorrect", (String)stringArray[0], (String)pkData1.substring(2));
        CertTest.assertEquals((String)"PrivateKey part 2 is incorrect", (String)stringArray[1], (String)pkData2.substring(2));
    }

    @TestBase.STI(value=5)
    public void testDecryptionBadAttribute() {
        Certificate certificate = (Certificate)SetupConnection.fetchByAttr((IAttribute)Certificate.ALIAS, cert.getAlias());
        String string = Certificate.SERIALNUMBER.getFQName();
        String string2 = certificate.getXid();
        try {
            List list = SetupConnection.session.getSecurity().decryptSensitiveAttribute(string2, string);
            CertTest.fail((String)"Disallowed attribute decrypted successfully.");
        }
        catch (XPSException xPSException) {
            CertTest.assertTrue((String)"Exception must contain \"decrypt\"", (boolean)xPSException.getTag().contains("decrypt"));
        }
    }

    @TestBase.STI(value=6)
    public void testUpdateCertificate() throws XPSException {
        cert.setAlias("update" + cert.getAlias());
        this.updateObject((XPSObject)cert);
    }

    @TestBase.STI(value=7)
    public void testCertificateDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)cert);
    }

    @TestBase.STI(value=8)
    public void testDeleteCertificate() throws XPSException {
        this.deleteObject((XPSObject)cert);
        cert = null;
    }

    @TestBase.STI(value=9)
    public void testCertificateWithoutAlias() throws XPSException {
        cert = CertTest.makeCertificate(null);
        this.failCreate((XPSObject)cert, "Alias");
    }

    public static Certificate makeCertificate(String string) throws XPSException {
        Certificate certificate = (Certificate)SetupConnection.policyData.newObject((IClass)Certificate.ddclass);
        if (string != null) {
            certificate.setAlias(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "CertificateData";
        arrayList.add(string2);
        certificate.setCertificateData(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(pkData1);
        arrayList2.add(pkData2);
        certificate.setPrivateKey(arrayList2);
        certificate.setCRLRevStatusValue(Certificate.CRLRevStatusValue.UNKNOWN);
        certificate.setIsFIPSApproved(Boolean.valueOf(false));
        certificate.setIssuerDN("IssuerDN");
        certificate.setIsFIPSApproved(Boolean.valueOf(false));
        certificate.setSerialNumber("1234");
        certificate.setType(Certificate.Type.KeyEntry);
        certificate.setSubjectName("SubjectName");
        certificate.setOCSPRevStatusValue(Certificate.OCSPRevStatusValue.UNKNOWN);
        return certificate;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CertTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(CertTest.class);
    }

    static {
        pkData1 = "0:PrivateKeyPart1";
        pkData2 = "1:PrivateKeyPart2";
    }
}

