/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class BooleanListAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testBooleanListAlias() throws XPSException {
        BooleanListAliasTest.assertEquals(gMainTest.getAliasToBooleanList(), (Object)lAliasedBool);
    }

    @TestBase.STI(value=2)
    public void testBooleanListAliasForward() throws XPSException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(true);
        arrayList.add(false);
        arrayList.add(true);
        gMainTest.setAliasToBooleanList(arrayList);
        this.updateObject((XPSObject)gMainTest);
        InternalTesting.invalidate((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        BooleanListAliasTest.assertEquals((String)"Alias forward boolean list, created, does not match with existing list", test.getBooleanList(), arrayList);
    }

    @TestBase.STI(value=3)
    public void testBooleanListAliasBackward() throws XPSException {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        arrayList.add(true);
        arrayList.add(false);
        arrayList.add(false);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setBooleanList(arrayList);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        BooleanListAliasTest.assertEquals((String)"Alias backward boolean list, created, does not match with existing list", gMainTest.getAliasToBooleanList(), arrayList);
    }

    @TestBase.STI(value=4)
    public void testBooleanListAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearBooleanList();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        BooleanListAliasTest.assertTrue((String)"Alias Boolean list not cleared", (boolean)gMainTest.getAliasToBooleanList().isEmpty());
    }

    @TestBase.STI(value=5)
    public void testBooleanListMainCleared() throws XPSException {
        gMainTest.clearAliasToBooleanList();
        this.updateObject((XPSObject)gMainTest);
        InternalTesting.invalidate((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        BooleanListAliasTest.assertTrue((String)"Main boolean list is not cleared", (boolean)test.getBooleanList().isEmpty());
    }

    @TestBase.STI(value=6)
    public void testBooleanListSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        BooleanListAliasTest.assertEquals((String)"Before setLink, Aliased boolean list must match lMainBool", test.getAliasToBooleanList(), (Object)lMainBool);
        test.setLink(this.createAliasTest());
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        BooleanListAliasTest.assertEquals((String)"After setLink, Aliased boolean list must match lAliasedBool", test.getAliasToBooleanList(), (Object)lAliasedBool);
        test.clearLink();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)test);
        BooleanListAliasTest.assertEquals((String)"After clearing link, Aliased boolean list must match lMainBool", test.getAliasToBooleanList(), (Object)lMainBool);
    }

    @TestBase.STI(value=7)
    public void testBooleanListAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        BooleanListAliasTest.assertEquals((String)"Alias-to-Alias boolean list must match with Main boolean list", test2.getAliasToAliasToBooleanList(), (Object)lAliasedBool);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BooleanListAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(BooleanListAliasTest.class);
    }
}

