/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.epm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.ca.epm.Role;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent4x;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserPolicy;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationSetup
extends SetupConnection {
    public String appendStr = Long.toString(random);
    public String strAgentName = "Agent" + this.appendStr;
    public String strAuthSchemeName = "";
    public String strUDName = "UserDir" + this.appendStr;
    public String strAppName = "Application" + this.appendStr;
    public String strRoleName = "Role" + this.appendStr;
    public String strRoleExpr = "(100 = 100)";

    public ApplicationSetup(TestSuite testSuite) {
        super(testSuite);
    }

    public ApplicationSetup(Class<? extends TestBase> clazz) {
        super(clazz);
    }

    public void doApplicationSetup() throws XPSException {
        this.strAuthSchemeName = "BasicAuth" + this.appendStr;
        this.createAuthSchemeBasic(this.strAuthSchemeName);
        this.createAgent4x(this.strAgentName);
        this.checkAndCreateUserDirIfNeeded(this.strUDName);
        this.createEPMAppln(this.strAppName, this.strAgentName, this.strUDName, this.strAuthSchemeName);
        this.createRole(this.strRoleName, this.strRoleExpr, this.strAppName);
        this.createPolicy(this.strRoleName, this.strAppName, this.strUDName);
        this.updateRole(this.strRoleName, null);
        InternalTesting.Server_updateCaches(session);
    }

    protected void createAgent4x(String string) throws XPSException {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            Agent4x agent4x = (Agent4x)SetupConnection.policyData.newObject((IClass)Agent4x.ddclass);
            agent4x.setName(string.toLowerCase());
            agent4x.setAgentType(agentType);
            agent4x.setDesc("XPSAPI JUnit Sample Agent");
            agent4x.setRealmHintAttrId(Integer.valueOf(0));
            agent4x.setSecret("firewall");
            agent4x.clearIpAddr();
            this.createRoleObject((XPSObject)agent4x);
        }
    }

    public void checkAndCreateUserDirIfNeeded(String string) throws XPSException {
        UserDirectory userDirectory = null;
        try {
            userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userDirectory != null) {
            return;
        }
        if (string != null) {
            UserDirectory userDirectory2 = (UserDirectory)SetupConnection.policyData.newObject((IClass)UserDirectory.ddclass);
            userDirectory2.setName(string);
            userDirectory2.setDesc("XPSAPI JUnit Sample UserDirectory");
            String string2 = SetupConnection.properties.get("USERDIR_NAMESPACE");
            userDirectory2.setNamespace(string2);
            if (string2.equals("ODBC:")) {
                ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
                oDBCQuery.setName(string + "_query");
                oDBCQuery.setDesc("XPSAPI JUnit Sample Query Scheme");
                SetupConnection.createObject((XPSObject)oDBCQuery);
                userDirectory2.setODBCQuery((com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery)oDBCQuery);
                userDirectory2.setUniversalIDAttribute("name");
                userDirectory2.setServer(SetupConnection.properties.get("ODBC_USER_STORE_SERVER"));
            }
            if (string2.equals("LDAP:")) {
                userDirectory2.setUniversalIDAttribute("uid");
            }
            if (string2.equals("AD:")) {
                userDirectory2.setUniversalIDAttribute("CN");
            }
            if (string2.equals("LDAP:") || string2.equals("AD:")) {
                userDirectory2.setServer(SetupConnection.properties.get("LDAP_USER_STORE_SERVER"));
                userDirectory2.setSearchRoot(SetupConnection.properties.get("LDAP_SEARCH_ROOT"));
                userDirectory2.setSearchResults(Integer.valueOf(0));
                userDirectory2.setSearchScope(UserDirectory.SearchScope.SubTree);
                userDirectory2.setSearchTimeout(Integer.valueOf(30));
                userDirectory2.setUserLookupStart(SetupConnection.properties.get("LDAP_USER_LOOKUP_START"));
                userDirectory2.setUserLookupEnd(SetupConnection.properties.get("LDAP_USER_LOOKUP_END"));
            }
            if (SetupConnection.properties.get("USERDIR_CREDENTIALS_USERNAME") != null && SetupConnection.properties.get("USERDIR_CREDENTIALS_PASSWORD") != null) {
                userDirectory2.setUsername(SetupConnection.properties.get("USERDIR_CREDENTIALS_USERNAME"));
                userDirectory2.setPassword(SetupConnection.properties.get("USERDIR_CREDENTIALS_PASSWORD"));
                userDirectory2.setRequireCredentials(Boolean.valueOf(true));
            } else {
                userDirectory2.setRequireCredentials(Boolean.valueOf(false));
            }
            userDirectory2.setSecureConnection(Boolean.valueOf(false));
            userDirectory2.setEnableSecurityContext(Boolean.valueOf(false));
            SetupConnection.createObject((XPSObject)userDirectory2);
        }
    }

    protected void createEPMAppln(String string, String string2, String string3, String string4) throws XPSException {
        List<UserDirectory> list = ObjectBuilder.getUserDirs(string3);
        Agent agent = (Agent)SetupConnection.fetchByName(Agent.ddclass, string2.toLowerCase());
        AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, string4);
        Application application = ObjectBuilder.makeApplication(string, list);
        this.createRoleObject((XPSObject)application);
        Realm realm = (Realm)SetupConnection.policyData.newObject((IClass)Realm.ddclass);
        realm.setName(string);
        realm.setAgent(agent);
        realm.setAuthScheme(authScheme);
        realm.setParent((Domain)application);
        realm.setDesc("XPSAPI JUnit Sample Realm");
        realm.setResourceFilter("/test/");
        realm.setProcessAuthEvents(Boolean.valueOf(true));
        realm.setProcessAzEvents(Boolean.valueOf(true));
        realm.setProtectAll(Boolean.valueOf(true));
        realm.setMaxTimeout(Integer.valueOf(10800));
        realm.setIdleTimeout(Integer.valueOf(3600));
        realm.setSyncAudit(Boolean.valueOf(false));
        realm.setSessionType(Realm.SessionType.Nonperistent);
        realm.setSessionDrift(Integer.valueOf(-1));
        this.createRoleObject((XPSObject)realm);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Get");
        arrayList.add("Put");
        arrayList.add("Post");
        Rule rule = (Rule)SetupConnection.policyData.newObject((IClass)Rule.ddclass);
        rule.setName(string);
        rule.setParent(realm);
        rule.setDesc("XPSAPI JUnit Sample Rule");
        rule.setActions(arrayList);
        rule.setResource("*");
        rule.setAllowAccess(Boolean.valueOf(true));
        rule.setRegularExpression(Boolean.valueOf(false));
        rule.setIsEnabled(Boolean.valueOf(true));
        this.createRoleObject((XPSObject)rule);
    }

    protected void createRole(String string, String string2, String string3) throws XPSException {
        Application application = (Application)SetupConnection.fetchByName(Application.ddclass, string3);
        Role role = (Role)SetupConnection.policyData.newObject((IClass)Role.ddclass);
        role.setName(string);
        role.setDescription("XPSAPI JUnit Sample Expression");
        role.clearFlags();
        role.setExpression(string2);
        role.setParent((Domain)application);
        this.createRoleObject((XPSObject)role);
    }

    protected void createPolicy(String string, String string2, String string3) throws XPSException {
        Application application = (Application)SetupConnection.fetchByName(Application.ddclass, string2);
        Role role = (Role)SetupConnection.fetchByName(Role.ddclass, string);
        Rule rule = (Rule)SetupConnection.fetchByName(Rule.ddclass, string2);
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string3);
        Policy policy = (Policy)SetupConnection.policyData.newObject((IClass)Policy.ddclass);
        policy.setName(string);
        policy.setParent((Domain)application);
        policy.setDesc("XPSAPI JUnit Sample policy");
        policy.setAllowAccess(Boolean.valueOf(true));
        policy.setIsEnabled(Boolean.valueOf(true));
        policy.setActiveExprString("<@lib=\"EPMObjects\" func=\"Role\" param=\"" + role.getXid() + "\"@>");
        this.createRoleObject((XPSObject)policy);
        PolicyLink policyLink = (PolicyLink)SetupConnection.policyData.newObject((IClass)PolicyLink.ddclass);
        policyLink.setParent(policy);
        policyLink.setRule(rule);
        this.createRoleObject((XPSObject)policyLink);
        UserPolicy userPolicy = (UserPolicy)SetupConnection.policyData.newObject((IClass)UserPolicy.ddclass);
        userPolicy.setParent(policy);
        userPolicy.setUserDirectory(userDirectory);
        userPolicy.setPolicyFlags(UserPolicy.PolicyFlags.Default);
        userPolicy.setFilterClass("All");
        userPolicy.setFilterPath("All");
        userPolicy.setPolicyResolution(UserPolicy.PolicyResolution.All);
        this.createRoleObject((XPSObject)userPolicy);
    }

    public void updateRole(String string, String string2) throws XPSException {
        Filter filter = new Filter((IAttribute)Policy.NAME, Clause.Operator.EQUAL, (Object)string);
        List list = SetupConnection.policyData.search((IClass)Policy.ddclass, filter);
        Role role = (Role)SetupConnection.fetchByName(Role.ddclass, string);
        if (string2 != null) {
            role.setExpression(string2);
        }
        role.setPolicies(list);
        SetupConnection.updateObject((XPSObject)role);
    }

    public void createAuthSchemeBasic(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauthdir");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.Basic);
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    protected void updateRoleObject(XPSObject xPSObject) throws XPSException {
        SetupConnection.updateObject(xPSObject);
    }

    protected void createRoleObject(XPSObject xPSObject) throws XPSException {
        ApplicationSetup.createObject(xPSObject);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.doApplicationSetup();
    }

    public String getAppendStr() {
        return this.appendStr;
    }

    public String getRoleName() {
        return this.strRoleName;
    }

    public void setRoleName(String string) {
        this.strRoleName = string;
    }

    public String getAppName() {
        return this.strAppName;
    }
}

