/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.filter;

import com.ca.siteminder.rpc.type.Deserializer;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.OutStream;
import com.ca.siteminder.rpc.type.Serializer;
import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.Type;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.DsFilter;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.LogicalOp;
import com.ca.siteminder.sdk.adminapi.filter.UserLookupExpr;

public class DSFilterType
extends Type {
    public DSFilterType() {
        super(DsFilter.class);
    }

    public Object deserialize(Tree tree, Deserializer deserializer) {
        return null;
    }

    public void serialize(Object object, Serializer serializer) {
        DsFilter dsFilter = (DsFilter)object;
        OutStream outStream = serializer.getOutStream();
        outStream.startElement(this.getName());
        Expression expression = dsFilter.getExpression();
        if (expression != null) {
            this.serializeExpression(expression, outStream, dsFilter.getDirXid());
        }
        outStream.endElement();
    }

    void serializeExpression(Expression expression, OutStream outStream, String string) {
        if (expression instanceof Clause) {
            Clause clause = (Clause)expression;
            outStream.startElement("clause");
            outStream.value("xid", string);
            outStream.value("name", clause.getKeyName());
            outStream.value("op", clause.getOperator().toString());
            outStream.value("val", clause.getAttrVal().toString());
            outStream.value("case", clause.getCase() ? "1" : "0");
            outStream.endElement();
        } else if (expression instanceof UserLookupExpr) {
            UserLookupExpr userLookupExpr = (UserLookupExpr)expression;
            outStream.startElement("UserLookupExpr");
            outStream.value("xid", string);
            outStream.value("op", userLookupExpr.getOperator().toString());
            outStream.value("val", userLookupExpr.getVal().toString());
            outStream.value("useLookupQuery", userLookupExpr.getUseLookupQuery() ? "1" : "0");
            outStream.endElement();
        } else {
            LogicalOp logicalOp = (LogicalOp)expression;
            String string2 = logicalOp.getOperator().toString();
            outStream.startElement(string2);
            this.serializeExpression(logicalOp.getExpr1(), outStream, string);
            this.serializeExpression(logicalOp.getExpr2(), outStream, string);
            outStream.endElement();
        }
    }

    public void format(Object object, Formatter formatter) {
    }
}

