/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.filter;

import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import java.util.Date;
import java.util.Set;

public class Clause
implements Expression {
    private IAttribute attrObj;
    private String keyName;
    private Operator operator;
    private Object attrValue;
    private boolean caseSensitive = false;

    public Clause(IAttribute iAttribute, Operator operator, Object object, boolean bl) {
        if (iAttribute == null || operator == null) {
            throw new IllegalArgumentException();
        }
        this.attrObj = iAttribute;
        this.attrValue = Clause.transformAValueToInt(object);
        this.operator = operator;
        this.caseSensitive = bl;
    }

    public Clause(IAttribute iAttribute, Operator operator, Object object) {
        this(iAttribute, operator, object, false);
    }

    public Clause(String string, Operator operator, Object object, boolean bl) {
        if (string == null || operator == null) {
            throw new IllegalArgumentException();
        }
        this.keyName = string;
        this.attrValue = Clause.transformAValueToInt(object);
        this.operator = operator;
        this.caseSensitive = bl;
    }

    private static Object transformAValueToInt(Object object) {
        Object object2 = object;
        if (object2 == null) {
            return object2;
        }
        if (object instanceof ValuedEnum) {
            object2 = ((ValuedEnum)object).getValue();
        } else if (object instanceof Set) {
            Set set = (Set)object;
            int n = 0;
            for (ValuedEnum valuedEnum : set) {
                n |= valuedEnum.getValue();
            }
            object2 = n;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            long l = date.getTime() / 1000L;
            object2 = Long.toString(l);
        }
        return object2;
    }

    public Clause(String string, Operator operator, Object object) {
        this(string, operator, object, false);
    }

    public String getAttrName() {
        return this.attrObj != null ? this.attrObj.getFQName() : this.getKeyName();
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object getAttrVal() {
        return this.attrValue;
    }

    public boolean getCase() {
        return this.caseSensitive;
    }

    public String toString() {
        String string = this.getKeyName() != null ? this.getKeyName() : this.getAttrName();
        return "(" + string + " " + (Object)((Object)this.operator) + " " + this.attrValue + ")";
    }

    public Clause negate() {
        String string = this.getKeyName() != null ? this.getKeyName() : this.getAttrName();
        return new Clause(string, this.operator.negation, this.attrValue, this.caseSensitive);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQUAL("EQ"),
        NOTEQUAL("NOTEQ", EQUAL),
        GREATER("GR"),
        NOTGREATER("NOTGR", GREATER),
        LESS("LE"),
        NOTLESS("NOTLE", LESS),
        BEGINSWITH("BEWITH"),
        NOTBEGINSWITH("NOTBEWITH", BEGINSWITH),
        ENDSWITH("ENDWITH"),
        NOTENDSWITH("NOTENDWITH", ENDSWITH),
        CONTAINS("CONT"),
        NOTCONTAINS("NOTCONT", CONTAINS);

        final String name;
        Operator negation;

        private Operator(String string2) {
            this.name = string2;
        }

        private Operator(String string2, Operator operator) {
            this.name = string2;
            this.negation = operator;
            operator.negation = this;
        }

        public String toString() {
            return this.name;
        }
    }
}

