/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.ca.xps;

import com.ca.siteminder.sdk.adminapi.BaseObject;
import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Product;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Class
extends BaseObject
implements IClass<GenericObject> {
    public static final DDClass<Class> ddclass = new DDClass<Class>(Class.class, Product.ddclass, "CA.XPS::Class");
    List<Attribute> attributes = new ArrayList<Attribute>();
    Map<Object, Attribute> attrMap = new HashMap<Object, Attribute>();
    Class baseClass;
    DDClass<? extends XPSObject> dd_class;
    Class metadataClass;
    public static final DDAttribute<String> NAME = new DDAttribute(ddclass, "Name", IAttribute.DataType.String);
    private String fqname;
    public static final DDAttribute<Class> PARENTCLASS = new DDAttribute(ddclass, "ParentClass", IAttribute.DataType.Link);
    public static final DDAttribute<Boolean> EXTENSIONCLASS = new DDAttribute(ddclass, "ExtensionClass", IAttribute.DataType.Boolean);
    public static final DDAttribute<Integer> EXPORTTYPE = new DDAttribute(ddclass, "ExportType", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> EXPORTGROUP = new DDAttribute(ddclass, "ExportGroup", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Boolean> OBSOLETE = new DDAttribute(ddclass, "Obsolete", 0, 1, IAttribute.DataType.Boolean, IAttribute.Handling.Value, IAttribute.APIAccess.ReadOnly);
    public static final DDAttribute<Integer> HANDLING = new DDAttribute(ddclass, "Handling", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Flags, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> IMPORTTYPE = new DDAttribute(ddclass, "ImportType", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Enumeration, IAttribute.APIAccess.All);
    public static final DDAttribute<Integer> SITEMINDERTYPE = new DDAttribute(ddclass, "SiteMinderType", 1, 1, IAttribute.DataType.Integer, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<String> DESCRIPTION = new DDAttribute(ddclass, "Description", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);

    public Class(XPSObjectImpl xPSObjectImpl) {
        super(xPSObjectImpl);
    }

    public void setMetadata(Class clazz) {
        this.metadataClass = clazz;
    }

    public void init() {
        if (this.isExtension()) {
            this.baseClass = this.getBaseClass();
        }
        for (Attribute attribute : this.attributes) {
            String string = attribute.getFQName();
            String string2 = attribute.getName();
            this.attrMap.put(string2, attribute);
            this.attrMap.put(string, attribute);
            if (this.baseClass == null) continue;
            this.baseClass.attrMap.put(string, attribute);
        }
    }

    public void setDDClass(DDClass<? extends XPSObject> dDClass) {
        this.dd_class = dDClass;
        List<DDAttribute> list = dDClass.getAttributes();
        for (DDAttribute dDAttribute : list) {
            Attribute attribute = this.attrMap.get(dDAttribute.getName());
            if (attribute == null) continue;
            this.attrMap.put(dDAttribute, attribute);
            if (this.baseClass == null) continue;
            this.baseClass.attrMap.put(dDAttribute, attribute);
        }
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public Attribute getAttribute(String string) {
        Attribute attribute = this.attrMap.get(string);
        if (attribute == null && this.baseClass != null) {
            attribute = this.baseClass.attrMap.get(string);
        }
        if (attribute == null && this.metadataClass != null) {
            attribute = this.metadataClass.attrMap.get(string);
        }
        return attribute;
    }

    public Attribute getAttribute(DDAttribute<?> dDAttribute) {
        Attribute attribute = this.attrMap.get(dDAttribute);
        if (attribute == null && this.metadataClass != null) {
            attribute = this.metadataClass.attrMap.get(dDAttribute.getFQName());
        }
        if (attribute == null) {
            throw new XPSException("attribute", this.getFQName(), dDAttribute.getName());
        }
        return attribute;
    }

    @Override
    public Product getProduct() {
        return this.impl.getParent(Product.class);
    }

    @Override
    public String getName() {
        return (String)this.impl.getSingleProperty(NAME);
    }

    @Override
    public synchronized String getFQName() {
        if (this.fqname == null) {
            return this.getProduct().getFQName() + "::" + this.getName();
        }
        return this.fqname;
    }

    @Override
    public Class getParentClass() {
        return this.isExtension() ? this.getBaseClass().getParentClass() : this.impl.getLink(PARENTCLASS, Class.class);
    }

    @Override
    public Class getBaseClass() {
        return this.isExtension() ? this.impl.getLink(PARENTCLASS, Class.class) : null;
    }

    @Override
    public boolean isExtension() {
        Boolean bl = (Boolean)this.impl.getSingleProperty(EXTENSIONCLASS);
        return bl != null && bl != false;
    }

    @Override
    public java.lang.Class<GenericObject> getJavaClass() {
        return GenericObject.class;
    }

    @Override
    public java.lang.Class<? extends XPSObject> getDynamicJavaClass() {
        return this.dd_class != null ? this.dd_class.getJavaClass() : GenericObject.class;
    }

    public Integer getExportType() {
        return (Integer)this.impl.getSingleProperty(EXPORTTYPE);
    }

    public ExportGroup getExportGroup() {
        return ExportGroup.values()[this.impl.getIntProperty(EXPORTGROUP) - 0];
    }

    public Boolean getObsolete() {
        return (Boolean)this.impl.getSingleProperty(OBSOLETE);
    }

    public Set<Handling> getHandling() {
        return this.impl.getEnumSet(HANDLING, Handling.class, Handling.values());
    }

    public ImportType getImportType() {
        return ImportType.values()[this.impl.getIntProperty(IMPORTTYPE) - 0];
    }

    public Integer getSiteMinderType() {
        return (Integer)this.impl.getSingleProperty(SITEMINDERTYPE);
    }

    public String getDescription() {
        return (String)this.impl.getSingleProperty(DESCRIPTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImportType {
        None,
        Add,
        Replace,
        Overlay,
        MergePreferOld,
        MergePreferNew;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Handling {
        Exclusive,
        NoInstances,
        NoExternalGUIDs;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportGroup {
        None,
        Initial,
        Environmental,
        Policy;

    }
}

