/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.rpc.type.Deserializer;
import com.ca.siteminder.rpc.type.Formatter;
import com.ca.siteminder.rpc.type.OutStream;
import com.ca.siteminder.rpc.type.Serializer;
import com.ca.siteminder.rpc.type.Tree;
import com.ca.siteminder.rpc.type.Type;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.Utilities;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class XPSObjectType
extends Type {
    static final String ATTRIBUTE = "prop";
    static final String ATTRIBUTES = "props";
    static final String NAME = "name";
    static final String LINK = "xid";
    static final String META = "meta";
    static final String CREATED = "created";
    static final String MODIFIED = "modified";
    static final String UPDATED_BY = "updatedBy";
    static final String METHOD = "method";
    static final String CLASS = "class";
    static final String PARENT = "parent";
    static final String EXTENSIONS = "extensions";
    static final String READ_ONLY = "ReadOnly";
    static final String RID = "rid";

    XPSObjectType(Class clazz) {
        super(clazz);
    }

    public Object deserialize(Tree tree, Deserializer deserializer) {
        Object object;
        Object object2;
        XPSObject xPSObject;
        if (tree.firstChild == null) {
            return null;
        }
        Session session = (Session)deserializer.getApplicationContext();
        Tree tree2 = tree.firstChild;
        String string = tree2.value;
        IClass<? extends XPSObject> iClass = session.classCache.getClass(string);
        Tree tree3 = tree2.nextSibling;
        String string2 = tree3.value;
        XPSObjectImpl xPSObjectImpl = null;
        XPSObject xPSObject2 = session.objectCache.get(string2);
        if (xPSObject2 != null && !xPSObject2.impl.stub) {
            return xPSObject2;
        }
        xPSObjectImpl = new XPSObjectImpl();
        xPSObjectImpl.setBaseClass(iClass);
        xPSObjectImpl.setXid(string2);
        XPSObject xPSObject3 = XPSObject.newInstance(xPSObjectImpl);
        Tree tree4 = tree3.nextSibling;
        int n = (Integer)deserializer.deserialize(tree4.firstChild);
        xPSObjectImpl.setRid(n);
        Tree tree5 = tree4.nextSibling;
        String string3 = null;
        if (tree5.tag.equalsIgnoreCase(PARENT)) {
            string3 = tree5.value;
            xPSObject = session.makeStub(string3);
            xPSObjectImpl.setParent(xPSObject);
            tree5 = tree5.nextSibling;
        }
        if (tree5.tag.equalsIgnoreCase(EXTENSIONS)) {
            xPSObject = tree5.firstChild;
            while (xPSObject != null) {
                object2 = session.classCache.getClass(((Tree)xPSObject).value);
                xPSObjectImpl.addExtension((IClass<? extends XPSObject>)object2);
                xPSObject = ((Tree)xPSObject).nextSibling;
            }
            tree5 = tree5.nextSibling;
        }
        if (tree5.tag.equalsIgnoreCase(META)) {
            xPSObject = tree5.firstChild;
            while (xPSObject != null) {
                object2 = ((Tree)xPSObject).tag;
                object = deserializer.deserialize(((Tree)xPSObject).firstChild);
                if (((String)object2).equalsIgnoreCase(CREATED)) {
                    xPSObjectImpl.setCreatedDTM((Date)object);
                } else if (((String)object2).equalsIgnoreCase(MODIFIED)) {
                    xPSObjectImpl.setModifiedDTM((Date)object);
                } else if (((String)object2).equalsIgnoreCase(UPDATED_BY)) {
                    xPSObjectImpl.setUpdatedBy((String)object);
                } else if (((String)object2).equalsIgnoreCase(METHOD)) {
                    xPSObjectImpl.setUpdateMethod((Integer)object);
                } else {
                    throw new XPSException("metadata", object2);
                }
                xPSObject = ((Tree)xPSObject).nextSibling;
            }
            tree5 = tree5.nextSibling;
        }
        if (tree5.tag.equalsIgnoreCase(ATTRIBUTES)) {
            xPSObject = tree5.firstChild;
            while (xPSObject != null) {
                object2 = ((Tree)xPSObject).firstChild;
                object = iClass.getAttribute(((Tree)object2).value);
                if (object == null) {
                    System.out.printf("attribute does not exist: %s\n", ((Tree)object2).value);
                } else {
                    Tree tree6 = ((Tree)object2).nextSibling;
                    while (tree6 != null) {
                        Object object3 = deserializer.deserialize(tree6);
                        if (object.getDataType() == IAttribute.DataType.Link) {
                            String string4 = (String)object3;
                            XPSObject xPSObject4 = session.makeStub(string4);
                            object3 = xPSObject4;
                        }
                        xPSObjectImpl.addProperty((IAttribute)object, object3);
                        tree6 = tree6.nextSibling;
                    }
                }
                xPSObject = ((Tree)xPSObject).nextSibling;
            }
            tree5 = tree5.nextSibling;
        }
        if (tree5 != null) {
            throw new XPSException("wrong tag", tree5.tag);
        }
        if (xPSObject2 != null) {
            if (session.version < 2) {
                session.objectCacheNew.insert(xPSObject3, false);
            } else {
                xPSObject3.impl.transferTo(xPSObject2.impl);
            }
            return xPSObject2;
        }
        session.objectCache.insert(xPSObject3, false);
        return xPSObject3;
    }

    public void serialize(Object object, Serializer serializer) {
        Object object2;
        OutStream outStream = serializer.getOutStream();
        outStream.startElement(this.getName());
        XPSObjectImpl xPSObjectImpl = ((XPSObject)object).getImpl();
        if (xPSObjectImpl == null) {
            outStream.endElement();
            return;
        }
        String string = xPSObjectImpl.getBaseClass().getFQName();
        outStream.value(CLASS, string);
        String string2 = xPSObjectImpl.getXid();
        outStream.value(LINK, string2);
        int n = xPSObjectImpl.getRid();
        outStream.startElement(RID);
        serializer.serialize((Object)n);
        outStream.endElement();
        XPSObject xPSObject = xPSObjectImpl.getParent();
        if (xPSObject != null) {
            object2 = xPSObject.getXid();
            if (!Utilities.isValidXid((String)object2)) {
                throw new XPSException("object.parent.xid", string2);
            }
            outStream.value(PARENT, (String)object2);
        }
        outStream.startElement(ATTRIBUTES);
        object2 = xPSObjectImpl.getRawProperties();
        Set set = object2.entrySet();
        for (Map.Entry entry : set) {
            IAttribute iAttribute = (IAttribute)entry.getKey();
            String string3 = iAttribute.getAppropriateName();
            outStream.startElement(ATTRIBUTE);
            outStream.value(NAME, string3);
            Object v = entry.getValue();
            if (v instanceof Collection) {
                for (Object e : (Collection)v) {
                    this.serializeAttributeValue(e, iAttribute, serializer);
                }
            } else {
                this.serializeAttributeValue(v, iAttribute, serializer);
            }
            outStream.endElement();
        }
        outStream.endElement();
        outStream.endElement();
    }

    private void serializeAttributeValue(Object object, IAttribute iAttribute, Serializer serializer) {
        if (object == null) {
            throw new XPSException("object.attribute.value.missing", iAttribute.getFQName());
        }
        IAttribute.DataType dataType = iAttribute.getDataType();
        if (dataType == IAttribute.DataType.Link && object instanceof XPSObject) {
            XPSObject xPSObject = (XPSObject)object;
            String string = xPSObject.getXid();
            if (!Utilities.isValidXid(string)) {
                throw new XPSException("object.link.xid.missing", iAttribute.getFQName());
            }
            object = string;
        }
        serializer.serialize(object);
    }

    private String getXid(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        if (string == null) {
            string = xPSObject.getImpl().getBaseClass().getFQName() + "@<null>";
        }
        return string;
    }

    public void format(Object object, Formatter formatter) {
        XPSObject xPSObject = (XPSObject)object;
        XPSObjectImpl xPSObjectImpl = xPSObject.getImpl();
        String string = this.getXid(xPSObject);
        this.reg.format(formatter, (Object)string);
        formatter.endElement(true);
        XPSObject xPSObject2 = xPSObjectImpl.getParent();
        if (xPSObject2 != null) {
            this.formatEntry("pxid", this.getXid(xPSObject2), formatter);
        }
        Map<IAttribute, Object> map = xPSObjectImpl.getRawProperties();
        Set<Map.Entry<IAttribute, Object>> set = map.entrySet();
        for (Map.Entry<IAttribute, Object> entry : set) {
            IAttribute iAttribute = entry.getKey();
            Object object2 = entry.getValue();
            this.formatEntry(iAttribute.getAppropriateName(), object2, formatter);
        }
        formatter.endProperties((Type)this);
    }

    private void formatOne(Object object, Formatter formatter) {
        if (object == null) {
            object = "<null>";
        } else if (object instanceof XPSObject) {
            XPSObject xPSObject = (XPSObject)object;
            object = this.getXid(xPSObject);
        }
        this.reg.format(formatter, object);
    }

    void formatEntry(String string, Object object, Formatter formatter) {
        formatter.startKey();
        this.reg.format(formatter, (Object)string);
        formatter.writeKVS();
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.formatOne(e, formatter);
                this.formatOne(", ", formatter);
            }
        } else {
            this.formatOne(object, formatter);
        }
        formatter.endValue(true);
    }
}

