/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericObject
extends XPSObject {
    GenericObject(XPSObjectImpl xPSObjectImpl) {
        super(xPSObjectImpl);
    }

    @Override
    public GenericObject castToGenericObject() {
        return this;
    }

    public GenericObject getParent() {
        XPSObject xPSObject = this.impl.getParent();
        return xPSObject == null ? null : xPSObject.castToGenericObject();
    }

    private static boolean isInstanceOf(XPSObject xPSObject, IClass<?> iClass) {
        if (iClass == null) {
            return false;
        }
        IClass<? extends XPSObject> iClass2 = xPSObject.getBaseClass();
        if (iClass2 == iClass) {
            return true;
        }
        Set<IClass<? extends XPSObject>> set = xPSObject.getExtensions();
        return set != null && set.contains(iClass);
    }

    public void setParent(XPSObject xPSObject) {
        IClass<? extends XPSObject> iClass = this.impl.getBaseClass();
        IClass iClass2 = iClass.getParentClass();
        if (!GenericObject.isInstanceOf(xPSObject, iClass2)) {
            throw new XPSException("wrongParentClass", iClass.getName(), xPSObject.getBaseClass().getName());
        }
        this.impl.setParent(xPSObject);
    }

    @Override
    public GenericObject duplicate() {
        return new GenericObject(this.impl.copy());
    }

    public boolean has(IAttribute iAttribute) {
        return this.impl.hasProp(iAttribute);
    }

    public void clear(IAttribute iAttribute) {
        this.access(true, iAttribute);
        this.impl.clearProp(iAttribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(IAttribute iAttribute, Object object) {
        this.access(true, iAttribute);
        if (iAttribute.isList()) {
            if (!(object instanceof List)) throw new IllegalArgumentException(iAttribute.getFQName());
            this.setList(iAttribute, (List)object);
            return;
        } else {
            this.setSingle(iAttribute, object);
        }
    }

    public <T> T get(IAttribute iAttribute) {
        this.access(false, iAttribute);
        if (iAttribute.isList()) {
            return (T)this.getList(iAttribute);
        }
        return (T)this.getSingle(iAttribute);
    }

    private GenericObject getLink(IAttribute iAttribute) {
        this.verify(false, iAttribute, IAttribute.DataType.Link, false);
        return this.impl.getLink(iAttribute).castToGenericObject();
    }

    private void setLink(IAttribute iAttribute, XPSObject xPSObject) {
        this.verify(true, iAttribute, IAttribute.DataType.Link, false);
        this.impl.setLink(iAttribute, xPSObject);
    }

    private List<GenericObject> getLinkList(IAttribute iAttribute) {
        this.verify(false, iAttribute, IAttribute.DataType.Link, true);
        return this.impl.getLinkList(iAttribute, GenericObject.class);
    }

    private void setLinkList(IAttribute iAttribute, List<? extends XPSObject> list) {
        this.verify(true, iAttribute, IAttribute.DataType.Link, true);
        this.impl.setLinkList(iAttribute, list);
    }

    private <T> void setSingle(IAttribute iAttribute, T t) {
        if (t instanceof Collection) {
            throw new XPSException("valueType");
        }
        this.verifyValueType(iAttribute, t);
        if (t instanceof XPSObject) {
            this.impl.setLink(iAttribute, (XPSObject)t);
        } else if (t instanceof ValuedEnum) {
            ValuedEnum valuedEnum = (ValuedEnum)t;
            this.impl.setProperty(iAttribute, valuedEnum.getValue());
        } else {
            this.impl.setProperty(iAttribute, t);
        }
    }

    private <T extends XPSObject> void setList(IAttribute iAttribute, List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("nullValue");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("emptyList");
        }
        T t = list.get(0);
        this.verifyValueType(iAttribute, t);
        if (t instanceof XPSObject) {
            this.setLinkList(iAttribute, list);
        } else {
            this.impl.setListProperty(iAttribute, list);
        }
    }

    private Object getSingle(IAttribute iAttribute) {
        if (iAttribute.getDataType() == IAttribute.DataType.Link) {
            return this.impl.getLink(iAttribute);
        }
        return this.impl.getProperty(iAttribute);
    }

    private Object getList(IAttribute iAttribute) {
        if (iAttribute.getDataType() == IAttribute.DataType.Link) {
            return this.impl.getLinkList(iAttribute);
        }
        return this.impl.getListProperty(iAttribute);
    }

    private void verify(boolean bl, IAttribute iAttribute, IAttribute.DataType dataType, boolean bl2) {
        this.access(bl, iAttribute);
        if (iAttribute.getDataType() != dataType) {
            throw new XPSException("wrongDataType", iAttribute.getFQName(), dataType.name());
        }
        if (iAttribute.isList() != bl2) {
            throw new XPSException("wrongCardinality", iAttribute.getFQName(), bl2);
        }
    }

    private boolean canRead(IAttribute iAttribute) {
        IAttribute.APIAccess aPIAccess = iAttribute.getAPIAccess();
        return aPIAccess == IAttribute.APIAccess.All || aPIAccess == IAttribute.APIAccess.ReadOnly;
    }

    private boolean canWrite(IAttribute iAttribute) {
        IAttribute.APIAccess aPIAccess = iAttribute.getAPIAccess();
        return aPIAccess == IAttribute.APIAccess.All || aPIAccess == IAttribute.APIAccess.WriteOnly;
    }

    private void access(boolean bl, IAttribute iAttribute) {
        IClass<? extends XPSObject> iClass = this.impl.getBaseClass();
        IAttribute iAttribute2 = iClass.getAttribute(iAttribute.getFQName());
        if (iAttribute2 == null) {
            throw new XPSException("attribute", iAttribute.getFQName(), iClass.getFQName());
        }
        if (bl) {
            if (!this.canWrite(iAttribute2)) {
                throw new XPSException("access", iAttribute.getFQName(), "write");
            }
        } else if (!this.canRead(iAttribute2)) {
            throw new XPSException("access", iAttribute.getFQName(), "read");
        }
    }

    private void verifyValueType(IAttribute iAttribute, Object object) {
        boolean bl;
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        switch (iAttribute.getDataType()) {
            case String: {
                bl = object instanceof String;
                break;
            }
            case Integer: {
                bl = object instanceof Number || object instanceof ValuedEnum || object instanceof Set;
                break;
            }
            case DateTime: {
                bl = object instanceof Date;
                break;
            }
            case Boolean: {
                bl = object instanceof Boolean;
                break;
            }
            case Link: {
                bl = object instanceof XPSObject;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (!bl) {
            throw new XPSException("valueTypeMatch", iAttribute.getDataType().name(), object.getClass().getSimpleName());
        }
    }

    public Set<Attribute> getAttributes() {
        return this.impl.getAttributes();
    }

    public Set<Map.Entry<IAttribute, Object>> getProperties() {
        return this.impl.getProperties().entrySet();
    }

    private IAttribute getAttr(String string) {
        IAttribute iAttribute = this.impl.getBaseClass().getAttribute(string);
        if (iAttribute == null) {
            throw new IllegalArgumentException("Class " + this.impl.getBaseClass().getFQName() + " does not have attribute " + string);
        }
        return iAttribute;
    }

    public void putProperty(String string, Object object) {
        IAttribute iAttribute = this.getAttr(string);
        this.set(iAttribute, object);
    }

    public Object getProperty(String string) {
        IAttribute iAttribute = this.getAttr(string);
        return this.get(iAttribute);
    }

    public void clearProperty(String string) {
        IAttribute iAttribute = this.getAttr(string);
        this.clear(iAttribute);
    }
}

