/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.TunnelConnection;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.netegrity.sdk.apiutil.SmApiConnection;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import netegrity.siteminder.javaagent.AgentAPI;
import netegrity.siteminder.javaagent.Attribute;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.RealmDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.SessionDef;
import netegrity.siteminder.javaagent.UserCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHelper
implements ContextConstants {
    public AgentAPI agentapi;
    String sessionTicket;
    String userName;
    String userPwd;
    String userDn;
    SessionDef sessionDef = new SessionDef();
    static Map<String, String> properties;
    public static final String ADMIN_NAME = "PS_ADMIN_NAME";
    public static final String ADMIN_PWD = "PS_ADMIN_PWD";
    public static final String PS_IP = "PS_IP";

    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.userName != null) {
            hashMap.put("userId", this.userName);
        }
        if (this.sessionTicket != null) {
            hashMap.put("sessionTicket", this.sessionTicket);
        }
        if (this.agentapi != null) {
            hashMap.put("connection", this.agentapi);
        }
        return hashMap;
    }

    public AgentAPI connect(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PS_IP, string);
        return this.connect(hashMap);
    }

    public AgentAPI connect(String string, int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PS_IP, string);
        hashMap.put("PS_TIMEOUT", Integer.toString(n));
        return this.connect(hashMap);
    }

    public AgentAPI connect(Map<String, String> map) {
        properties = map;
        this.agentapi = TunnelConnection.create(map);
        return this.agentapi;
    }

    private boolean ResourceToMap(String string, Map<String, String> map) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            System.out.println("cannot open resource: " + string);
            return false;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        System.out.println(string + " size: " + properties.size());
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            map.put(string2, string3);
        }
        return true;
    }

    public synchronized Map<String, String> propertiesToMap(String ... stringArray) throws IOException {
        if (properties != null) {
            return properties;
        }
        properties = new HashMap<String, String>();
        for (String string : stringArray) {
            if (!this.ResourceToMap(string, properties)) continue;
            String string2 = string + ".local";
            this.ResourceToMap(string2, properties);
            break;
        }
        return properties;
    }

    public String AgentAPI_login() {
        String string = properties.get("USERDIR_NAMESPACE");
        if (string.equals("ODBC:")) {
            this.userName = properties.get("ODBC_USERNAME1");
            this.userPwd = properties.get("ODBC_PASSWORD1");
        } else if (string.equals("LDAP:")) {
            this.userName = properties.get("LDAP_USERNAME1");
            this.userPwd = properties.get("LDAP_PASSWORD1");
        }
        String string2 = "127.0.0.1";
        String string3 = "resource" + System.currentTimeMillis();
        return this.AgentAPI_login(this.userName, this.userPwd, string2, string3);
    }

    public String AgentAPI_login(String string, String string2, String string3, String string4) {
        this.userName = string;
        if (string4 == null || string4.length() == 0) {
            string4 = "/";
        }
        ResourceContextDef resourceContextDef = new ResourceContextDef("", "", string4, "GET");
        RealmDef realmDef = new RealmDef();
        int n = this.agentapi.isProtected(string3, resourceContextDef, realmDef);
        UserCredentials userCredentials = new UserCredentials(string, string2);
        AttributeList attributeList = new AttributeList();
        n = this.agentapi.login(string3, resourceContextDef, realmDef, userCredentials, this.sessionDef, attributeList);
        if (n != 1) {
            throw new RuntimeException("login failed");
        }
        Enumeration enumeration = attributeList.attributes();
        byte[] byArray = new byte[]{0};
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (attribute.id != 218) continue;
            byArray = attribute.value;
            this.userDn = new String(byArray);
        }
        this.sessionTicket = this.sessionDef.spec;
        return this.sessionTicket;
    }

    public String getSessionTicket() {
        return this.sessionTicket;
    }

    public String PMAPI_login(String string, String string2) {
        this.userName = string;
        SmApiSession smApiSession = new SmApiSession(new SmApiConnection(this.agentapi));
        SmApiResult smApiResult = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            smApiResult = smApiSession.login(string, string2, inetAddress, 0);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (!smApiResult.isSuccess()) {
            throw new RuntimeException("login " + string + " " + string2);
        }
        this.sessionTicket = smApiSession.getSessionSpec();
        return this.sessionTicket;
    }

    public String PMAPI_login() throws Exception {
        String string = properties.get(ADMIN_NAME);
        String string2 = properties.get(ADMIN_PWD);
        if (string == null) {
            throw new XPSException("admin name is not specified");
        }
        if (string2 == null) {
            throw new XPSException("admin password is not specified");
        }
        return this.PMAPI_login(string, string2);
    }
}

