/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageException;
import com.ca.siteminder.sdk.agentapi.resources.SmCryptoMessages;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.ResourceBundle;

public class SmPasswordMessage
implements SmAgentApiCommonConstants {
    private static final String MESSAGES_CLASSNAME = SmCryptoMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final int PWDMSG_VERSION = 1;
    private static final int SIZEOF_INT = 4;
    private static int c_FieldsTotal = 0;
    private static int[] c_MessageIDs = null;
    private String m_algorithm = null;
    private int m_version = 1;
    private int m_msgID = 0;
    private int m_length = 0;
    private int m_fieldNum = 0;
    private byte[][] m_fields = null;

    public SmPasswordMessage() throws SmPasswordMessageException {
        this("MD5");
    }

    public SmPasswordMessage(String string) throws SmPasswordMessageException {
        if (c_FieldsTotal == 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_FIELDS_INIT_ERROR"));
        }
        if (c_MessageIDs == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_MSGIDS_INIT_ERROR"));
        }
        this.m_algorithm = string;
        this.m_fields = new byte[c_FieldsTotal][];
        Arrays.fill((Object[])this.m_fields, null);
    }

    public void parse(String string) throws SmPasswordMessageException, SmCryptoProviderException, NoSuchAlgorithmException {
        if (string == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_TOO_SHORT"));
        }
        try {
            byte[] byArray = SmCryptoProvider.base64decode(string.getBytes("UTF-8"));
            MessageDigest messageDigest = MessageDigest.getInstance(this.m_algorithm, (Provider)new JsafeJCE());
            int n2 = messageDigest.getDigestLength();
            if (byArray.length < n2 + 16) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_TOO_SHORT"));
            }
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[byArray.length - n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            this.m_version = byteBuffer.getInt();
            this.m_msgID = byteBuffer.getInt();
            this.m_length = byteBuffer.getInt();
            this.m_fieldNum = byteBuffer.getInt();
            this.validateVersion(this.m_version);
            this.validatePasswordMessageID(this.m_msgID);
            if (this.m_length != byArray.length) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_LENGTH") + String.valueOf(this.m_length));
            }
            if (this.m_fieldNum < 0) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELDNUM") + String.valueOf(this.m_fieldNum));
            }
            if (!MessageDigest.isEqual(byArray2, messageDigest.digest(byArray3))) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_DIGEST_MISMATCH"));
            }
            for (int i2 = 0; i2 < this.m_fieldNum; ++i2) {
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                this.validatePasswordField(n3);
                if (n4 <= 0) {
                    throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELD_SIZE") + String.valueOf(n4));
                }
                this.m_fields[n3] = new byte[n4];
                byteBuffer.get(this.m_fields[n3]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SmPasswordMessageException(unsupportedEncodingException);
        }
    }

    public String write() throws SmPasswordMessageException, SmCryptoProviderException, NoSuchAlgorithmException {
        byte[] byArray;
        this.validateVersion(this.m_version);
        if (this.m_fieldNum < 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELDNUM") + String.valueOf(this.m_fieldNum));
        }
        MessageDigest messageDigest = MessageDigest.getInstance(this.m_algorithm, (Provider)new JsafeJCE());
        int n2 = messageDigest.getDigestLength();
        this.m_length = n2 + 16;
        for (int i2 = 0; i2 < c_FieldsTotal; ++i2) {
            byte[] byArray2 = this.m_fields[i2];
            if (byArray2 == null) continue;
            this.m_length += byArray2.length + 8;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.m_length - n2);
        byteBuffer.putInt(this.m_version);
        byteBuffer.putInt(this.m_msgID);
        byteBuffer.putInt(this.m_length);
        byteBuffer.putInt(this.m_fieldNum);
        for (int i3 = 0; i3 < c_FieldsTotal; ++i3) {
            byArray = this.m_fields[i3];
            if (byArray == null) continue;
            byteBuffer.putInt(i3);
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        }
        byte[] byArray3 = byteBuffer.array();
        byArray = messageDigest.digest(byArray3);
        byte[] byArray4 = new byte[this.m_length];
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        System.arraycopy(byArray3, 0, byArray4, n2, this.m_length - n2);
        try {
            return new String(SmCryptoProvider.base64encode(byArray4), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SmPasswordMessageException(unsupportedEncodingException);
        }
    }

    public void erase() {
        this.m_version = 1;
        this.m_msgID = 0;
        this.m_length = 0;
        this.m_fieldNum = 0;
        this.m_fields = new byte[c_FieldsTotal][];
        Arrays.fill((Object[])this.m_fields, null);
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int n2) throws SmPasswordMessageException {
        this.validateVersion(n2);
        this.m_version = n2;
    }

    public int getMessageID() {
        return this.m_msgID;
    }

    public void setMessageID(int n2) throws SmPasswordMessageException {
        this.validatePasswordMessageID(n2);
        this.m_msgID = n2;
    }

    public int getNumberOfFields() {
        return this.m_fieldNum;
    }

    public String getField(int n2) throws SmPasswordMessageException {
        this.validatePasswordField(n2);
        return new String(this.m_fields[n2]);
    }

    public int getFieldInt(int n2) throws SmPasswordMessageException {
        this.validatePasswordField(n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.m_fields[n2]);
        return byteBuffer.getInt();
    }

    public void setField(int n2, String string) throws SmPasswordMessageException {
        this.validatePasswordField(n2);
        byte[] byArray = this.m_fields[n2];
        if (byArray == null && string != null) {
            ++this.m_fieldNum;
        } else if (byArray != null && string == null) {
            --this.m_fieldNum;
        }
        if (string != null) {
            try {
                this.m_fields[n2] = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SmPasswordMessageException(unsupportedEncodingException);
            }
        } else {
            this.m_fields[n2] = null;
        }
    }

    public void setField(int n2, int n3) throws SmPasswordMessageException {
        this.validatePasswordField(n2);
        byte[] byArray = this.m_fields[n2];
        if (byArray == null) {
            this.m_fields[n2] = new byte[4];
            ++this.m_fieldNum;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.m_fields[n2]);
        byteBuffer.putInt(n3);
    }

    public void removeField(int n2) throws SmPasswordMessageException {
        this.setField(n2, null);
    }

    private void validateVersion(int n2) throws SmPasswordMessageException {
        if (n2 > 1 || n2 <= 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_VERSION") + String.valueOf(n2));
        }
    }

    private void validatePasswordMessageID(int n2) throws SmPasswordMessageException {
        if (c_MessageIDs == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_MSGID") + String.valueOf(n2));
        }
        for (int i2 = 0; i2 < c_MessageIDs.length; ++i2) {
            if (c_MessageIDs[i2] != n2) continue;
            return;
        }
        throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_MSGID") + String.valueOf(n2));
    }

    private void validatePasswordField(int n2) throws SmPasswordMessageException {
        if (n2 < 0 || n2 >= c_FieldsTotal) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELD") + String.valueOf(n2));
        }
    }

    static {
        try {
            c_FieldsTotal = Class.forName("com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageFields").getFields().length;
        }
        catch (Throwable throwable) {
            c_FieldsTotal = 0;
            throwable.printStackTrace();
        }
        try {
            Field[] fieldArray = Class.forName("com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageIDs").getFields();
            c_MessageIDs = new int[fieldArray.length];
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                SmPasswordMessage.c_MessageIDs[i2] = fieldArray[i2].getInt(null);
            }
        }
        catch (Throwable throwable) {
            c_MessageIDs = null;
            throwable.printStackTrace();
        }
    }
}

