/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import com.ca.siteminder.sdk.agentapi.UtilLog;
import com.ca.siteminder.sdk.agentapi.crypto.SmAesCryptoTliProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmDES3CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2HmacSHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2SHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC4SHA1CryptoProvider;
import com.ca.siteminder.sdk.agentapi.resources.SmCryptoMessages;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public abstract class SmCryptoProvider
implements SmAgentApiCommonConstants {
    private static final String CLASS_NAME = "SmCryptoProvider";
    public static final int KEY_SIZE = 24;
    public static final int SESSION_KEY_SIZE = 48;
    public static final int MINIMAL_KEY_STRENGTH = 56;
    public static final int DEFAULT_KEY_STRENGTH = 128;
    protected static final String MESSAGES_CLASSNAME = SmCryptoMessages.getName();
    protected static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    protected String m_transformation = null;
    protected String m_algorithm = null;
    protected String m_digestAlg = null;
    protected String m_keyDigestAlg = null;
    protected int m_keyStrength = 128;
    protected boolean m_verifyDigest = false;
    protected boolean m_bAscii = false;
    protected int m_keySize = 24;
    protected static JsafeJCE m_provider = new JsafeJCE();
    protected byte[] m_initVector = null;
    protected Key m_encryptKey = null;
    protected Key m_decryptKey = null;
    protected Cipher m_encrypter = null;
    protected Cipher m_decrypter = null;
    protected int m_digestLength = 0;
    protected boolean m_bCipherCanDoFinal = true;

    public static SmCryptoProvider getInstance(String string, String string2, boolean bl) throws SmCryptoProviderException {
        SmCryptoProvider smCryptoProvider = null;
        if ("RC2".equals(string)) {
            smCryptoProvider = new SmRC2CryptoProvider(string2, bl);
        } else if ("RC2/SHA".equals(string)) {
            smCryptoProvider = new SmRC2SHA1CryptoProvider(string2, bl);
        }
        if ("RC2/HmacSHA1".equals(string)) {
            smCryptoProvider = new SmRC2HmacSHA1CryptoProvider(string2, bl);
        } else if ("RC4/SHA".equals(string)) {
            smCryptoProvider = new SmRC4SHA1CryptoProvider(string2, bl);
        } else if ("DES3".equals(string)) {
            smCryptoProvider = new SmDES3CryptoProvider(string2, bl);
        } else if ("AES-TLI".equals(string)) {
            smCryptoProvider = new SmAesCryptoTliProvider();
        }
        if (smCryptoProvider == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_UNSUPPORTED_PROVIDER") + string);
        }
        return smCryptoProvider;
    }

    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl) throws SmCryptoProviderException {
        if (n2 < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(n2));
        }
        try {
            this.m_keyStrength = n2;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(byArray);
            this.setDecryptKey(byArray2);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(byArray3, bl);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public void init(Key key, byte[] byArray, byte[] byArray2, int n2, boolean bl) throws SmCryptoProviderException {
        if (n2 < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(n2));
        }
        try {
            this.m_keyStrength = n2;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(key);
            this.setDecryptKey(byArray);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(byArray2, bl);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public void init(byte[] byArray, Key key, byte[] byArray2, int n2, boolean bl) throws SmCryptoProviderException {
        if (n2 < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(n2));
        }
        try {
            this.m_keyStrength = n2;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(byArray);
            this.setDecryptKey(key);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(byArray2, bl);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public void init(Key key, Key key2, byte[] byArray, int n2, boolean bl) throws SmCryptoProviderException {
        if (n2 < 56) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_STRENGTH") + String.valueOf(n2));
        }
        try {
            this.m_keyStrength = n2;
            UtilLog.display(5, CLASS_NAME, "init", "Setting keys");
            this.setEncryptKey(key);
            this.setDecryptKey(key2);
            UtilLog.display(5, CLASS_NAME, "init", "Setting IV");
            this.setInitVector(byArray, bl);
            UtilLog.display(5, CLASS_NAME, "init", "Initializing params");
            this.initParams();
            this.m_encrypter = null;
            this.m_decrypter = null;
            UtilLog.display(5, CLASS_NAME, "init", "Init complete");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public void init(byte[] byArray, int n2) throws SmCryptoProviderException {
    }

    public byte[] encrypt(byte[] byArray) throws SmCryptoProviderException {
        if (byArray == null) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.encrypt(byArray, byArray.length);
    }

    public byte[] encrypt(byte[] byArray, int n2) throws SmCryptoProviderException {
        if (byArray == null || n2 <= 0 || n2 > byArray.length) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (UtilLog.isLogEnabled()) {
            UtilLog.display(5, CLASS_NAME, "encrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + n2);
        }
        try {
            if (this.m_encrypter == null) {
                UtilLog.display(5, CLASS_NAME, "encrypt", "Getting encrypter");
                this.m_encrypter = this.getEncrypter();
                UtilLog.display(5, CLASS_NAME, "encrypt", "Got encrypter");
            }
            byte[] byArray2 = null;
            byte[] byArray3 = this.makeDigest(byArray, n2, true);
            if (byArray3 != null) {
                int n3 = this.m_encrypter.getOutputSize(byArray3.length + n2);
                byArray2 = new byte[n3];
                int n4 = this.m_encrypter.update(byArray3, 0, byArray3.length, byArray2);
                int n5 = this.m_encrypter.update(byArray, 0, n2, byArray2, n4);
                if (this.m_bCipherCanDoFinal) {
                    this.m_encrypter.doFinal(byArray2, n4 + n5);
                }
            } else {
                byArray2 = this.m_bCipherCanDoFinal ? this.m_encrypter.doFinal(byArray, 0, n2) : this.m_encrypter.update(byArray, 0, n2);
            }
            if (this.m_bAscii) {
                byArray2 = SmCryptoProvider.base64encode(byArray2);
            }
            return byArray2;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public byte[] decrypt(byte[] byArray) throws SmCryptoProviderException {
        if (byArray == null) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return this.decrypt(byArray, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, int n2) throws SmCryptoProviderException {
        if (byArray == null || n2 <= 0 || n2 > byArray.length) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        if (UtilLog.isLogEnabled()) {
            UtilLog.display(5, CLASS_NAME, "decrypt", "Using crypto provider = " + this.getClass().getName() + ", on input length = " + n2);
        }
        try {
            byte[] byArray2;
            int n3;
            if (this.m_decrypter == null) {
                UtilLog.display(5, CLASS_NAME, "decrypt", "Getting decrypter");
                this.m_decrypter = this.getDecrypter();
                UtilLog.display(5, CLASS_NAME, "decrypt", "Got decrypter");
            }
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            if (this.m_bAscii) {
                byArray = SmCryptoProvider.base64decode(byArray, n2);
                n2 = byArray.length;
            }
            if ((n3 = this.getDigestLength()) > 0) {
                byArray4 = new byte[n3];
                byArray2 = this.m_bCipherCanDoFinal ? this.m_decrypter.doFinal(byArray, 0, n2) : this.m_decrypter.update(byArray, 0, n2);
                byArray3 = new byte[byArray2.length - byArray4.length];
                System.arraycopy(byArray2, 0, byArray4, 0, byArray4.length);
                System.arraycopy(byArray2, byArray4.length, byArray3, 0, byArray3.length);
            } else {
                byArray3 = this.m_bCipherCanDoFinal ? this.m_decrypter.doFinal(byArray, 0, n2) : this.m_decrypter.update(byArray, 0, n2);
            }
            if (this.m_verifyDigest && !MessageDigest.isEqual(byArray4, byArray2 = this.makeDigest(byArray3, false))) {
                throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_DIGEST_MISMATCH"));
            }
            return byArray3;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public static byte[] digest(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string, (Provider)new JsafeJCE());
        return messageDigest.digest(byArray);
    }

    public static byte[] base64encode(byte[] byArray) throws SmCryptoProviderException {
        if (byArray == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return SmCryptoProvider.base64encode(byArray, byArray.length);
    }

    public static byte[] base64encode(byte[] byArray, int n2) throws SmCryptoProviderException {
        if (byArray == null || n2 <= 0 || n2 > byArray.length) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            jSAFE_Recode.encodeInit();
            int n3 = jSAFE_Recode.getOutputBufferSize(n2);
            byte[] byArray2 = new byte[n3];
            int n4 = jSAFE_Recode.encodeUpdate(byArray, 0, n2, byArray2, 0);
            n4 += jSAFE_Recode.encodeFinal(byArray2, n4);
            if (n4 == n3) {
                return byArray2;
            }
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new SmCryptoProviderException(jSAFE_Exception);
        }
    }

    public static byte[] base64decode(byte[] byArray) throws SmCryptoProviderException {
        if (byArray == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        return SmCryptoProvider.base64decode(byArray, byArray.length);
    }

    public static byte[] base64decode(byte[] byArray, int n2) throws SmCryptoProviderException {
        if (byArray == null || n2 <= 0 || n2 > byArray.length) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        try {
            JSAFE_Recode jSAFE_Recode = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            jSAFE_Recode.decodeInit();
            int n3 = jSAFE_Recode.getOutputBufferSize(n2);
            byte[] byArray2 = new byte[n3];
            int n4 = jSAFE_Recode.decodeUpdate(byArray, 0, n2, byArray2, 0);
            n4 += jSAFE_Recode.decodeFinal(byArray2, n4);
            if (n4 == n3) {
                return byArray2;
            }
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            return byArray3;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new SmCryptoProviderException(jSAFE_Exception);
        }
    }

    public abstract Key generateKey() throws SmCryptoProviderException;

    protected void setEncryptKey(byte[] byArray) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (byArray == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        byte[] byArray2 = this.generateKeyData(byArray);
        this.m_encryptKey = new SecretKeySpec(byArray2, this.m_algorithm);
    }

    protected void setDecryptKey(byte[] byArray) throws NoSuchAlgorithmException, SmCryptoProviderException {
        if (byArray == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        byte[] byArray2 = this.generateKeyData(byArray);
        this.m_decryptKey = new SecretKeySpec(byArray2, this.m_algorithm);
    }

    protected void setEncryptKey(Key key) throws SmCryptoProviderException {
        if (key == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_ENCRYPTION_KEY"));
        }
        if (key.getAlgorithm() == null || !key.getAlgorithm().equals(this.m_algorithm)) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + key.getAlgorithm());
        }
        this.m_encryptKey = key;
    }

    protected void setDecryptKey(Key key) throws SmCryptoProviderException {
        if (key == null) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_DECRYPTION_KEY"));
        }
        if (key.getAlgorithm() == null || !key.getAlgorithm().equals(this.m_algorithm)) {
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_KEY_ALGORITHM") + key.getAlgorithm());
        }
        this.m_decryptKey = key;
    }

    protected void setInitVector(byte[] byArray, boolean bl) throws GeneralSecurityException, SmCryptoProviderException {
        this.m_initVector = byArray;
        if (this.m_initVector == null) {
            int n2 = this.getBlockSize();
            byte[] byArray2 = null;
            byArray2 = bl ? this.m_encryptKey.getEncoded() : this.m_decryptKey.getEncoded();
            if (byArray2 == null || byArray2.length < n2) {
                String string = null;
                try {
                    string = new String(byArray2, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SmCryptoProviderException(unsupportedEncodingException);
                }
                throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INIT_VECTOR") + string);
            }
            this.m_initVector = new byte[n2];
            System.arraycopy(byArray2, 0, this.m_initVector, 0, n2);
        }
    }

    protected void initParams() throws SmCryptoProviderException {
    }

    protected abstract Cipher getEncrypter() throws GeneralSecurityException, SmCryptoProviderException;

    protected abstract Cipher getDecrypter() throws GeneralSecurityException, SmCryptoProviderException;

    protected byte[] makeDigest(byte[] byArray, boolean bl) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected byte[] makeDigest(byte[] byArray, int n2, boolean bl) throws GeneralSecurityException, SmCryptoProviderException {
        return null;
    }

    protected int getDigestLength() {
        return this.m_digestLength;
    }

    protected int getBlockSize() throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        return cipher.getBlockSize();
    }

    protected byte[] generateKeyData(byte[] byArray) throws NoSuchAlgorithmException {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[this.m_keySize];
        byte[] byArray3 = byArray;
        if (this.m_keyDigestAlg != null) {
            MessageDigest messageDigest = MessageDigest.getInstance(this.m_keyDigestAlg, (Provider)m_provider);
            byArray3 = messageDigest.digest(byArray);
        }
        if (byArray3.length >= this.m_keySize) {
            System.arraycopy(byArray3, 0, byArray2, 0, this.m_keySize);
        } else {
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            Arrays.fill(byArray2, byArray3.length, this.m_keySize, (byte)0);
        }
        return byArray2;
    }
}

