/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;

class SmRC4SHA1CryptoProvider
extends SmCryptoProvider {
    protected MessageDigest m_md = null;

    SmRC4SHA1CryptoProvider(String string, boolean bl) throws SmCryptoProviderException {
        this.m_transformation = "RC4";
        this.m_algorithm = "RC4";
        this.m_digestAlg = "SHA";
        this.m_keyDigestAlg = string;
        this.m_verifyDigest = true;
        this.m_bAscii = bl;
        try {
            this.m_md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
            this.m_digestLength = this.m_md.getDigestLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmCryptoProviderException(noSuchAlgorithmException);
        }
        this.m_keySize = 16;
        this.m_bCipherCanDoFinal = false;
    }

    public Key generateKey() throws SmCryptoProviderException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.m_algorithm, (Provider)m_provider);
            keyGenerator.init(this.m_keyStrength, SmSecureRandom.get());
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmCryptoProviderException(noSuchAlgorithmException);
        }
    }

    protected Cipher getEncrypter() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(1, this.m_encryptKey, SmSecureRandom.get());
        return cipher;
    }

    protected Cipher getDecrypter() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(2, this.m_decryptKey, SmSecureRandom.get());
        return cipher;
    }

    protected byte[] makeDigest(byte[] byArray, boolean bl) throws NoSuchAlgorithmException {
        return this.makeDigest(byArray, byArray.length, bl);
    }

    protected byte[] makeDigest(byte[] byArray, int n, boolean bl) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = (MessageDigest)this.m_md.clone();
            messageDigest.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            messageDigest = null;
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        messageDigest.update(this.m_initVector);
        messageDigest.update(byArray, 0, n);
        return messageDigest.digest();
    }
}

