/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

class SmDES3CryptoProvider
extends SmCryptoProvider {
    protected IvParameterSpec m_params = null;

    SmDES3CryptoProvider(String string, boolean bl) throws SmCryptoProviderException {
        this.m_transformation = "DESede/CBC/PKCS5Padding";
        this.m_algorithm = "DESede";
        this.m_keyDigestAlg = string;
        this.m_verifyDigest = false;
        this.m_bAscii = bl;
        try {
            this.m_digestLength = this.getBlockSize();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SmCryptoProviderException(generalSecurityException);
        }
    }

    public Key generateKey() throws SmCryptoProviderException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.m_algorithm, (Provider)m_provider);
            keyGenerator.init(this.m_keyStrength, SmSecureRandom.get());
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmCryptoProviderException(noSuchAlgorithmException);
        }
    }

    protected void initParams() {
        this.m_params = new IvParameterSpec(this.m_initVector);
    }

    protected Cipher getEncrypter() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(1, this.m_encryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }

    protected Cipher getDecrypter() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.m_transformation, (Provider)m_provider);
        cipher.init(2, this.m_decryptKey, this.m_params, SmSecureRandom.get());
        return cipher;
    }

    protected byte[] makeDigest(byte[] byArray, boolean bl) throws GeneralSecurityException {
        return this.makeDigest(byArray, byArray.length, bl);
    }

    protected byte[] makeDigest(byte[] byArray, int n, boolean bl) throws GeneralSecurityException {
        int n2 = this.getDigestLength();
        byte[] byArray2 = new byte[n2];
        SmSecureRandom.nextBytes(byArray2);
        return byArray2;
    }
}

