/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.UtilLog;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.netegrity.util.AesCryptoProviderTli;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;

class SmAesCryptoTliProvider
extends SmCryptoProvider {
    private static final String CLASS_NAME = "SmAesCryptoTliProvider";
    private AesCryptoProviderTli m_AesCryptoProviderTli;

    SmAesCryptoTliProvider() throws SmCryptoProviderException {
        this.m_transformation = "AES/OFB/NoPadding";
        this.m_algorithm = "AES";
        this.m_digestAlg = "HmacSHA256";
        this.m_digestLength = 32;
        this.m_keyDigestAlg = "SHA256";
        this.m_verifyDigest = true;
        this.m_bAscii = false;
        this.m_keySize = 16;
        this.m_bCipherCanDoFinal = false;
        try {
            this.m_AesCryptoProviderTli = new AesCryptoProviderTli();
        }
        catch (Throwable throwable) {
            throw new SmCryptoProviderException(throwable);
        }
    }

    public void init(byte[] byArray, int n) throws SmCryptoProviderException {
        int n2 = this.m_AesCryptoProviderTli.Init(byArray, n, true);
        if (0 != n2) {
            throw new SmCryptoProviderException(c_bundle.getString("M_INIT_SESSION_ERROR"));
        }
    }

    public void init(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, boolean bl) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(Key key, byte[] byArray, byte[] byArray2, int n, boolean bl) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(byte[] byArray, Key key, byte[] byArray2, int n, boolean bl) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public void init(Key key, Key key2, byte[] byArray, int n, boolean bl) throws SmCryptoProviderException {
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    public byte[] encrypt(byte[] byArray, int n) throws SmCryptoProviderException {
        byte[] byArray2 = null;
        if (byArray == null || n < 0 || n > byArray.length) {
            UtilLog.display(3, CLASS_NAME, "encrypt", "Invalid null input to encrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        byArray2 = this.m_AesCryptoProviderTli.Encrypt(byArray, n);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, int n) throws SmCryptoProviderException {
        byte[] byArray2 = null;
        if (byArray == null || n <= 0 || n > byArray.length) {
            UtilLog.display(3, CLASS_NAME, "decrypt", "Invalid null input to decrypt");
            throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
        }
        byArray2 = this.m_AesCryptoProviderTli.Decrypt(byArray, n);
        return byArray2;
    }

    public Key generateKey() throws SmCryptoProviderException {
        Object var1_1 = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected Cipher getEncrypter() throws GeneralSecurityException, SmCryptoProviderException {
        Object var1_1 = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected Cipher getDecrypter() throws GeneralSecurityException, SmCryptoProviderException {
        Object var1_1 = null;
        throw new SmCryptoProviderException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }

    protected int getBlockSize() throws GeneralSecurityException {
        return 16;
    }

    protected byte[] generateKeyData(byte[] byArray) throws NoSuchAlgorithmException {
        if (byArray == null) {
            return null;
        }
        throw new NoSuchAlgorithmException(c_bundle.getString("M_SMCRYPTO_INVALID_INPUT"));
    }
}

