/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;

public class UtilLog
implements SmAgentApiCommonConstants {
    public static final String CLASS_NAME = "UtilLog";
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String DEBUG_ENABLE_PROPERTY = "com.ca.siteminder.sdk.agentapi.enableDebug";
    public static final int LOG_LEVEL_FATAL = 1;
    public static final int LOG_LEVEL_ERROR = 2;
    public static final int LOG_LEVEL_WARNING = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_TRACE = 5;
    public static final String FATAL_LOG_KEY = "SMFATAL: ";
    public static final String WARNING_LOG_KEY = "SMWARNING: ";
    public static final String ERROR_LOG_KEY = "SMERROR: ";
    public static final String INFO_LOG_KEY = "SMINFO: ";
    public static final String TRACE_LOG_KEY = "SMTRACE: ";
    public static final String LOG_PARTS_SEPARATOR = ", ";
    protected static boolean c_logEnabled = Boolean.getBoolean("com.ca.siteminder.sdk.agentapi.enableDebug");
    protected static final String AGENTAPI_BUILD_PROPERTIES = "/smagentapibuild.properties";
    protected static String c_versionInfo;

    public static void display(int n, String string, String string2, String string3) {
        if (!c_logEnabled) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(LOG_PARTS_SEPARATOR);
        stringBuffer.append(string2);
        stringBuffer.append(LOG_PARTS_SEPARATOR);
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        switch (n) {
            case 1: {
                UtilLog.displayFatal(string4);
                break;
            }
            case 2: {
                UtilLog.displayError(string4);
                break;
            }
            case 3: {
                UtilLog.displayWarning(string4);
                break;
            }
            case 4: {
                UtilLog.displayInfo(string4);
                break;
            }
            case 5: {
                UtilLog.displayTrace(string4);
            }
        }
    }

    public static void displayError(String string) {
        UtilLog.displayError(ERROR_LOG_KEY, string);
    }

    public static void displayWarning(String string) {
        UtilLog.displayError(WARNING_LOG_KEY, string);
    }

    public static void displayFatal(String string) {
        UtilLog.displayError(FATAL_LOG_KEY, string);
    }

    public static void displayInfo(String string) {
        UtilLog.displayOut(INFO_LOG_KEY, string);
    }

    public static void displayTrace(String string) {
        UtilLog.displayOut(TRACE_LOG_KEY, string);
    }

    public static boolean isLogEnabled() {
        return c_logEnabled;
    }

    protected static void displayError(String string, String string2) {
        Date date = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.err.println(DATE_FORMAT.format(date) + " [" + Thread.currentThread().getName() + "] " + string + string2);
        }
    }

    protected static void displayOut(String string, String string2) {
        Date date = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.out.println(DATE_FORMAT.format(date) + " [" + Thread.currentThread().getName() + "] " + string + string2);
        }
    }

    static {
        InputStream inputStream = UtilLog.class.getResourceAsStream(AGENTAPI_BUILD_PROPERTIES);
        if (inputStream == null) {
            throw new MissingResourceException("Can't find resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new MissingResourceException("Can't load resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Enumeration<Object> enumeration = properties.keys();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            stringBuffer.append(string + "=" + string2);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(LOG_PARTS_SEPARATOR);
        }
        c_versionInfo = stringBuffer.toString();
        if (c_logEnabled) {
            UtilLog.displayInfo(c_versionInfo);
        }
    }
}

