/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.smerrlog;

import com.netegrity.smerrlog.SmLogException;

public class SmLogger {
    private static final String SM_LOGGER_LIB = "smerrlog";
    public static final int RolloverTruncate = 0;
    public static final int RolloverAppend = 1;
    public static final int RolloverNow = 2;
    public static final int RolloverSize = 3;
    public static final int RolloverNowSize = 4;
    public static final int ConsoleOutput = 0;
    public static final int FileOutput = 1;
    public static final int FormatDefault = 0;
    public static final int FormatFixed = 1;
    public static final int FormatDelim = 2;
    public static final int FormatXML = 3;
    private long m_lLastTimeChecked = 0L;
    private boolean m_bTraceEnabled = false;
    private static boolean m_bLoadedLibrary = false;
    private String m_sLoggerName;

    public SmLogger() throws SmLogException {
        if (!m_bLoadedLibrary) {
            try {
                System.loadLibrary(SM_LOGGER_LIB);
                m_bLoadedLibrary = true;
            }
            catch (UnsatisfiedLinkError e) {
                throw new SmLogException(e, "Failed to load smerrlog");
            }
        }
    }

    public SmLogger(String sLoggerName) throws SmLogException {
        this.m_sLoggerName = sLoggerName;
        if (!m_bLoadedLibrary) {
            try {
                System.loadLibrary(SM_LOGGER_LIB);
                m_bLoadedLibrary = true;
            }
            catch (UnsatisfiedLinkError e) {
                throw new SmLogException(e, "Failed to load smerrlog");
            }
        }
    }

    public int initLog(int iLogOutputType, String sLogFileName, int iRolloverType, int iLogSize, boolean bLocalTime, int iLogCount) {
        return this.InitializeLog(this.m_sLoggerName, iLogOutputType, sLogFileName, iRolloverType, iLogSize, bLocalTime, iLogCount);
    }

    public int initTracing(int iLogOutputType, String sTraceFileName, int iRolloverType, int iTraceSize, int iTraceFormat, String sTraceDelim, String sTraceConfigFile, boolean bLocalTime, int iTraceCount) {
        return this.InitializeTrace(this.m_sLoggerName, iLogOutputType, sTraceFileName, iRolloverType, iTraceSize, iTraceFormat, sTraceDelim, sTraceConfigFile, bLocalTime, iTraceCount);
    }

    public int logMessage(String sFName, int iMsgId, String sArg) {
        return this.LogMsg(this.m_sLoggerName, sFName, iMsgId, sArg);
    }

    public int logMessage(String sFName, int iMsgId, String[] sArgs) {
        return this.LogMsg(this.m_sLoggerName, sFName, iMsgId, sArgs);
    }

    public int traceMessage(String sFName, String sFuncName, int iComponentID, String sTransactID, String sMsg) {
        if (this.shouldTrace()) {
            return this.TraceMsg(this.m_sLoggerName, sFName, sFuncName, iComponentID, sTransactID, sMsg);
        }
        return 0;
    }

    public int traceMessage(String sFName, String sFuncName, int iComponentID, String sTransactID, String sMsg, String[] sArgs) {
        if (this.shouldTrace()) {
            return this.TraceMsg(this.m_sLoggerName, sFName, sFuncName, iComponentID, sTransactID, sMsg, sArgs);
        }
        return 0;
    }

    public boolean shouldTraceComponent(int nComponentID) {
        boolean bTraceEnabled = false;
        bTraceEnabled = this.TraceEnabledComponent(this.m_sLoggerName, nComponentID);
        return bTraceEnabled;
    }

    private boolean shouldTrace() {
        if (this.m_lLastTimeChecked == 0L) {
            this.m_lLastTimeChecked = System.currentTimeMillis();
            this.m_bTraceEnabled = this.TraceEnabled(this.m_sLoggerName);
        } else {
            long lCurrentTime = System.currentTimeMillis();
            if ((lCurrentTime - this.m_lLastTimeChecked) / 1000L > 60L) {
                this.m_lLastTimeChecked = lCurrentTime;
                this.m_bTraceEnabled = this.TraceEnabled(this.m_sLoggerName);
            }
        }
        return this.m_bTraceEnabled;
    }

    private native int InitializeLog(String var1, int var2, String var3, int var4, int var5, boolean var6, int var7);

    private native int InitializeTrace(String var1, int var2, String var3, int var4, int var5, int var6, String var7, String var8, boolean var9, int var10);

    private native int LogMsg(String var1, String var2, int var3, String var4);

    private native int LogMsg(String var1, String var2, int var3, String[] var4);

    private native int TraceMsg(String var1, String var2, String var3, int var4, String var5, String var6);

    private native int TraceMsg(String var1, String var2, String var3, int var4, String var5, String var6, String[] var7);

    private native boolean TraceEnabled(String var1);

    private native boolean TraceEnabledComponent(String var1, int var2);
}

