/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.smerrlog;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SmLogException
extends Exception {
    private Throwable cause = null;

    public SmLogException(String msg) {
        super(msg);
    }

    public SmLogException(Throwable cause, String msg) {
        super(msg);
        this.cause = cause;
    }

    private String getTrace() {
        String trace = "\t" + this.toString();
        Throwable t = this.cause;
        while (t != null) {
            trace = "\t" + t.toString() + "\n" + trace;
            if (!(t instanceof SmLogException)) break;
            t = ((SmLogException)t).getCause();
        }
        return trace;
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        ps.println("\nException history:");
        ps.println(this.getTrace() + "\n");
        ps.flush();
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        pw.println("\nException history:");
        pw.println(this.getTrace() + "\n");
        pw.flush();
    }

    public String getStringStackTrace() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        this.printStackTrace(ps);
        return os.toString();
    }

    public Throwable getCause() {
        return this.cause;
    }
}

