/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.DSAParams;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.SecureRandom;
import com.rsa.cryptoj.c.bj;
import com.rsa.cryptoj.c.bp;
import com.rsa.cryptoj.c.ca;
import com.rsa.cryptoj.c.ce;
import com.rsa.cryptoj.c.cf;
import com.rsa.cryptoj.c.cj;
import com.rsa.cryptoj.c.cl;
import com.rsa.cryptoj.c.dd;
import com.rsa.cryptoj.c.dt;
import com.rsa.cryptoj.c.et;
import com.rsa.cryptoj.c.fb;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.a;
import java.util.Arrays;

public abstract class JSAFE_Parameters
extends JSAFE_Object {
    private static final long serialVersionUID = 6175245135031513430L;
    private static final int k = 1;
    public static final byte FIELD_REPRESENTATION_TRINOMIAL = 1;
    public static final byte FIELD_REPRESENTATION_PENTANOMIAL = 2;
    public static final byte FIELD_REPRESENTATION_ONB = 3;
    public static final byte FIELD_REPRESENTATION_PRIME = 4;
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    public static final byte VERSION_3 = 3;
    protected static final String a = "Cannot reinitialize, object not initialized.";
    protected static final String b = "Object not initialized.";
    protected CryptoModule c;
    protected AlgParamGenerator d;
    protected DomainParams h;
    protected final String i;
    protected java.security.SecureRandom j;

    protected JSAFE_Parameters(CryptoModule cryptoModule, String string) {
        this.i = string;
        this.c = cryptoModule;
    }

    public static JSAFE_Parameters getInstance(byte[] byArray, int n2, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_Parameters.a(byArray, n2, string, ce.a());
    }

    public static JSAFE_Parameters getInstance(byte[] byArray, int n2, String string, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_Parameters.a(byArray, n2, string, fIPS140Context.a());
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        try {
            return AlgorithmID.findNextOffset(byArray, n2, 5);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new JSAFE_UnimplementedException("Could not read BER data.(" + aSN_Exception.getMessage() + ")");
        }
    }

    public static JSAFE_Parameters getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_Parameters.a(string, string2, ce.a());
    }

    public static JSAFE_Parameters getInstance(String string, String string2, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_Parameters.a(string, string2, fIPS140Context.a());
    }

    private static JSAFE_Parameters a(String string, String string2, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        ca[] caArray;
        if (string == null) {
            throw new JSAFE_UnimplementedException("Transformation was null");
        }
        String[] stringArray = fb.a(string);
        if (stringArray.length != 1) {
            throw new JSAFE_UnimplementedException("Invalid transformation");
        }
        for (ca ca2 : caArray = JSAFE_Parameters.a(string2)) {
            try {
                cj cj2 = cl.a(cf2, ca2);
                String string3 = dt.b(stringArray[0]);
                return et.a(stringArray[0], string3, cj2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("A JSAFE_Parameters object of " + string + " is not available on any of the devices. (" + string2 + ")");
    }

    private static JSAFE_Parameters a(byte[] byArray, int n2, String string, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        ca[] caArray;
        for (ca ca2 : caArray = JSAFE_Parameters.a(string)) {
            try {
                cj cj2 = cl.a(cf2, ca2);
                String string2 = bp.a(byArray, n2);
                DomainParams domainParams = bp.a(byArray, n2, cj2);
                return et.a(domainParams, cj2, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new JSAFE_InvalidParameterException(invalidAlgorithmParameterException);
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("JSAFE_Parameters object is not available on any of the devices. (" + string + ")");
    }

    protected abstract byte[] a() throws JSAFE_UnimplementedException;

    public byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException {
        return this.getDERAlgorithmID(null);
    }

    public byte[] getDERAlgorithmID(String string) throws JSAFE_UnimplementedException {
        if (this.h == null) {
            throw new JSAFE_UnimplementedException("Parameter information not set.");
        }
        if (string == null) {
            return this.a();
        }
        return this.getParameterData(string)[0];
    }

    public String getDevice() {
        return this.c.getDeviceType();
    }

    public String[] getDeviceList() {
        Object[] objectArray = new String[1];
        Arrays.fill(objectArray, this.getDevice());
        return objectArray;
    }

    public String getAlgorithm() {
        return this.i;
    }

    public abstract String[] getSupportedSetFormats();

    public abstract String[] getSupportedGetFormats();

    public abstract void setParameterData(String var1, byte[][] var2) throws JSAFE_InputException, JSAFE_UnimplementedException;

    public abstract void setParameterData(byte[][] var1) throws JSAFE_InputException;

    public abstract byte[][] getParameterData(String var1) throws JSAFE_UnimplementedException;

    public abstract byte[][] getParameterData();

    public byte[][] getDSADomainParameterGenerationData(int[] nArray) throws JSAFE_InvalidUseException {
        if (this.h instanceof DSAParams) {
            try {
                byte[][] byArray = this.getParameterData("DSAParametersExtended");
                if (byArray.length < 5) {
                    throw new JSAFE_InvalidUseException("No extended data for DSA Parameters with counter");
                }
                nArray[0] = dd.c(byArray[5]);
                return byArray;
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidUseException("No extended data for DSA Parameters with counter");
            }
        }
        return null;
    }

    public abstract void generateInit(int[] var1, java.security.SecureRandom var2) throws JSAFE_InvalidParameterException;

    public abstract void generateInit(int[] var1, java.security.SecureRandom var2, JSAFE_Session[] var3) throws JSAFE_InvalidParameterException;

    public void generateFIPSInit(int[] nArray, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException, JSAFE_InvalidUseException {
        if (!this.getAlgorithm().equals("DSA")) {
            throw new JSAFE_InvalidUseException("Use generateFIPSInit only with DSA parameters.");
        }
        this.generateInit(nArray, secureRandom);
    }

    public abstract void generateReInit() throws JSAFE_InvalidUseException;

    public abstract void generate() throws JSAFE_InvalidUseException;

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSAFE_Parameters jSAFE_Parameters = (JSAFE_Parameters)super.clone();
        jSAFE_Parameters.c = this.c;
        jSAFE_Parameters.d = this.c.newAlgParamGenerator(this.b());
        jSAFE_Parameters.j = this.j;
        try {
            jSAFE_Parameters.setParameterData(this.getParameterData());
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            // empty catch block
        }
        return jSAFE_Parameters;
    }

    protected void a(int n2, byte[][] byArray) throws JSAFE_InputException {
        if (byArray == null || byArray.length != n2) {
            throw new JSAFE_InputException("Invalid parameterData length, expected " + n2);
        }
    }

    protected void a(byte[][] byArray) throws JSAFE_InputException {
        this.a(1, byArray);
        try {
            String string = bp.a(byArray[0], 0);
            if (string.indexOf(this.getAlgorithm()) == -1) {
                throw new JSAFE_InputException("Invalid " + this.getAlgorithm() + " parameters BER.");
            }
            this.h = bp.a(byArray[0], 0, this.c);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InputException("Invalid " + this.getAlgorithm() + " parameters BER: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    protected abstract String b();

    @Override
    public void clearSensitiveData() {
        this.h = null;
        this.d = null;
    }

    protected SecureRandom c() {
        return com.rsa.jsafe.a.b(this.j);
    }

    public boolean equals(Object object) {
        if (!(object instanceof JSAFE_Parameters)) {
            return false;
        }
        if (!this.i.equals(((JSAFE_Parameters)object).getAlgorithm())) {
            return false;
        }
        if (this.h == null) {
            return true;
        }
        byte[][] byArray = this.getParameterData();
        byte[][] byArray2 = ((JSAFE_Parameters)object).getParameterData();
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (Arrays.equals(byArray[i2], byArray2[i2])) continue;
            return false;
        }
        return true;
    }

    protected DomainParams d() {
        return this.h;
    }

    public int hashCode() {
        return this.h.hashCode();
    }
}

