/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.asn1;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;

public final class BitStringContainer
extends ASN1Container {
    public static final boolean NAMED = true;
    public static final boolean UNNAMED = false;
    private static final int C = -1;
    private int D;
    private int E;

    public BitStringContainer(int n2) {
        this(n2, true, 0, 0, 0, false);
    }

    public BitStringContainer(int n2, int n3) {
        this(n2, true, 0, 0, n3, true);
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, byte[] byArray, int n5, int n6) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n5, n6, -1, false);
        this.B = n4;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, int n5, boolean bl3) {
        super(n2, bl2, n3, 768);
        this.i |= 0x4000000;
        this.D = n5;
        if (this.D > 32) {
            this.D %= 32;
        }
        if (this.D < 0) {
            this.D = 0;
        }
        this.data = new byte[4];
        this.data[0] = (byte)((n4 &= -1 << 32 - this.D) >>> 24);
        this.data[1] = (byte)(n4 >>> 16);
        this.data[2] = (byte)(n4 >>> 8);
        this.data[3] = (byte)n4;
        this.m = true;
        this.dataLen = (n5 + 7) / 8;
        this.dataLen = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, bl3);
        this.E = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, this.D, bl3);
        this.n |= 0x60000;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n4, n5, -1, false);
    }

    public BitStringContainer(int n2, boolean bl2, int n3, int n4, byte[] byArray, int n5, int n6, int n7, boolean bl3) throws ASN_Exception {
        this(n2, bl2, n3, byArray, n5, n6, n7, bl3);
        this.B = n4;
    }

    public BitStringContainer(int n2, boolean bl2, int n3, byte[] byArray, int n4, int n5, int n6, boolean bl3) throws ASN_Exception {
        super(n2, bl2, n3, 768);
        this.i |= 0x4000000;
        this.D = n6;
        this.dataLen = n5;
        if (byArray == null) {
            return;
        }
        this.data = byArray;
        if (n4 < 0 || n4 >= byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataOffset is out of range.");
        }
        this.dataOffset = n4;
        if (n5 < 0 || n4 + n5 > byArray.length) {
            throw new ASN_Exception("BitStringContainer.BitStringContainer: dataLen is out of range.");
        }
        if (n6 < 0) {
            n6 = n5 * 8;
        }
        if (n6 < n5 * 8) {
            this.dataLen = (n6 + 7) / 8;
            int n7 = n6 % 8;
            if (n7 != 0) {
                n7 = 255 >>> n7;
            }
            if ((n7 = this.data[this.dataOffset + this.dataLen - 1] & n7) != 0) {
                byte[] byArray2 = new byte[this.dataLen];
                System.arraycopy(this.data, this.dataOffset, byArray2, 0, this.dataLen);
                int n8 = byArray2.length - 1;
                byArray2[n8] = (byte)(byArray2[n8] ^ n7);
                this.data = byArray2;
                this.dataOffset = 0;
                this.m = true;
            }
        }
        this.dataLen = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, bl3);
        this.E = BitStringContainer.a(this.data, this.dataOffset, this.dataLen, n6, bl3);
        this.n |= 0x20000;
        if (bl3) {
            this.n |= 0x40000;
        }
    }

    public int getValueAsInt() throws ASN_Exception {
        if (this.dataLen > 4) {
            throw new ASN_Exception("Cannot represent bit string in 32 bits.");
        }
        int n2 = -1 << this.E;
        int n3 = 0;
        int n4 = 24;
        int n5 = this.dataOffset;
        while (n4 >= 32 - this.dataLen * 8) {
            n3 |= (this.data[n5] & 0xFF) << n4;
            n4 -= 8;
            ++n5;
        }
        return n3 & n2;
    }

    @Override
    int a(ASN1Container[] aSN1ContainerArray, int n2) throws ASN_Exception {
        this.a();
        this.n |= 0x40000;
        if (!this.dataPresent) {
            return this.a(false, null, 0);
        }
        this.h = this.dataLen;
        if (this.h != 0) {
            ++this.h;
        }
        int n3 = ASN1Lengths.getTagLen(this.d) + this.h + ASN1Lengths.getLengthLen(this.dataLen);
        if (this.b == -1) {
            return n3;
        }
        this.c = n3;
        return ASN1Lengths.getTagLen(this.b) + this.c + ASN1Lengths.getLengthLen(n3);
    }

    @Override
    int a(ASN1Container[] aSN1ContainerArray, int n2, byte[] byArray, int n3) throws ASN_Exception {
        this.n = 0x2000000;
        if (!this.dataPresent) {
            return this.a(true, byArray, n3);
        }
        int n4 = n3;
        if (this.b != -1) {
            n3 += ASN1Lengths.writeTag(byArray, n3, this.b);
            n3 += ASN1Lengths.writeLength(byArray, n3, this.c);
        }
        n3 += ASN1Lengths.writeTag(byArray, n3, this.d);
        n3 += ASN1Lengths.writeLength(byArray, n3, this.h);
        if (this.h != 0) {
            if (n3 >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put unusedBits");
            }
            byArray[n3++] = (byte)this.E;
        }
        if (this.data != null) {
            if (n3 + this.dataLen > byArray.length) {
                throw new ASN_Exception("BitStringContainer.derEncode: not enough room in encoding to put data");
            }
            System.arraycopy(this.data, this.dataOffset, byArray, n3, this.dataLen);
            n3 += this.dataLen;
        }
        return n3 - n4;
    }

    @Override
    void b(ASN1Container[] aSN1ContainerArray, int n2) {
        this.a();
        if ((this.n & 0x40000) == 0) {
            this.d |= 0x20;
            this.h = -1;
        } else {
            this.h = this.dataLen;
            if (this.h != 0) {
                ++this.h;
            }
        }
        this.n |= 0x10000;
    }

    @Override
    int a(byte[] byArray, int n2) throws ASN_Exception {
        int n3 = n2;
        n2 += super.a(byArray, n2);
        if (this.h != 0) {
            if (byArray == null) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: encoding should not be null.");
            }
            if (n2 < 0 || n2 >= byArray.length) {
                throw new ASN_Exception("BitStringContainer.writeTagBER: offset is out of range.");
            }
            byArray[n2++] = (byte)this.E;
        }
        return n2 - n3;
    }

    @Override
    void c() {
        super.c();
        this.E = -1;
        this.D = 0;
    }

    @Override
    int a(ASN1Template aSN1Template, int n2, byte[] byArray, int n3) throws ASN_Exception {
        int n4 = n3;
        if (this.E == -1 && this.h != 0) {
            this.E = byArray[n3++];
            --this.z;
            if (this.h != -1) {
                --this.h;
            }
        }
        if (this.z >= 1) {
            n3 += super.a(aSN1Template, n2, byArray, n3);
        }
        return n3 - n4;
    }

    private static int a(byte[] byArray, int n2, int n3, boolean bl2) {
        if (!bl2) {
            return n3;
        }
        int n4 = n3;
        int n5 = n2 + n3 - 1;
        while (n5 >= n2 && byArray[n5] == 0) {
            --n5;
            --n4;
        }
        return n4;
    }

    private static int a(byte[] byArray, int n2, int n3, int n4, boolean bl2) {
        if (n3 == 0) {
            return 0;
        }
        if (!bl2) {
            int n5 = 8 - n4 % 8;
            if (n5 == 8) {
                n5 = 0;
            }
            return n5;
        }
        int n6 = byArray[n2 + n3 - 1] & 0xFF;
        for (int i2 = 0; i2 < 7; ++i2) {
            int n7 = n6 >>> i2 & 1;
            if (n7 == 0) continue;
            return i2;
        }
        return 7;
    }

    @Override
    boolean a(ASN1Container aSN1Container) {
        return aSN1Container instanceof BitStringContainer;
    }

    @Override
    ASN1Container d() {
        try {
            return new BitStringContainer(this.i, true, this.j, null, 0, 0, this.D, false);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }
}

