/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.rpc.tunnel;

import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.TunnelConnection;
import com.ca.siteminder.rpc.tunnel.XpsHostConfig;
import com.ca.siteminder.rpcutil.IOUtil;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Registration
implements ContextConstants {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    private static final String CHARSET_NAME = "UTF-8";
    private static final char DELIMITER = '\u0000';
    private static final String FUNCTION = "RegisterClient";
    private static final String LIBRARY = "XPSSvc";
    private static final String PARAMETER = "";
    private static final String PSID = "PSID";
    private static final String REGISTRATION_TYPE = "Report";
    private static final String RESULT = "Result";
    private static final String SECRET = "Secret";
    private String passPhrase;
    private XpsHostConfig config = new XpsHostConfig();

    private static Map buildResult(byte[] byArray) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = new String(byArray, CHARSET_NAME).split("\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=", 2);
                hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
            }
            Arrays.fill(byArray, (byte)0);
            return hashMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(xlate.translate("SM-ALY-02016"));
        }
    }

    private static byte[] getData(Locale locale, String string, String string2, String string3) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(locale.getLanguage()).append('\u0000');
            stringBuffer.append(locale.getCountry()).append('\u0000');
            stringBuffer.append(string).append('\u0000');
            stringBuffer.append(string2).append('\u0000');
            stringBuffer.append(string3).append('\u0000');
            stringBuffer.append(REGISTRATION_TYPE).append('\u0000');
            return stringBuffer.toString().getBytes(CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Default encoding not supported");
        }
    }

    public Registration(String string, String string2, String string3) {
        this.config.userPath = string;
        this.config.trustedHost = string2;
        this.passPhrase = string3;
    }

    public void run(String string, int n, int n2) {
        Locale locale = Locale.getDefault();
        byte[] byArray = Registration.getData(locale, this.config.trustedHost, this.passPhrase, this.config.userPath);
        this.config.ps_ip = string;
        try {
            InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("PS_IP", this.config.ps_ip);
        this.config.ps_port = n > 0 ? new Integer(n) : (Integer)TunnelConnection.defaults.get("PS_AUPORT");
        this.config.ps_fips = new Integer(n2);
        hashMap.put("PS_AUPORT", this.config.ps_port);
        hashMap.put("PS_FIPS", this.config.ps_fips);
        TunnelConnection tunnelConnection = new TunnelConnection(LIBRARY, FUNCTION);
        tunnelConnection.connect(hashMap);
        byte[] byArray2 = tunnelConnection.send(byArray);
        tunnelConnection.disconnect();
        Map map = Registration.buildResult(byArray2);
        String string2 = (String)map.get(RESULT);
        if (string2 != null) {
            throw new RuntimeException(string2);
        }
        this.config.psid = (String)map.get(PSID);
        this.config.secret = (String)map.get(SECRET);
    }

    public static XpsHostConfig run(String string, int n, String string2, String string3, String string4) {
        return Registration.run(0, string, n, string2, string3, string4);
    }

    public static XpsHostConfig run(int n, String string, int n2, String string2, String string3, String string4) {
        Registration registration = new Registration(string2, string3, string4);
        registration.run(string, n2, n);
        return registration.config;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 2 || stringArray.length > 3) {
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02011"));
            return;
        }
        int n = 0;
        int n2 = 0;
        String string = "siteminder";
        String[] stringArray2 = stringArray[1].split(":", 2);
        if (stringArray2.length == 1) {
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02012"));
            return;
        }
        String string2 = "XpsHost.properties";
        if (stringArray.length > 2) {
            string2 = stringArray[2];
        }
        File file = new File(string2);
        xlate.printMessageToConsole(xlate.translate("SM-ALY-02013") + file.getAbsolutePath());
        if (!IOUtil.checkOutputFilename((String)string2)) {
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02014") + string2 + xlate.translate("SM-ALY-02015"));
            return;
        }
        try {
            XpsHostConfig xpsHostConfig = Registration.run(n, stringArray[0], n2, string, stringArray2[0], stringArray2[1]);
            IOUtil.backupFile((File)file);
            xpsHostConfig.save(string2);
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02010"));
        }
        catch (Exception exception) {
            xlate.printMessageToConsole(xlate.translate("SM-ALY-02007") + exception.getLocalizedMessage());
        }
    }
}

