/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.netegrity.policyserver.smapi.APIContext;
import com.netegrity.policyserver.smapi.NativeCallbackError;
import com.netegrity.policyserver.smapi.SmAuthQueryCode;
import com.netegrity.policyserver.smapi.SmAuthQueryResponse;
import com.netegrity.policyserver.smapi.SmAuthScheme;
import com.netegrity.policyserver.smapi.SmAuthStatus;
import com.netegrity.policyserver.smapi.UserContext;
import com.netegrity.policyserver.smapi.UserCredentialsContext;
import com.netegrity.util.Logger;
import java.util.Hashtable;

public class SmAuthenticationContext {
    private String m_className;
    private String m_parameter;
    private String m_secret;
    private APIContext m_apiContext;
    private UserContext m_userContext;
    private UserCredentialsContext m_userCredentialsContext;
    private int m_maxUserTextSize;
    private long m_lpUserTextBuf;
    private int m_maxErrorTextSize;
    private long m_lpErrorTextBuf;
    private long m_lpGetInterface;
    private long m_lpfactoryHandle;
    private static Hashtable m_authSchemes = new Hashtable();
    private static final String libName = "smjavaapi";

    public APIContext getAPIContext() {
        return this.m_apiContext;
    }

    public UserContext getUserContext() {
        return this.m_userContext;
    }

    public UserCredentialsContext getUserCredentialsContext() {
        return this.m_userCredentialsContext;
    }

    public int getMaxUserTextSize() {
        return this.m_maxUserTextSize;
    }

    public long getSMFactoryInterface() {
        return this.m_lpGetInterface;
    }

    public long getSMFactoryHandle() {
        return this.m_lpfactoryHandle;
    }

    public void setUserText(String string) {
        this.setUserText(this.m_maxUserTextSize, this.m_lpUserTextBuf, string);
    }

    private native void setUserText(int var1, long var2, String var4) throws NativeCallbackError;

    public int getMaxErrorTextSize() {
        return this.m_maxErrorTextSize;
    }

    public void setErrorText(String string) {
        this.setErrorText(this.m_maxErrorTextSize, this.m_lpErrorTextBuf, string);
    }

    private native void setErrorText(int var1, long var2, String var4) throws NativeCallbackError;

    protected SmAuthenticationContext(String string, String string2) {
        this.m_secret = string2;
        String string3 = string == null ? "" : string.trim();
        if (string3.length() == 0) {
            this.m_className = "";
            this.m_parameter = "";
        } else {
            int n = string3.indexOf(32);
            if (n > 0) {
                this.m_className = string3.substring(0, n);
                this.m_parameter = string3.substring(n + 1);
            } else {
                this.m_className = string3;
                this.m_parameter = "";
            }
        }
    }

    private static SmAuthScheme findScheme(SmAuthenticationContext smAuthenticationContext) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SmAuthScheme smAuthScheme = (SmAuthScheme)m_authSchemes.get(smAuthenticationContext.m_className);
        if (smAuthScheme == null) {
            smAuthScheme = (SmAuthScheme)Class.forName(smAuthenticationContext.m_className).newInstance();
            m_authSchemes.put(smAuthenticationContext.m_className, smAuthScheme);
        }
        return smAuthScheme;
    }

    private static int query(String string, String string2, int n, int n2, long l, long l2) {
        SmAuthQueryResponse smAuthQueryResponse = new SmAuthQueryResponse(n2, l, l2);
        try {
            SmAuthenticationContext smAuthenticationContext = new SmAuthenticationContext(string, string2);
            SmAuthScheme smAuthScheme = SmAuthenticationContext.findScheme(smAuthenticationContext);
            return smAuthScheme.query(smAuthenticationContext.m_parameter, smAuthenticationContext.m_secret, SmAuthQueryCode.valueOf(n), smAuthQueryResponse).toInt();
        }
        catch (Throwable throwable) {
            Logger.logErrorWithStackTrace((Throwable)throwable);
            if (smAuthQueryResponse != null) {
                smAuthQueryResponse.setResponseBuffer("Exception caught will invoking Java Auth Scheme query method.");
            }
            return SmAuthStatus.SMAUTH_FAILURE.toInt();
        }
    }

    private static int init(String string, String string2) {
        try {
            SmAuthenticationContext smAuthenticationContext = new SmAuthenticationContext(string, string2);
            SmAuthScheme smAuthScheme = SmAuthenticationContext.findScheme(smAuthenticationContext);
            return smAuthScheme.init(smAuthenticationContext.m_parameter, smAuthenticationContext.m_secret).toInt();
        }
        catch (Throwable throwable) {
            Logger.logErrorWithStackTrace((Throwable)throwable);
            return SmAuthStatus.SMAUTH_FAILURE.toInt();
        }
    }

    private static int release(String string, String string2) {
        try {
            SmAuthenticationContext smAuthenticationContext = new SmAuthenticationContext(string, string2);
            SmAuthScheme smAuthScheme = SmAuthenticationContext.findScheme(smAuthenticationContext);
            return smAuthScheme.release(smAuthenticationContext.m_parameter, smAuthenticationContext.m_secret).toInt();
        }
        catch (Throwable throwable) {
            Logger.logErrorWithStackTrace((Throwable)throwable);
            return SmAuthStatus.SMAUTH_FAILURE.toInt();
        }
    }

    private static int authenticate(long l, long l2, long l3, int n, String string, String string2, int n2, long l4, int n3, long l5, long l6, long l7) {
        try {
            SmAuthenticationContext smAuthenticationContext = new SmAuthenticationContext(string, string2);
            smAuthenticationContext.m_apiContext = new APIContext(l);
            smAuthenticationContext.m_userContext = new UserContext(l2);
            smAuthenticationContext.m_userCredentialsContext = new UserCredentialsContext(l3);
            smAuthenticationContext.m_maxUserTextSize = n2;
            smAuthenticationContext.m_lpUserTextBuf = l4;
            smAuthenticationContext.m_maxErrorTextSize = n3;
            smAuthenticationContext.m_lpErrorTextBuf = l5;
            smAuthenticationContext.m_lpfactoryHandle = l7;
            smAuthenticationContext.m_lpGetInterface = l6;
            SmAuthScheme smAuthScheme = SmAuthenticationContext.findScheme(smAuthenticationContext);
            return smAuthScheme.authenticate(smAuthenticationContext.m_parameter, smAuthenticationContext.m_secret, n, smAuthenticationContext).toInt();
        }
        catch (Throwable throwable) {
            Logger.logErrorWithStackTrace((Throwable)throwable);
            return SmAuthStatus.SMAUTH_FAILURE.toInt();
        }
    }

    static {
        System.loadLibrary(libName);
    }
}

