/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.policyserver.smapi;

import com.netegrity.policyserver.smapi.ActiveExpressionContext;
import com.netegrity.policyserver.smapi.NativeCallbackError;
import com.netegrity.policyserver.smapi.SMAPIFactory;
import com.netegrity.util.Logger;
import java.util.ResourceBundle;

public class SessionVariableContext {
    private long m_lpSMInterface = 0L;

    public SessionVariableContext(long l) {
        this.m_lpSMInterface = l;
    }

    public SessionVariableContext(ActiveExpressionContext activeExpressionContext) {
        this.m_lpSMInterface = activeExpressionContext.getSMAPIFactory().getSMInterface(9013);
    }

    public String getSessionVariable(String string) throws NativeCallbackError {
        if (this.m_lpSMInterface == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"SessionVariableContext getSessionVariable");
            return null;
        }
        return this.callGetSessionVariableFunc(this.m_lpSMInterface, string);
    }

    public boolean setSessionVariable(String string, String string2) throws NativeCallbackError {
        if (this.m_lpSMInterface == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"SessionVariableContext setSessionVariable");
            return false;
        }
        return this.callSetSessionVariableFunc(this.m_lpSMInterface, string, string2);
    }

    public boolean setSessionVariableEx(String string, String string2, long l) throws NativeCallbackError {
        if (this.m_lpSMInterface == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"SessionVariableContext setSessionVariableEx");
            return false;
        }
        return this.callSetSessionVariableExFunc(this.m_lpSMInterface, string, string2, l);
    }

    public boolean deleteSessionVariable(String string) throws NativeCallbackError {
        if (this.m_lpSMInterface == 0L) {
            Logger.logError((ResourceBundle)ActiveExpressionContext.getAdminResourceBundle(), (String)"SM-API-03002", (Object)"SessionVariableContext deleteSessionVariable");
            return false;
        }
        return this.callDeleteSessionVariableFunc(this.m_lpSMInterface, string);
    }

    public synchronized void close() {
        if (this.m_lpSMInterface != 0L) {
            SMAPIFactory.destroySMInterface(this.m_lpSMInterface);
        }
        this.m_lpSMInterface = 0L;
    }

    protected void finalize() {
        this.close();
    }

    private native String callGetSessionVariableFunc(long var1, String var3);

    private native boolean callSetSessionVariableFunc(long var1, String var3, String var4);

    private native boolean callDeleteSessionVariableFunc(long var1, String var3);

    private native boolean callSetSessionVariableExFunc(long var1, String var3, String var4, long var5);
}

