/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.tli;

import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTcpTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.UnresolvedAddressException;

public class SmAgentTcpIPv6Transport
extends SmAgentTcpTransport {
    private static final String CLASS_NAME = "SmAgentTcpIPv6Transport";
    private Socket m_socket;

    protected SmAgentTcpIPv6Transport(Socket socket) {
        super(null, null);
        this.m_socket = socket;
    }

    protected void finalize() throws Throwable {
        block4: {
            if (this.m_socket != null) {
                try {
                    if (Util.isLogEnabled()) {
                        Util.displayInfo("Closing the socket");
                    }
                    this.m_socket.close();
                }
                catch (Throwable t) {
                    if (!Util.isLogEnabled()) break block4;
                    Util.displayFatal("Fatal error closing socket : " + t.getMessage());
                }
            }
        }
        super.finalize();
    }

    public boolean isConnected() {
        if (null != this.m_socket) {
            return this.m_socket.isConnected();
        }
        return false;
    }

    public boolean connect(SocketAddress sa) throws IOException, UnresolvedAddressException {
        this.m_socket.connect(sa);
        if (Util.isLogEnabled()) {
            Util.displayInfo("Connected to the socket successfully");
        }
        return true;
    }

    public int write(ByteBuffer buf, long timeout) throws IOException {
        String methodName = "write";
        int bytesWritten = 0;
        OutputStream out = this.m_socket.getOutputStream();
        Util.display(5, CLASS_NAME, "write", "tcp write: trying to write...");
        try {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "write", "tcp write: buf limit " + buf.limit() + ", capacity " + buf.capacity() + ", remaining " + buf.remaining());
            }
            if (buf.hasArray()) {
                byte[] byteArr = new byte[buf.limit()];
                buf.get(byteArr);
                out.write(byteArr);
                out.flush();
                bytesWritten = byteArr.length;
            } else {
                bytesWritten = 0;
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "write", "ByteBuffer is not backed up by array, so no bytes are written to the Socket");
                }
            }
        }
        catch (IOException e) {
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "write", "IOException writing to the channel: " + e);
            }
            throw e;
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "write", "Completed execution bytes written = " + bytesWritten);
        }
        return bytesWritten;
    }

    public int read(ByteBuffer buffer, int readLength, long timeout) throws IOException {
        String methodName = "read";
        if (buffer.capacity() < readLength) {
            throw new BufferOverflowException();
        }
        long dropDeadTime = timeout > 0L ? System.currentTimeMillis() + timeout : timeout;
        buffer.clear();
        buffer.limit(readLength);
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "Reading " + readLength + " bytes with timeout of " + timeout + "ms");
        }
        int bytesRead = 0;
        int offset = 0;
        InputStream is = this.m_socket.getInputStream();
        do {
            long now = System.currentTimeMillis();
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "read", "dropDeadTime = " + dropDeadTime + ", bytesRead = " + bytesRead + ", readLength = " + readLength);
            }
            if (dropDeadTime > 0L && now >= dropDeadTime) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "read", "now >= dropDeadTime > 0, bytesRead = " + bytesRead);
                }
                return offset > 0 ? offset : -2;
            }
            try {
                if (this.m_socket.isConnected() && !this.m_socket.isInputShutdown()) {
                    byte[] bytes = new byte[readLength];
                    bytesRead = is.read(bytes);
                    if (bytesRead == -1) break;
                    buffer.put(bytes, 0, bytesRead);
                    continue;
                }
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "read", "Not connected to the socket");
                }
                throw new IOException("Not connected to the socket");
            }
            catch (IOException e) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "read", "IOException reading the socket: " + e);
                }
                throw e;
            }
        } while (dropDeadTime >= 0L && (offset += bytesRead) < readLength);
        if (offset > 0) {
            buffer.flip();
        }
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "read", "Completed execution: bytes read = " + offset + ", returning " + (offset > 0 ? offset : -2));
        }
        return offset > 0 ? offset : -2;
    }

    public void disconnect() throws IOException {
        if (this.m_socket != null) {
            this.m_socket.close();
        }
    }

    public void setupDataChannel() {
        try {
            this.m_socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

