/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;

public class UtilLog
implements SmAgentApiCommonConstants {
    public static final String CLASS_NAME = "UtilLog";
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String DEBUG_ENABLE_PROPERTY = "com.ca.siteminder.sdk.agentapi.enableDebug";
    public static final int LOG_LEVEL_FATAL = 1;
    public static final int LOG_LEVEL_ERROR = 2;
    public static final int LOG_LEVEL_WARNING = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_TRACE = 5;
    public static final String FATAL_LOG_KEY = "SMFATAL: ";
    public static final String WARNING_LOG_KEY = "SMWARNING: ";
    public static final String ERROR_LOG_KEY = "SMERROR: ";
    public static final String INFO_LOG_KEY = "SMINFO: ";
    public static final String TRACE_LOG_KEY = "SMTRACE: ";
    public static final String LOG_PARTS_SEPARATOR = ", ";
    protected static boolean c_logEnabled = Boolean.getBoolean("com.ca.siteminder.sdk.agentapi.enableDebug");
    protected static final String AGENTAPI_BUILD_PROPERTIES = "/smagentapibuild.properties";
    protected static String c_versionInfo;

    public static void display(int logLevel, String className, String methodName, String message) {
        if (!c_logEnabled) {
            return;
        }
        StringBuffer appendedBuffer = new StringBuffer();
        appendedBuffer.append(className);
        appendedBuffer.append(LOG_PARTS_SEPARATOR);
        appendedBuffer.append(methodName);
        appendedBuffer.append(LOG_PARTS_SEPARATOR);
        appendedBuffer.append(message);
        String appendedMessage = appendedBuffer.toString();
        switch (logLevel) {
            case 1: {
                UtilLog.displayFatal(appendedMessage);
                break;
            }
            case 2: {
                UtilLog.displayError(appendedMessage);
                break;
            }
            case 3: {
                UtilLog.displayWarning(appendedMessage);
                break;
            }
            case 4: {
                UtilLog.displayInfo(appendedMessage);
                break;
            }
            case 5: {
                UtilLog.displayTrace(appendedMessage);
            }
        }
    }

    public static void displayError(String message) {
        UtilLog.displayError(ERROR_LOG_KEY, message);
    }

    public static void displayWarning(String message) {
        UtilLog.displayError(WARNING_LOG_KEY, message);
    }

    public static void displayFatal(String message) {
        UtilLog.displayError(FATAL_LOG_KEY, message);
    }

    public static void displayInfo(String message) {
        UtilLog.displayOut(INFO_LOG_KEY, message);
    }

    public static void displayTrace(String message) {
        UtilLog.displayOut(TRACE_LOG_KEY, message);
    }

    public static boolean isLogEnabled() {
        return c_logEnabled;
    }

    protected static void displayError(String prependKey, String message) {
        Date time = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.err.println(DATE_FORMAT.format(time) + " [" + Thread.currentThread().getName() + "] " + prependKey + message);
        }
    }

    protected static void displayOut(String prependKey, String message) {
        Date time = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.out.println(DATE_FORMAT.format(time) + " [" + Thread.currentThread().getName() + "] " + prependKey + message);
        }
    }

    static {
        InputStream inStream = UtilLog.class.getResourceAsStream(AGENTAPI_BUILD_PROPERTIES);
        if (inStream == null) {
            throw new MissingResourceException("Can't find resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Properties buildProperties = new Properties();
        try {
            buildProperties.load(inStream);
        }
        catch (IOException e) {
            throw new MissingResourceException("Can't load resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Enumeration<Object> keys = buildProperties.keys();
        StringBuffer versionStringBuffer = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = buildProperties.getProperty(key);
            versionStringBuffer.append(key + "=" + value);
            if (!keys.hasMoreElements()) continue;
            versionStringBuffer.append(LOG_PARTS_SEPARATOR);
        }
        c_versionInfo = versionStringBuffer.toString();
        if (c_logEnabled) {
            UtilLog.displayInfo(c_versionInfo);
        }
    }
}

