/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.dd;

import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.FQN;
import com.ca.siteminder.sdk.adminapi.dd.IProduct;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDProduct
extends FQN
implements IProduct {
    private int version;
    long timestamp;
    private List<DDClass<? extends XPSObject>> classes;
    private String name;
    private String descr;
    private String fqname;
    static Map<String, DDProduct> products = new HashMap<String, DDProduct>();
    static Set<String> missingProducts = new HashSet<String>();

    public DDProduct(String string, String string2, int n) {
        this.version = n;
        this.name = string2;
        this.fqname = string + "." + string2;
    }

    public DDProduct(String string, String string2, DDClass<? extends XPSObject>[] dDClassArray, int n, long l) {
        this(string, string2, n);
        this.timestamp = l;
        this.classes = Arrays.asList(dDClassArray);
    }

    @Override
    public int getDDVersion() {
        return this.version;
    }

    public List<DDClass<? extends XPSObject>> getClasses() {
        return this.classes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFQName() {
        return this.fqname;
    }

    @Override
    public String getDescr() {
        return this.descr;
    }

    public static DDProduct get(String string) {
        DDProduct dDProduct = products.get(string);
        if (dDProduct != null) {
            return dDProduct;
        }
        if (missingProducts.contains(string)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("com.ca.siteminder.sdk.adminapi.");
        stringBuffer.append(string.toLowerCase());
        stringBuffer.append(".product_info");
        String string2 = stringBuffer.toString();
        try {
            Class<?> clazz = Class.forName(string2);
            Field field = clazz.getDeclaredField("ddproduct");
            dDProduct = (DDProduct)field.get(null);
            products.put(string, dDProduct);
        }
        catch (Exception exception) {
            missingProducts.add(string);
            return null;
        }
        return dDProduct;
    }
}

