/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPSObjectImpl {
    private Map<IAttribute, Object> colProps;
    private Date createdDTM;
    private Date modifiedDTM;
    private String updatedBy;
    private int updateMethod;
    private IClass<? extends XPSObject> baseClass;
    private Set<IClass<? extends XPSObject>> extensions;
    Session session;
    volatile boolean stub;
    private XPSObject parent;
    private String _xid;
    private int rid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transferTo(XPSObjectImpl xPSObjectImpl) {
        XPSObjectImpl xPSObjectImpl2 = xPSObjectImpl;
        synchronized (xPSObjectImpl2) {
            xPSObjectImpl.stub = false;
            xPSObjectImpl.createdDTM = this.createdDTM;
            xPSObjectImpl.modifiedDTM = this.modifiedDTM;
            xPSObjectImpl.updatedBy = this.updatedBy;
            xPSObjectImpl.updateMethod = this.updateMethod;
            xPSObjectImpl.colProps = this.colProps;
            xPSObjectImpl.baseClass = this.baseClass;
            xPSObjectImpl.extensions = this.extensions;
            if (xPSObjectImpl.session == null) {
                xPSObjectImpl.session = this.session;
            }
            xPSObjectImpl.parent = this.parent;
            xPSObjectImpl._xid = this._xid;
            xPSObjectImpl.rid = this.rid;
        }
    }

    boolean isStub() {
        return this.stub;
    }

    public synchronized XPSObjectImpl copy() {
        this.resolveStub();
        XPSObjectImpl xPSObjectImpl = new XPSObjectImpl();
        xPSObjectImpl.colProps = new HashMap<IAttribute, Object>();
        for (Map.Entry<IAttribute, Object> entry : this.colProps.entrySet()) {
            IAttribute iAttribute = entry.getKey();
            ArrayList arrayList = entry.getValue();
            if (arrayList instanceof List) {
                List list = arrayList;
                arrayList = new ArrayList(list);
            }
            xPSObjectImpl.colProps.put(iAttribute, arrayList);
        }
        xPSObjectImpl.baseClass = this.baseClass;
        xPSObjectImpl.extensions = this.extensions;
        xPSObjectImpl.session = this.session;
        xPSObjectImpl.stub = false;
        xPSObjectImpl.parent = this.parent;
        xPSObjectImpl._xid = null;
        xPSObjectImpl.rid = 0;
        return xPSObjectImpl;
    }

    XPSObjectImpl() {
        this(false);
    }

    XPSObjectImpl(boolean bl) {
        this.stub = bl;
        this.colProps = new HashMap<IAttribute, Object>();
        this.extensions = new HashSet<IClass<? extends XPSObject>>();
    }

    private synchronized void resolveStub() {
        if (this.stub) {
            this.session.resolveStub(this);
        }
    }

    synchronized void turnIntoStub() {
        this.stub = true;
        this.colProps.clear();
    }

    public synchronized XPSObject getParent() {
        this.resolveStub();
        return this.parent;
    }

    public synchronized void setParent(XPSObject xPSObject) {
        this.resolveStub();
        this.parent = xPSObject;
    }

    String getXid() {
        return this._xid;
    }

    void setXid(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null xid");
        }
        this._xid = string;
    }

    void clearXid() {
        this._xid = null;
    }

    int getRid() {
        return this.rid;
    }

    void setRid(int n) {
        this.rid = n;
    }

    synchronized Date getCreatedDTM() {
        this.resolveStub();
        return this.createdDTM;
    }

    void setCreatedDTM(Date date) {
        this.createdDTM = date;
    }

    synchronized Date getModifiedDTM() {
        this.resolveStub();
        return this.modifiedDTM;
    }

    void setModifiedDTM(Date date) {
        this.modifiedDTM = date;
    }

    synchronized String getUpdatedBy() {
        this.resolveStub();
        return this.updatedBy;
    }

    void setUpdatedBy(String string) {
        this.updatedBy = string;
    }

    synchronized int getUpdateMethod() {
        this.resolveStub();
        return this.updateMethod;
    }

    void setUpdateMethod(int n) {
        this.updateMethod = n;
    }

    IClass<? extends XPSObject> getBaseClass() {
        return this.baseClass;
    }

    void setBaseClass(IClass<? extends XPSObject> iClass) throws XPSException {
        this.baseClass = iClass;
    }

    Set<IClass<? extends XPSObject>> getExtensions() {
        this.resolveStub();
        return this.extensions;
    }

    void addExtension(IClass<? extends XPSObject> iClass) throws XPSException {
        this.extensions.add(iClass);
    }

    Map<IAttribute, Object> getRawProperties() {
        return this.colProps;
    }

    public Map<IAttribute, Object> getProperties() {
        this.resolveStub();
        return this.colProps;
    }

    void addProperty(IAttribute iAttribute, Object object) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("null attribute object");
        }
        if (object == null) {
            throw new IllegalArgumentException("null attribute value " + iAttribute.getName());
        }
        Object object2 = this.colProps.get(iAttribute);
        if (object2 == null) {
            this.colProps.put(iAttribute, object);
        } else if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            if (object instanceof Collection) {
                collection.addAll((Collection)object);
            } else {
                collection.add(object);
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.colProps.put(iAttribute, arrayList);
            if (object instanceof Collection) {
                arrayList.addAll((Collection)object);
            } else {
                arrayList.add(object);
            }
        }
    }

    public synchronized void clearProp(IAttribute iAttribute) {
        IAttribute iAttribute2 = this.resolve(iAttribute);
        this.colProps.remove(iAttribute2);
    }

    private IAttribute getAttr(DDAttribute<?> dDAttribute) {
        if (this.baseClass instanceof DDClass) {
            return dDAttribute;
        }
        Class clazz = (Class)this.baseClass;
        return clazz.getAttribute(dDAttribute);
    }

    public XPSObject getLink(IAttribute iAttribute) {
        return (XPSObject)this.getProperty(iAttribute);
    }

    public <T extends XPSObject> T getLink(DDAttribute<?> dDAttribute, java.lang.Class<T> clazz) {
        XPSObject xPSObject = this.getLink(dDAttribute);
        return xPSObject == null ? null : (T)xPSObject.castTo(clazz);
    }

    public <T extends XPSObject> void setLink(IAttribute iAttribute, T t) {
        this.setProperty(iAttribute, t);
    }

    List<XPSObject> getLinkList(IAttribute iAttribute) {
        List<XPSObject> list = this.getListProperty(iAttribute);
        return list;
    }

    public <T extends XPSObject> List<T> getLinkList(IAttribute iAttribute, java.lang.Class<T> clazz) {
        List<XPSObject> list = this.getLinkList(iAttribute);
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        ListIterator<XPSObject> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            XPSObject xPSObject = listIterator.next();
            arrayList.add(xPSObject.castTo(clazz));
        }
        return arrayList;
    }

    public <T extends XPSObject> void setLinkList(IAttribute iAttribute, List<T> list) {
        int n;
        int n2 = n = list == null ? 0 : list.size();
        if (n == 0) {
            this.clearProp(iAttribute);
        } else if (n == 1) {
            XPSObject xPSObject = (XPSObject)list.get(0);
            this.setLink(iAttribute, xPSObject);
        } else {
            ArrayList<T> arrayList = new ArrayList<T>(list);
            this.setProperty(iAttribute, arrayList);
        }
    }

    public <T extends XPSObject> T getParent(java.lang.Class<T> clazz) {
        XPSObject xPSObject = this.getParent();
        return xPSObject == null ? null : (T)xPSObject.castTo(clazz);
    }

    public boolean isInstanceOf(IClass<?> iClass) {
        String string;
        String string2 = this.baseClass.getFQName();
        if (string2.equals(string = iClass.getFQName())) {
            return true;
        }
        if (this.extensions == null) {
            return false;
        }
        IClass<? extends XPSObject> iClass2 = this.session.classCache.getClass(iClass.getFQName());
        return this.extensions.contains(iClass2);
    }

    IAttribute resolve(IAttribute iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("null attribute object");
        }
        this.resolveStub();
        if (iAttribute instanceof DDAttribute) {
            iAttribute = this.getAttr((DDAttribute)iAttribute);
        }
        return iAttribute;
    }

    synchronized Object getProperty(IAttribute iAttribute) {
        IAttribute iAttribute2 = this.resolve(iAttribute);
        return this.colProps.get(iAttribute2);
    }

    synchronized void setProperty(IAttribute iAttribute, Object object) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("null attribute object");
        }
        if (object == null) {
            throw new IllegalArgumentException("null attribute value " + iAttribute.getName());
        }
        IAttribute iAttribute2 = this.resolve(iAttribute);
        this.colProps.put(iAttribute2, object);
    }

    public <T> T getSingleProperty(DDAttribute<?> dDAttribute) {
        return (T)this.getProperty(dDAttribute);
    }

    public <T> void setSingleProperty(DDAttribute<?> dDAttribute, T t) {
        this.setProperty(dDAttribute, t);
    }

    public int getIntProperty(DDAttribute<?> dDAttribute) {
        Integer n = (Integer)this.getSingleProperty(dDAttribute);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setIntProperty(DDAttribute<?> dDAttribute, int n) {
        this.setSingleProperty(dDAttribute, n);
    }

    public boolean getBooleanProperty(DDAttribute<?> dDAttribute) {
        Boolean bl = (Boolean)this.getSingleProperty(dDAttribute);
        return bl == null ? false : bl;
    }

    public <T> List<T> getListProperty(IAttribute iAttribute) {
        Object object = this.getProperty(iAttribute);
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof List) {
            List list = (List)object;
            return Collections.unmodifiableList(list);
        }
        return Collections.singletonList(object);
    }

    public <T> void setListProperty(IAttribute iAttribute, List<T> list) {
        if (list == null || list.size() == 0) {
            this.clearProp(iAttribute);
        } else {
            this.setProperty(iAttribute, list);
        }
    }

    private static <T extends Enum<T>> Set<T> int2EnumSet(int n, java.lang.Class<T> clazz, T[] TArray) {
        EnumSet<T> enumSet = EnumSet.noneOf(clazz);
        int n2 = 0;
        while (n != 0) {
            int n3 = n & 1;
            n >>>= 1;
            if (n3 != 0) {
                enumSet.add(TArray[n2]);
            }
            ++n2;
        }
        return enumSet;
    }

    private static <T extends Enum<T>> int EnumSet2Int(Set<T> set) {
        int n = 0;
        for (Enum enum_ : set) {
            int n2 = enum_.ordinal();
            n |= 1 << n2;
        }
        return n;
    }

    public <T extends Enum<T>> Set<T> getEnumSet(DDAttribute<?> dDAttribute, java.lang.Class<T> clazz, T[] TArray) {
        int n = this.getIntProperty(dDAttribute);
        return XPSObjectImpl.int2EnumSet((int)n, clazz, TArray);
    }

    public <T extends Enum<T>> void setEnumSet(DDAttribute<?> dDAttribute, java.lang.Class<T> clazz, Set<T> set) {
        int n = XPSObjectImpl.EnumSet2Int(set);
        this.setIntProperty(dDAttribute, n);
    }

    private <T extends ValuedEnum> T getEnum(int n, T[] TArray) {
        for (T t : TArray) {
            if (t.getValue() != n) continue;
            return t;
        }
        return null;
    }

    public <T extends ValuedEnum> T getValuedEnum(DDAttribute<?> dDAttribute, T[] TArray) {
        Integer n = (Integer)this.getSingleProperty(dDAttribute);
        if (n == null) {
            return null;
        }
        return (T)this.getEnum(n, (ValuedEnum[])TArray);
    }

    public <T extends ValuedEnum> T getEnum(DDAttribute<?> dDAttribute, T[] TArray, int n) {
        Integer n2 = (Integer)this.getSingleProperty(dDAttribute);
        if (n2 == null) {
            return null;
        }
        return TArray[n2 - n];
    }

    public boolean hasProp(IAttribute iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("null attribute object");
        }
        return this.getProperty(iAttribute) != null;
    }

    public Set<Attribute> getAttributes() {
        this.resolveStub();
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        Set<IAttribute> set = this.colProps.keySet();
        for (IAttribute iAttribute : set) {
            if (!(iAttribute instanceof Attribute)) continue;
            hashSet.add((Attribute)Attribute.class.cast(iAttribute));
        }
        return hashSet;
    }
}

