/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.dd.DDAttribute;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.dd.ValuedEnum;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XPSObject {
    protected XPSObjectImpl impl;
    private static final Class[] arg = new Class[]{XPSObjectImpl.class};
    private static final DDClass<XPSObject> xclass = new DDClass<XPSObject>(XPSObject.class, null, "CA.XPS::Metadata", false);
    public static final DDAttribute<XPSObject> PARENT = new DDAttribute(xclass, "Parent", 0, 1, IAttribute.DataType.Link, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<XPSObject> CREATED = new DDAttribute(xclass, "Created", 0, 1, IAttribute.DataType.DateTime, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<XPSObject> MODIFIED = new DDAttribute(xclass, "Modified", 0, 1, IAttribute.DataType.DateTime, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<XPSObject> ORIGIN = new DDAttribute(xclass, "UpdateMethod", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    public static final DDAttribute<XPSObject> UPDATEDBY = new DDAttribute(xclass, "UpdatedBy", 0, 1, IAttribute.DataType.String, IAttribute.Handling.Value, IAttribute.APIAccess.All);
    private static final DDClass<XPSObject> metaclass = new DDClass<XPSObject>(XPSObject.class, null, "CA.XPS::MetaAttributes", false);
    public static final DDAttribute<Integer> HIDINGMASK = new DDAttribute(metaclass, "HidingMask", 0, 1, IAttribute.DataType.Integer, IAttribute.Handling.Flags, IAttribute.APIAccess.All);

    public abstract XPSObject duplicate();

    public String getXid() {
        return this.impl.getXid();
    }

    public IClass<? extends XPSObject> getBaseClass() {
        return this.impl.getBaseClass();
    }

    public String toString() {
        String string = this.getXid();
        if (string == null) {
            string = this.impl.getBaseClass().getFQName() + "@<null>";
        }
        return string;
    }

    XPSObjectImpl getImpl() {
        return this.impl;
    }

    void setImpl(XPSObjectImpl xPSObjectImpl) {
        this.impl = xPSObjectImpl;
    }

    Session getSession() {
        return this.impl.session;
    }

    protected XPSObject(XPSObjectImpl xPSObjectImpl) {
        if (xPSObjectImpl == null) {
            throw new IllegalArgumentException("null impl");
        }
        this.impl = xPSObjectImpl;
    }

    public Set<IClass<? extends XPSObject>> getExtensions() {
        return this.impl.getExtensions();
    }

    public <T extends XPSObject> List<T> getChildren(IClass<T> iClass) {
        return this.impl.session.getPolicyData().getChildren(this, iClass);
    }

    public <T extends XPSObject> List<T> getChildren1(IClass<T> iClass) {
        return this.impl.session.getPolicyData().getChildren1(this, iClass);
    }

    public List<XPSObject> getRelated(String string) throws ServerException {
        return this.impl.session.getPolicyData().getRelated(this, string);
    }

    public List<XPSObject> getRelated1(String string) throws ServerException {
        return this.impl.session.getPolicyData().getRelated1(this, string);
    }

    public GenericObject castToGenericObject() {
        return new GenericObject(this.impl);
    }

    public <T extends XPSObject> T castTo(DDClass<T> dDClass) throws XPSException {
        return this.castTo(dDClass.getJavaClass());
    }

    public <T extends XPSObject> T castTo(Class<T> clazz) throws XPSException {
        if (clazz.isInstance(this)) {
            return (T)((XPSObject)clazz.cast(this));
        }
        if (clazz == GenericObject.class) {
            return (T)((XPSObject)clazz.cast(this.castToGenericObject()));
        }
        Class<XPSObject> clazz2 = this.impl.getBaseClass().getDynamicJavaClass();
        if (!clazz2.isAssignableFrom(clazz) && !clazz.isAssignableFrom(clazz2)) {
            throw new XPSException("cast", this.getClass().getSimpleName(), clazz.getSimpleName());
        }
        T t = XPSObject.newInstance(clazz, this.impl);
        return t;
    }

    public <T extends XPSObject> boolean isInstanceOf(IClass<T> iClass) {
        Class<XPSObject> clazz = iClass.getDynamicJavaClass();
        if (clazz != GenericObject.class && clazz.isInstance(this)) {
            return true;
        }
        return this.impl.isInstanceOf(iClass);
    }

    public Date getCreated() {
        return this.impl.getCreatedDTM();
    }

    public Date getModified() {
        return this.impl.getModifiedDTM();
    }

    public String getUpdatedBy() {
        return this.impl.getUpdatedBy();
    }

    public Origin getOrigin() {
        Origin[] originArray = Origin.values();
        return originArray[this.impl.getUpdateMethod()];
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.impl.equals(((XPSObject)object).impl);
    }

    public static synchronized XPSObject newInstance(XPSObjectImpl xPSObjectImpl) {
        IClass<? extends XPSObject> iClass = xPSObjectImpl.getBaseClass();
        Class<XPSObject> clazz = iClass.getDynamicJavaClass();
        if (clazz == null) {
            clazz = GenericObject.class;
        }
        XPSObject xPSObject = XPSObject.newInstance(clazz, xPSObjectImpl);
        return xPSObject;
    }

    private static <T extends XPSObject> T newInstance(Class<T> clazz, XPSObjectImpl xPSObjectImpl) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(arg);
            return (T)((XPSObject)constructor.newInstance(xPSObjectImpl));
        }
        catch (Exception exception) {
            throw new RuntimeException("newInstance " + clazz.getSimpleName());
        }
    }

    public Set<HidingMask> getHidingMask() {
        return this.impl.getEnumSet(HIDINGMASK, HidingMask.class, HidingMask.values());
    }

    public void setHidingMask(Set<HidingMask> set) {
        this.impl.setEnumSet(HIDINGMASK, HidingMask.class, set);
    }

    public void setHidingMask(HidingMask hidingMask, HidingMask ... hidingMaskArray) {
        this.setHidingMask(EnumSet.of(hidingMask, hidingMaskArray));
    }

    public boolean hasHidingMask() {
        return this.impl.hasProp(HIDINGMASK);
    }

    public void clearHidingMask() {
        this.impl.clearProp(HIDINGMASK);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HidingMask implements ValuedEnum
    {
        GUI;


        @Override
        public int getValue() {
            return 1 << this.ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Origin implements ValuedEnum
    {
        UNKNOWN,
        INTERNAL,
        DISK,
        LOCAL_API,
        REMOTE_API,
        GUI,
        DDINSTALL,
        DICTIONARY,
        CONFIG,
        EXPLORER,
        SECURITY,
        REGCLIENT,
        EXPORT,
        IMPORT,
        AUDIT,
        EVAL,
        REPORTS,
        PLUGIN_MANAGER;


        @Override
        public int getValue() {
            return this.ordinal();
        }
    }
}

