/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import java.util.HashMap;
import java.util.Map;

public class SessionCache {
    Session session;
    Map<String, XPSObject> cache;

    SessionCache(Session session) {
        this.session = session;
        this.cache = new HashMap<String, XPSObject>();
    }

    synchronized void insert(XPSObject xPSObject, boolean bl) {
        XPSObjectImpl xPSObjectImpl = xPSObject.getImpl();
        String string = xPSObjectImpl.getXid();
        XPSObject xPSObject2 = this.cache.get(string);
        if (xPSObject2 == xPSObject) {
            return;
        }
        if (xPSObject2 != null) {
            if (xPSObject2.impl.stub || !bl) {
                xPSObjectImpl.transferTo(xPSObject2.impl);
            }
            xPSObject.setImpl(xPSObject2.impl);
        } else {
            xPSObject.getImpl().session = this.session;
            this.cache.put(string, xPSObject);
        }
    }

    public synchronized XPSObject get(String string) {
        return this.cache.get(string);
    }

    synchronized void reset() {
        this.cache.clear();
    }

    synchronized void remove(String string) {
        this.cache.remove(string);
    }

    synchronized void remove(XPSObject xPSObject) {
        this.cache.remove(xPSObject.getXid());
    }
}

