/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.rpc.rpc.ApplicationContext;
import com.ca.siteminder.rpc.rpc.CallContext;
import com.ca.siteminder.rpc.rpc.ContextConstants;
import com.ca.siteminder.rpc.rpc.RpcContext;
import com.ca.siteminder.rpc.type.TypeRegistry;
import com.ca.siteminder.sdk.adminapi.CacheUpdater;
import com.ca.siteminder.sdk.adminapi.ClassCache;
import com.ca.siteminder.sdk.adminapi.Config;
import com.ca.siteminder.sdk.adminapi.CredentialsProvider;
import com.ca.siteminder.sdk.adminapi.DataDictionary;
import com.ca.siteminder.sdk.adminapi.DirectoryManager;
import com.ca.siteminder.sdk.adminapi.ListCallback;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.ProductInfo;
import com.ca.siteminder.sdk.adminapi.RpcRegistry;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.Server;
import com.ca.siteminder.sdk.adminapi.SessionCache;
import com.ca.siteminder.sdk.adminapi.XPSAPIService;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.XPSObjectImpl;
import com.ca.siteminder.sdk.adminapi.Xlate;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.ca.xps.Product;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import netegrity.siteminder.javaagent.AgentAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements ApplicationContext,
ContextConstants {
    XPSAPIService service;
    RpcContext rpcContext;
    ListCallback callback;
    private final PolicyData policyData = new PolicyData(this);
    private final DataDictionary dictionary;
    private final Security security;
    final SessionCache objectCache;
    final SessionCache objectCacheNew;
    final ClassCache classCache;
    final CacheUpdater cacheUpdater;
    private Server server = new Server(this);
    private DirectoryManager directoryManager = new DirectoryManager(this);
    AgentAPI connection;
    String userPath;
    String sessionTicket;
    boolean transactionInProgress = false;
    boolean local = false;
    boolean supportBG = true;
    int version = 0;
    String workspaceXid;
    Class metadata;
    CredentialsProvider credentialsProvider;

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setSessionTicket(String string) {
        this.sessionTicket = string;
    }

    public String getSessionTicket() {
        return this.sessionTicket;
    }

    public void setUserPath(String string) {
        this.userPath = string;
    }

    public String getUserPath() {
        return this.userPath;
    }

    public void disableStreaming() {
        this.supportBG = false;
    }

    public boolean streamingDisabled() {
        return !this.supportBG;
    }

    public Session() {
        this.dictionary = new DataDictionary(this);
        this.security = new Security(this);
        this.objectCache = new SessionCache(this);
        this.objectCacheNew = new SessionCache(this);
        this.classCache = new ClassCache(this);
        this.cacheUpdater = new CacheUpdater(this);
    }

    public void connect() {
        if (this.credentialsProvider != null) {
            this.sessionTicket = null;
            this.userPath = null;
        }
        if (this.rpcContext == null) {
            this.rpcContext = this.createContext(RpcRegistry.get());
        }
        if (this.callback == null) {
            this.callback = new ListCallback();
        }
        this.service = (XPSAPIService)this.rpcContext.lookup(XPSAPIService.class, (Object)this.callback);
        this.version = this.rpcContext.getServerRpcVersion();
        this.dictionary.init();
        this.cacheUpdater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onResetServerSession(String string, boolean bl, boolean bl2, CallContext callContext) {
        Object object;
        if (this.callback != null) {
            object = this.callback;
            synchronized (object) {
                if (this.callback.resultList != null) {
                    this.callback.resultList.clear();
                }
                if (this.callback.list != null) {
                    this.callback.list.clear();
                }
            }
        }
        if (bl2) {
            if (this.credentialsProvider == null) {
                return false;
            }
            object = new StringBuilder();
            StringBuilder stringBuilder = new StringBuilder();
            this.credentialsProvider.getCredentials((StringBuilder)object, stringBuilder);
            this.rpcContext.relogin(((StringBuilder)object).toString(), stringBuilder.toString(), callContext);
        }
        if (this.cacheUpdater != null) {
            this.cacheUpdater.enable();
        }
        return true;
    }

    public void disconnect() {
        this.cacheUpdater.stopIt();
        this.rpcContext.release();
        this.objectCache.reset();
        this.objectCacheNew.reset();
    }

    public AgentAPI getConnection() {
        return this.connection;
    }

    public void setConnection(AgentAPI agentAPI) {
        this.connection = agentAPI;
    }

    public PolicyData getPolicyData() {
        return this.policyData;
    }

    public Server getServer() {
        return this.server;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public DataDictionary getDictionary() {
        return this.dictionary;
    }

    public Security getSecurity() {
        return this.security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean begin() {
        CacheUpdater cacheUpdater = this.cacheUpdater;
        synchronized (cacheUpdater) {
            if (this.transactionInProgress) {
                throw new XPSException("transaction.begin.alreadyStarted");
            }
            this.cacheUpdater.processUpdate();
            boolean bl = this.service.begin();
            if (bl) {
                this.transactionInProgress = true;
            }
            return bl;
        }
    }

    public boolean commit() {
        return this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(boolean bl) {
        CacheUpdater cacheUpdater = this.cacheUpdater;
        synchronized (cacheUpdater) {
            if (!this.transactionInProgress) {
                throw new XPSException("transaction.commit.notInProgress");
            }
            boolean bl2 = this.service.commit(bl);
            this.cacheUpdater.processUpdate();
            this.transactionInProgress = false;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        CacheUpdater cacheUpdater = this.cacheUpdater;
        synchronized (cacheUpdater) {
            if (!this.transactionInProgress) {
                throw new XPSException("transaction.cancel.notInProgress");
            }
            this.objectCache.reset();
            this.objectCacheNew.reset();
            this.cacheUpdater.reset();
            this.transactionInProgress = false;
            return this.service.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateCache() {
        CacheUpdater cacheUpdater = this.cacheUpdater;
        synchronized (cacheUpdater) {
            if (!this.transactionInProgress) {
                this.objectCache.reset();
                this.objectCacheNew.reset();
                this.cacheUpdater.reset();
            }
            return !this.transactionInProgress;
        }
    }

    public String getProp(String string) {
        if (this.version > 2) {
            return this.service.getProp(string);
        }
        return "";
    }

    public String getPolicyServerVersionInfo() {
        return this.getProp("PolicyServerVersionInfo");
    }

    public String callService(String string, String string2, String string3, String string4, Map<String, String> map) {
        return this.service.Session_service(string, string2, string3, string4, map);
    }

    public String callService(String string, String string2, String string3, String string4) {
        return this.service.Session_service(string, string2, string3, string4, null);
    }

    public List<ProductInfo> getProductInfo() {
        return this.service.Session_getProductInfo();
    }

    public void setLocale(String string, String string2) {
        this.service.Session_setLocale(string, string2);
    }

    public void setLocale(Locale locale) {
        this.service.Session_setLocale(locale.getCountry(), locale.getLanguage());
    }

    private void setCredentials(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        this.credentialsProvider.getCredentials(stringBuilder, stringBuilder2);
        map.put("userId", stringBuilder.toString());
        map.put("adminPwd", stringBuilder2.toString());
    }

    public void setContext(Map<String, Object> map) {
        if (this.credentialsProvider != null) {
            this.setCredentials(map);
        }
        this.rpcContext = new RpcContext((TypeRegistry)RpcRegistry.get(), map);
        this.rpcContext.setApplicationContext((ApplicationContext)this);
    }

    public Config getConfig(String string, String string2) {
        return new Config(string, string2, this);
    }

    public Config getConfig(Product product) {
        return new Config(product.getVendor().getName(), product.getName(), this);
    }

    public Xlate getXlate(Locale locale, String string) {
        return new Xlate(this, locale, string);
    }

    public Xlate getXlate(String string, String string2, String string3) {
        return new Xlate(this, string, string2, string3);
    }

    RpcContext createContext(TypeRegistry typeRegistry) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.userPath == null && this.sessionTicket == null && this.credentialsProvider == null) {
            hashMap.put("local", true);
            this.local = true;
            this.supportBG = false;
        }
        if (this.credentialsProvider != null) {
            this.setCredentials(hashMap);
        } else {
            if (this.userPath != null) {
                hashMap.put("userId", this.userPath);
            }
            if (this.sessionTicket != null) {
                hashMap.put("sessionTicket", this.sessionTicket);
            }
        }
        if (this.connection != null) {
            hashMap.put("connection", this.connection);
        }
        if (!this.supportBG) {
            hashMap.put("ns", "1");
        }
        RpcContext rpcContext = new RpcContext(typeRegistry, hashMap);
        rpcContext.setApplicationContext((ApplicationContext)this);
        return rpcContext;
    }

    XPSObject makeStub(String string) {
        XPSObject xPSObject = this.objectCache.get(string);
        if (xPSObject != null) {
            return xPSObject;
        }
        String string2 = DDClass.classNameOfXid(string);
        XPSObjectImpl xPSObjectImpl = new XPSObjectImpl(true);
        xPSObjectImpl.setXid(string);
        IClass<? extends XPSObject> iClass = this.classCache.getClass(string2);
        xPSObjectImpl.setBaseClass(iClass);
        xPSObjectImpl.session = this;
        xPSObject = XPSObject.newInstance(xPSObjectImpl);
        this.objectCache.insert(xPSObject, false);
        return xPSObject;
    }

    void resolveStub(XPSObjectImpl xPSObjectImpl) {
        if (this.version < 2) {
            String string = xPSObjectImpl.getXid();
            XPSObject xPSObject = this.objectCacheNew.get(string);
            XPSObject xPSObject2 = null;
            if (xPSObject == null) {
                xPSObject2 = this.service.PolicyData_fetchObject(string, false);
                xPSObject = this.objectCacheNew.get(string);
            }
            if (!xPSObjectImpl.stub) {
                return;
            }
            if (xPSObject != null) {
                xPSObject.impl.transferTo(xPSObjectImpl);
                this.objectCacheNew.remove(string);
            } else if (xPSObject2 != null && !xPSObject2.impl.stub) {
                xPSObject2.impl.transferTo(xPSObjectImpl);
            }
        } else {
            String string = xPSObjectImpl.getXid();
            XPSObject xPSObject = this.service.PolicyData_fetchObject(string, false);
            if (xPSObjectImpl.isStub()) {
                xPSObject.impl.transferTo(xPSObjectImpl);
            }
        }
    }
}

