/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi;

import com.ca.siteminder.sdk.adminapi.BaseObject;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSBase;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Bit;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.ca.xps.Product;
import com.ca.siteminder.sdk.adminapi.ca.xps.Vendor;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.DDProduct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDictionary
extends XPSBase {
    private static final Logger logger = Logger.getLogger(DataDictionary.class);
    List<Vendor> vendors;
    List<DDProduct> clientProducts;
    Set<Product> missingClientProducts;

    DataDictionary(Session session) {
        this.session = session;
    }

    public List<Vendor> listVendors() {
        return this.vendors;
    }

    public Vendor fetchVendor(String string) {
        String string2 = "CA.XPS::Vendor@" + string;
        return (Vendor)this.fetchObject(string2);
    }

    public Product fetchProduct(String string, String string2) {
        String string3 = "CA.XPS::Product@" + string + "." + string2;
        return (Product)this.fetchObject(string3);
    }

    public Product fetchProduct(String string) {
        String string2 = "CA.XPS::Product@" + string;
        return (Product)this.fetchObject(string2);
    }

    public Class fetchClass(String string, String string2, String string3) {
        String string4 = "CA.XPS::Class@" + string + "." + string2 + "::" + string3;
        return (Class)this.fetchObject(string4);
    }

    public Class fetchClass(String string) {
        String string2 = "CA.XPS::Class@" + string;
        return (Class)this.fetchObject(string2);
    }

    void init() {
        this.bootstrap();
        this.initServerProducts();
        this.initClientProducts();
        this.session.metadata = this.fetchClass("CA.XPS::MetaAttributes");
        this.session.classCache.init();
    }

    void bootstrap() {
        this.session.classCache.bootstrap();
    }

    private void initServerProducts() {
        BaseObject baseObject;
        Iterator<Bit> iterator;
        this.vendors = this.search1(Vendor.ddclass);
        for (Vendor list2 : this.vendors) {
            iterator = list2.getProducts();
            Iterator<Product> iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                baseObject = iterator2.next();
                List<Class> list = ((Product)baseObject).getClasses();
                for (Class clazz : list) {
                    this.session.classCache.addClass(clazz);
                }
            }
        }
        List<Attribute> list4 = this.search1(Attribute.ddclass);
        Iterator iterator3 = list4.iterator();
        while (iterator3.hasNext()) {
            iterator = (Attribute)iterator3.next();
            Class clazz = ((Attribute)((Object)iterator)).getParent();
            clazz.addAttribute((Attribute)((Object)iterator));
        }
        List<Bit> list = this.search1(Bit.ddclass);
        for (Bit bit : list) {
            baseObject = bit.getParent();
            ((Attribute)baseObject).addBit(bit);
        }
    }

    private void initClientProducts() {
        this.clientProducts = new ArrayList<DDProduct>();
        this.missingClientProducts = new HashSet<Product>();
        for (Vendor vendor : this.vendors) {
            List<Product> list = vendor.getProducts();
            for (Product product : list) {
                String string = product.getFQName();
                DDProduct dDProduct = DDProduct.get(string);
                if (dDProduct == null) {
                    this.missingClientProducts.add(product);
                    continue;
                }
                this.clientProducts.add(dDProduct);
                for (DDClass<? extends XPSObject> dDClass : dDProduct.getClasses()) {
                    this.session.classCache.addDDClass(dDClass);
                }
            }
        }
    }

    public void analyze() {
        StringBuilder stringBuilder = new StringBuilder("Missing Client Products:");
        if (!this.missingClientProducts.isEmpty()) {
            for (Product iProduct : this.missingClientProducts) {
                stringBuilder.append(" ").append(iProduct.getFQName());
            }
            logger.warn((Object)stringBuilder.toString());
        }
        for (DDProduct dDProduct : this.clientProducts) {
            this.analyzeProduct(dDProduct);
        }
    }

    private void analyzeProduct(DDProduct dDProduct) {
        String string = "CA.XPS::Product@" + dDProduct.getFQName();
        Product product = (Product)this.fetchObject(string);
        List<Class> list = product.getClasses();
        List<DDClass<? extends XPSObject>> list2 = dDProduct.getClasses();
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        for (Class hashSet2 : list) {
            hashMap.put(hashSet2.getName(), hashSet2);
        }
        HashMap hashMap2 = new HashMap();
        for (DDClass<? extends XPSObject> dDClass : list2) {
            hashMap2.put(dDClass.getName(), dDClass);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Class clazz : list) {
            String string2 = clazz.getName();
            DDClass dDClass = (DDClass)hashMap2.get(string2);
            if (dDClass == null) {
                logger.warn((Object)("Missing class: " + clazz.getFQName()));
            }
            hashSet.add(string2);
        }
        for (DDClass<? extends XPSObject> dDClass : list2) {
            if (hashSet.contains(dDClass.getName())) continue;
            logger.warn((Object)("Extra class: " + dDClass.getFQName()));
        }
    }
}

