/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SmRC2HmacSHA1CryptoProvider
extends SmRC2CryptoProvider {
    protected Mac m_hmac = null;
    protected Key m_hmacEncryptKey = null;
    protected Key m_hmacDecryptKey = null;

    SmRC2HmacSHA1CryptoProvider(String string, boolean bl) throws SmCryptoProviderException {
        super(string, bl);
        this.m_digestAlg = "HmacSHA1";
        this.m_verifyDigest = true;
        try {
            this.m_hmac = Mac.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SmCryptoProviderException(noSuchAlgorithmException);
        }
    }

    protected void initParams() throws SmCryptoProviderException {
        super.initParams();
        this.m_hmacEncryptKey = new SecretKeySpec(this.m_encryptKey.getEncoded(), this.m_digestAlg);
        this.m_hmacDecryptKey = new SecretKeySpec(this.m_decryptKey.getEncoded(), this.m_digestAlg);
        try {
            this.m_hmac.init(this.m_hmacEncryptKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SmCryptoProviderException(invalidKeyException);
        }
        this.m_digestLength = this.m_hmac.getMacLength();
    }

    protected byte[] makeDigest(byte[] byArray, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.makeDigest(byArray, byArray.length, bl);
    }

    protected byte[] makeDigest(byte[] byArray, int n2, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = null;
        try {
            mac = (Mac)this.m_hmac.clone();
            mac.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = null;
        }
        if (mac == null) {
            mac = Mac.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        if (bl) {
            mac.init(this.m_hmacEncryptKey);
        } else {
            mac.init(this.m_hmacDecryptKey);
        }
        mac.update(byArray, 0, n2);
        return mac.doFinal();
    }
}

