/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.util;

import com.netegrity.util.DigestSha256;
import com.netegrity.util.Utils;
import com.rsa.jsafe.JSAFE_Recode;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.util.Arrays;

public class AesCryptoProviderString {
    private static final int AES_BLOCK_SIZE = 16;
    private static final int AES128_KEY_SIZE = 16;
    private static final int DEFAULT_KEY_STRENGTH = 128;
    private static final int HMAC_KEY_MIN = 16;
    private static final int HMAC_SIZE = 28;
    private static final String algoCrypt = "AES128/CBC/PKCS5Padding";
    private byte[] m_IV;
    private boolean m_isReady = false;
    private byte[] m_hmacKey = null;
    private JSAFE_SymmetricCipher encryptor = null;
    private JSAFE_SymmetricCipher decryptor = null;

    public AesCryptoProviderString() {
    }

    public AesCryptoProviderString(byte[] key) {
        if (null == key || key.length < 48) {
            return;
        }
        byte[] theIV = new byte[16];
        byte[] theKey = new byte[16];
        byte[] theHmacKey = new byte[key.length - 32];
        this.m_hmacKey = new byte[2];
        try {
            System.arraycopy(key, 0, theIV, 0, 16);
            System.arraycopy(key, 16, theKey, 0, 16);
            System.arraycopy(key, 32, theHmacKey, 0, theHmacKey.length);
            int status = this.Init(theIV, theKey, 128, theHmacKey);
            if (0 == status) {
                this.m_isReady = true;
            }
        }
        catch (Throwable th) {
            this.m_isReady = false;
        }
        Utils.Zeroize(theIV);
        Utils.Zeroize(theKey);
        Utils.Zeroize(theHmacKey);
    }

    public int Init(byte[] initVector, byte[] aesKey, int aesKeyStrength, byte[] hmacKey) {
        JSAFE_SecretKey secKey = null;
        int returnStatus = -2;
        if (null == initVector || 16 > initVector.length || null == aesKey || 16 > aesKey.length || null == hmacKey || 16 > hmacKey.length) {
            return -1;
        }
        try {
            int keyLen = (aesKey.length + 7) / 8;
            System.arraycopy(aesKey, 0, this.m_hmacKey, 0, keyLen);
            secKey = JSAFE_SecretKey.getInstance((String)"AES", (String)"Java");
            secKey.setSecretKeyData(aesKey, 0, 16);
            this.encryptor = JSAFE_SymmetricCipher.getInstance((String)algoCrypt, (String)"Java");
            this.encryptor.setIV(initVector, 0, 16);
            this.encryptor.encryptInit(secKey);
            secKey.clearSensitiveData();
            secKey.setSecretKeyData(aesKey, 0, 16);
            this.decryptor = JSAFE_SymmetricCipher.getInstance((String)algoCrypt, (String)"Java");
            this.decryptor.setIV(initVector, 0, 16);
            this.decryptor.decryptInit(secKey);
            returnStatus = 0;
            if (null != secKey) {
                secKey.clearSensitiveData();
            }
        }
        catch (Throwable th) {
            returnStatus = -13;
            this.clearSensitiveData();
        }
        return returnStatus;
    }

    public void clearSensitiveData() {
        if (null != this.encryptor) {
            this.encryptor.clearSensitiveData();
            this.encryptor = null;
        }
        if (null != this.decryptor) {
            this.decryptor.clearSensitiveData();
            this.decryptor = null;
        }
        Utils.Zeroize(this.m_hmacKey);
        this.m_hmacKey = null;
        this.m_isReady = false;
    }

    public static int GetLength(int inputLength) {
        int retVal = 28;
        if (inputLength > 0) {
            retVal += inputLength;
        }
        retVal = retVal + 16 & 0x7FFFFFF0;
        return retVal;
    }

    public byte[] Encrypt(byte[] data, int offset, int dataSize) {
        if (null == data && dataSize > 0 || dataSize < 0 || null != data && dataSize > data.length) {
            return null;
        }
        byte[] retBuff = null;
        byte[] theHmac = null;
        try {
            theHmac = null;
            theHmac = DigestSha256.getHMAC(this.m_hmacKey, data, 0, dataSize);
            int hmacUsedLength = 28 + dataSize;
            byte[] cipherText = new byte[this.encryptor.getOutputBufferSize(hmacUsedLength)];
            int totalOut = 0;
            totalOut += this.encryptor.encryptUpdate(theHmac, 0, 28, cipherText, 0);
            totalOut += this.encryptor.encryptUpdate(data, 0, dataSize, cipherText, totalOut);
            totalOut += this.encryptor.encryptFinal(cipherText, totalOut);
            if (cipherText.length != totalOut) {
                Utils.Zeroize(retBuff);
                retBuff = null;
            }
            JSAFE_Recode encoder = null;
            encoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
            encoder.encodeInit();
            int outSize = encoder.getOutputBufferSize(cipherText.length);
            byte[] encodedAssertion = new byte[outSize];
            int outLenUpdate = encoder.encodeUpdate(cipherText, 0, cipherText.length, encodedAssertion, 0);
            int outLenFinal = encoder.encodeFinal(encodedAssertion, outLenUpdate);
            retBuff = new byte[outLenUpdate + outLenFinal];
            System.arraycopy(encodedAssertion, 0, retBuff, 0, outLenUpdate + outLenFinal);
        }
        catch (Throwable th) {
            Utils.Zeroize(retBuff);
            retBuff = null;
        }
        Utils.Zeroize(theHmac);
        theHmac = null;
        return retBuff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] Decrypt(byte[] buff, int offset, int inLength) {
        if (null == buff) return null;
        if (inLength > buff.length) return null;
        if (48 > inLength) {
            return null;
        }
        byte[] theHmac = null;
        byte[] decoded = null;
        byte[] retData = null;
        int hmacUsedLength = 0;
        int updateSize = 0;
        int finalSize = 0;
        JSAFE_Recode decoder = null;
        try {
            try {
                decoder = JSAFE_Recode.getInstance((String)"Base64-0", (String)"Java");
                decoder.decodeInit();
                decoded = new byte[decoder.getOutputBufferSize(buff.length)];
                updateSize = decoder.decodeUpdate(buff, 0, buff.length, decoded, 0);
                finalSize = 0;
                finalSize = decoder.decodeFinal(decoded, updateSize);
                decoder.clearSensitiveData();
                boolean isOK = true;
                byte[] decryptedData = new byte[this.decryptor.getOutputBufferSize(updateSize + finalSize)];
                int partOut = this.decryptor.decryptUpdate(decoded, 0, updateSize + finalSize, decryptedData, 0);
                int finalOut = this.decryptor.decryptFinal(decryptedData, partOut);
                hmacUsedLength = 28;
                byte[] cookieHmac = new byte[hmacUsedLength];
                System.arraycopy(decryptedData, 0, cookieHmac, 0, hmacUsedLength);
                int messageLength = (finalOut += partOut) - 28;
                retData = new byte[messageLength];
                System.arraycopy(decryptedData, hmacUsedLength, retData, 0, messageLength);
                theHmac = DigestSha256.getHMAC(this.m_hmacKey, retData, 0, messageLength);
                boolean hmacBad = false;
                byte[] finalHmac = new byte[28];
                System.arraycopy(theHmac, 0, finalHmac, 0, 28);
                if (!Arrays.equals(cookieHmac, finalHmac)) {
                    hmacBad = true;
                    throw new Exception("Bad HMAC value");
                }
                Object var20_20 = null;
            }
            catch (Exception e) {
                Utils.Zeroize(retData);
                retData = null;
                Object var20_21 = null;
                Utils.Zeroize(theHmac);
                if (this.decryptor == null) return retData;
                this.decryptor.clearSensitiveData();
                return retData;
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            Utils.Zeroize(theHmac);
            if (this.decryptor == null) throw throwable;
            this.decryptor.clearSensitiveData();
            throw throwable;
        }
        Utils.Zeroize(theHmac);
        if (this.decryptor == null) return retData;
        this.decryptor.clearSensitiveData();
        return retData;
    }
}

