/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.session;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnection;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.resources.SmSessionManagementMessages;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagement;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementException;
import com.ca.siteminder.sdk.agentapi.session.SmAgentApiSessionManagementResult;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliPacket;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.ResourceBundle;

public class SmAgentApiSessionManagementImpl
implements SmAgentApiSessionManagement,
SmAgentApiConstants {
    private static final String MESSAGES_CLASSNAME = SmSessionManagementMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private SmAgentApiConnection m_connection = null;

    public SmAgentApiSessionManagementImpl(SmAgentApiConnection connection) {
        this.m_connection = connection;
    }

    public SmAgentApiSessionManagementResult getSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.processSessionVariables(transactionId, sessionId, resourceContextDef, variables, 137, false);
    }

    public SmAgentApiSessionManagementResult setSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.processSessionVariables(transactionId, sessionId, resourceContextDef, variables, 138, true);
    }

    public SmAgentApiSessionManagementResult delSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return this.processSessionVariables(transactionId, sessionId, resourceContextDef, variables, 139, false);
    }

    private SmAgentApiSessionManagementResult processSessionVariables(String transactionId, String sessionId, SmResourceContextDef resourceContextDef, List variables, int type, boolean bAddValues) throws SmAgentApiSessionManagementException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        if (this.m_connection == null || this.m_connection.isClosed()) {
            throw new SmAgentApiNotInitializedException(-3, c_bundle.getString("M_UNINITIALIZED_CONNECTION"));
        }
        if (sessionId == null) {
            throw new SmAgentApiSessionManagementException(-4, c_bundle.getString("M_INVALID_SESSION_ID"));
        }
        if (variables == null) {
            throw new SmAgentApiSessionManagementException(-4, c_bundle.getString("M_INVALID_LIST_VARIABLES"));
        }
        String agent = this.m_connection.getAgentName(resourceContextDef);
        if (agent == null) {
            throw new SmAgentApiSessionManagementException(-4, c_bundle.getString("M_INVALID_AGENT_NAME"));
        }
        SmAgentTliPacket request = new SmAgentTliPacket();
        request.setType(type);
        try {
            if (transactionId != null) {
                request.setAttribute(221, transactionId.getBytes("UTF-8"));
            }
            request.setAttribute(200, agent.getBytes("UTF-8"));
            request.setAttribute(205, sessionId.getBytes("UTF-8"));
            for (SmAttribute attr : variables) {
                if (attr == null || attr.getOid() == null) {
                    throw new SmAgentApiSessionManagementException(-4, c_bundle.getString("M_INVALID_ATTRIBUTE"));
                }
                request.setAttribute(140, attr.getOid().getBytes("UTF-8"));
                if (bAddValues) {
                    request.setAttribute(141, attr.getValue());
                }
                request.setAttribute(142, String.valueOf(attr.getFlags()).getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiSessionManagementException(e);
        }
        int[] status = new int[1];
        SmAgentTliPacket response = (SmAgentTliPacket)this.m_connection.processRequest(request, status);
        if (status[0] != 0) {
            throw new SmAgentApiSessionManagementException(status[0], c_bundle.getString("M_FAILED_REQUEST"));
        }
        if (response == null) {
            throw new SmAgentApiSessionManagementException(-1, c_bundle.getString("M_INVALID_RESPONSE"));
        }
        int code = response.getType();
        switch (code) {
            case 2: {
                return new SmAgentApiSessionManagementResult(true, response.getAttributes());
            }
            case 3: {
                return new SmAgentApiSessionManagementResult(false, response.getAttributes());
            }
            case 5: {
                return new SmAgentApiSessionManagementResult(false, response.getAttributes(), true);
            }
        }
        throw new SmAgentApiSessionManagementException(-1, c_bundle.getString("M_UNRECOGNIZED_RESPONSE"));
    }
}

