/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class SmRC2HmacSHA1CryptoProvider
extends SmRC2CryptoProvider {
    protected Mac m_hmac = null;
    protected Key m_hmacEncryptKey = null;
    protected Key m_hmacDecryptKey = null;

    SmRC2HmacSHA1CryptoProvider(String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        super(keyDigestAlg, bAscii);
        this.m_digestAlg = "HmacSHA1";
        this.m_verifyDigest = true;
        try {
            this.m_hmac = Mac.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SmCryptoProviderException(e);
        }
    }

    protected void initParams() throws SmCryptoProviderException {
        super.initParams();
        this.m_hmacEncryptKey = new SecretKeySpec(this.m_encryptKey.getEncoded(), this.m_digestAlg);
        this.m_hmacDecryptKey = new SecretKeySpec(this.m_decryptKey.getEncoded(), this.m_digestAlg);
        try {
            this.m_hmac.init(this.m_hmacEncryptKey);
        }
        catch (InvalidKeyException e) {
            throw new SmCryptoProviderException(e);
        }
        this.m_digestLength = this.m_hmac.getMacLength();
    }

    protected byte[] makeDigest(byte[] input, boolean bEncryptionMode) throws NoSuchAlgorithmException, InvalidKeyException {
        return this.makeDigest(input, input.length, bEncryptionMode);
    }

    protected byte[] makeDigest(byte[] input, int inLength, boolean bEncryptionMode) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmac = null;
        try {
            hmac = (Mac)this.m_hmac.clone();
            hmac.reset();
        }
        catch (CloneNotSupportedException e) {
            hmac = null;
        }
        if (hmac == null) {
            hmac = Mac.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        if (bEncryptionMode) {
            hmac.init(this.m_hmacEncryptKey);
        } else {
            hmac.init(this.m_hmacDecryptKey);
        }
        hmac.update(input, 0, inLength);
        return hmac.doFinal();
    }
}

