/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import java.util.ResourceBundle;

class SmRequestCounter {
    private static final String MESSAGES_CLASSNAME = SmConnectionMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private float m_averageResponseTime = 0.0f;
    private long m_currentThroughput = 0L;
    private long m_averageThroughput = 0L;
    private long m_maxThroughput = 0L;
    private long m_minThroughput = 0L;
    private long m_processedRequestCount = 0L;
    private long m_processedRequestCountStart = 0L;
    private long m_throughputMeasurementPeriod = 20L;
    private boolean m_trackResponseTime = false;
    private float m_delta = 0.99f;

    SmRequestCounter(long throughputMeasurementPeriod) throws SmAgentApiConnectionException {
        if (this.m_throughputMeasurementPeriod <= 0L) {
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_REQUEST_COUNTER"));
        }
        this.m_throughputMeasurementPeriod = throughputMeasurementPeriod / 1000L;
    }

    SmRequestCounter(long throughputMeasurementPeriod, boolean bTrackResponseTime) throws SmAgentApiConnectionException {
        if (this.m_throughputMeasurementPeriod <= 0L) {
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_REQUEST_COUNTER"));
        }
        this.m_throughputMeasurementPeriod = throughputMeasurementPeriod / 1000L;
        this.m_trackResponseTime = bTrackResponseTime;
    }

    synchronized float getAverageResponseTime() {
        return this.m_averageResponseTime;
    }

    synchronized long getCurrentThroughput() {
        return this.m_currentThroughput;
    }

    synchronized long getAverageThroughput() {
        return this.m_averageThroughput;
    }

    synchronized long getMaxThroughput() {
        return this.m_maxThroughput;
    }

    synchronized long getMinThroughput() {
        return this.m_minThroughput;
    }

    synchronized void reset() {
        this.m_currentThroughput = 0L;
        this.m_averageThroughput = 0L;
        this.m_maxThroughput = 0L;
        this.m_minThroughput = 0L;
        this.m_processedRequestCount = 0L;
        this.m_processedRequestCountStart = 0L;
        if (this.m_trackResponseTime) {
            this.m_delta = 0.99f;
            this.m_averageResponseTime = 0.0f;
        }
    }

    synchronized void addRequestTimeSample(long now, long responseTime) {
        long countPeriod = (now - this.m_processedRequestCountStart) / 1000L;
        if (this.m_processedRequestCountStart == 0L) {
            if (countPeriod > 10L) {
                this.m_processedRequestCountStart = now - responseTime;
                this.m_processedRequestCount = 0L;
            }
        } else if (countPeriod > this.m_throughputMeasurementPeriod) {
            long thr;
            this.m_currentThroughput = thr = this.m_processedRequestCount / countPeriod;
            this.m_averageThroughput = this.m_currentThroughput > 0L ? (this.m_currentThroughput + thr) / 2L : thr;
            this.m_maxThroughput = this.m_currentThroughput > this.m_maxThroughput ? this.m_currentThroughput : this.m_maxThroughput;
            this.m_minThroughput = this.m_minThroughput != 0L || this.m_currentThroughput < this.m_minThroughput ? this.m_currentThroughput : this.m_minThroughput;
            this.m_processedRequestCountStart = now;
            this.m_processedRequestCount = 0L;
            if (this.m_trackResponseTime) {
                long clampedTput = Math.max(100L, this.m_currentThroughput / 2L);
                this.m_delta = (float)(clampedTput - 1L) / (float)clampedTput;
            }
        }
        ++this.m_processedRequestCount;
        if (this.m_trackResponseTime) {
            this.m_averageResponseTime = this.m_delta * this.m_averageResponseTime + (1.0f - this.m_delta) * (float)responseTime;
        }
    }
}

