/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.accesscontrol.SmResourceContextDef;
import com.ca.siteminder.sdk.agentapi.config.SmConfigAttribute;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmCluster;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentPacket;
import com.ca.siteminder.sdk.agentapi.tli.SmAgentTliBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;

public class SmAgentApiConnection
implements SmAgentApiConstants {
    private static final String CLASS_NAME = "SmAgentApiConnection";
    private static final String MESSAGES_CLASSNAME;
    private static ResourceBundle c_bundle;
    private static final int SLEEP_DELAY = 30;
    private SmInitDef m_initDef = null;
    private List m_clusters = new ArrayList();
    private boolean m_isClosed = false;
    private Thread m_connMgrThread = null;
    private int m_currentClusterIndex = -1;
    private int m_previousClusterIndex = -1;
    private long m_timestamp = 0L;
    private Timer m_timer = null;
    private Object m_connMgrLock = new Object();
    private static SmCryptoProvider c_keepCryptoLoaded;

    public static SmAgentApiConnection getConnection(String configFileName) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        SmAgentApiConnection connection = new SmAgentApiConnection();
        connection.init(configFileName, null);
        return connection;
    }

    public static SmAgentApiConnection getConnection(SmInitDef initDef) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        SmAgentApiConnection connection = new SmAgentApiConnection();
        connection.init(null, initDef);
        return connection;
    }

    protected SmAgentApiConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String configFileName, SmInitDef initDef) throws SmAgentApiConnectionException, SmCryptoProviderException, SmConfigException {
        String methodName = "init";
        if ((configFileName == null || configFileName.length() == 0) && initDef == null) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Null parameters passed");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_CONFIG_INFO"));
        }
        this.m_initDef = initDef;
        if (this.m_initDef == null) {
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "init", "Creating SmInitDef from configFile = " + configFileName);
            }
            try {
                this.m_initDef = Util.createSmInitDef(configFileName);
            }
            catch (SmAgentApiNotInitializedException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "init", "Invalid configuration properties used to create connections: " + e);
                }
                throw new SmAgentApiConnectionException(-1, c_bundle.getString("M_INVALID_CONFIGURATION_PROPERTIES"), e);
            }
        } else if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "init", "Got SmInitDef from args, config file = " + (this.m_initDef.getSmConfigFile() == null ? "<none>" : this.m_initDef.getSmConfigFile().getFilename()));
        }
        this.m_clusters = this.m_initDef.getClusters();
        if (this.m_clusters == null || this.m_clusters.size() == 0) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Found no clusters in SmInitDef");
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_INVALID_POLICY_SERVER"));
        }
        boolean allClustersFailed = true;
        int failedHandShakeClusters = 0;
        Object object = this.m_connMgrLock;
        synchronized (object) {
            for (SmCluster thisCluster : this.m_clusters) {
                if (Util.isLogEnabled()) {
                    thisCluster.logStats();
                }
                if (thisCluster.enable()) {
                    if (Util.isLogEnabled()) {
                        Util.display(3, CLASS_NAME, "init", "Enabled cluster - setting active");
                    }
                    thisCluster.setState(3, 2);
                    allClustersFailed = false;
                    break;
                }
                if (Util.isLogEnabled()) {
                    Util.display(3, CLASS_NAME, "init", "Could not enable cluster - setting inactive");
                }
                thisCluster.setState(3, 1);
                if (thisCluster.failedHandShakeCount() <= 0) continue;
                ++failedHandShakeClusters;
            }
        }
        if (allClustersFailed) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "init", "Failed to enable any clusters");
            }
            if (failedHandShakeClusters > 0) {
                throw new SmConfigException(c_bundle.getString("M_FAILED_HANDSHAKE"));
            }
            throw new SmAgentApiConnectionException(c_bundle.getString("M_FAILED_ENABLING_ANY_CLUSTERS"));
        }
        this.m_connMgrThread = new Thread(){

            public void run() {
                if (Util.isLogEnabled()) {
                    Util.display(4, SmAgentApiConnection.CLASS_NAME, "init", "* Connection thread starting");
                }
                SmAgentApiConnection.this.runConnectionManager();
                if (Util.isLogEnabled()) {
                    Util.display(4, SmAgentApiConnection.CLASS_NAME, "init", "* Connection thread terminating");
                }
            }
        };
        this.m_timer = new Timer();
        this.m_connMgrThread.start();
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SmAgentPacket processRequest(SmAgentPacket request, int[] result) {
        String methodName = "processRequest";
        if (result == null || result.length < 1) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "processRequest", "Null result array passed - quitting");
            }
            return null;
        }
        result[0] = 0;
        while (true) {
            Object object;
            Object var8_7;
            if (this.isClosed()) {
                result[0] = -1;
                return null;
            }
            SmCluster cluster = this.findCluster();
            if (cluster == null) {
                if (result[0] != -2) {
                    result[0] = -1;
                }
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "processRequest", "No active cluster found to process connection request; returning " + result[0]);
                }
                return null;
            }
            SmAgentPacket response = null;
            try {
                try {
                    response = cluster.processRequest(request, result);
                }
                catch (Throwable e) {
                    result[0] = -1;
                    if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "processRequest", "Chosen cluster aborted processRequest: " + e);
                        e.printStackTrace();
                    }
                    var8_7 = null;
                    if (result[0] == 0) {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "processRequest", "Cluster processRequest returned successfully");
                        }
                        return response;
                    }
                    object = this.m_connMgrLock;
                    synchronized (object) {
                        if (cluster.setState(2, 1)) {
                            if (Util.isLogEnabled()) {
                                Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, set cluster to inactive - result status = " + result[0]);
                            }
                            if (this.getCurrentClusterIndex() > -1 && this.m_clusters.get(this.getCurrentClusterIndex()) == cluster) {
                                this.resetCurrentClusterIndex();
                            }
                        } else if (Util.isLogEnabled()) {
                            Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, cluster not set to inactive - result status = " + result[0]);
                        }
                        continue;
                    }
                }
                var8_7 = null;
            }
            catch (Throwable throwable) {
                var8_7 = null;
                if (result[0] == 0) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "processRequest", "Cluster processRequest returned successfully");
                    }
                    return response;
                }
                object = this.m_connMgrLock;
                synchronized (object) {
                    if (cluster.setState(2, 1)) {
                        if (Util.isLogEnabled()) {
                            Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, set cluster to inactive - result status = " + result[0]);
                        }
                        if (this.getCurrentClusterIndex() > -1 && this.m_clusters.get(this.getCurrentClusterIndex()) == cluster) {
                            this.resetCurrentClusterIndex();
                        }
                    } else if (Util.isLogEnabled()) {
                        Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, cluster not set to inactive - result status = " + result[0]);
                    }
                    throw throwable;
                }
            }
            if (result[0] == 0) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "processRequest", "Cluster processRequest returned successfully");
                }
                return response;
            }
            object = this.m_connMgrLock;
            synchronized (object) {
                if (cluster.setState(2, 1)) {
                    if (Util.isLogEnabled()) {
                        Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, set cluster to inactive - result status = " + result[0]);
                    }
                    if (this.getCurrentClusterIndex() > -1 && this.m_clusters.get(this.getCurrentClusterIndex()) == cluster) {
                        this.resetCurrentClusterIndex();
                    }
                } else if (Util.isLogEnabled()) {
                    Util.display(3, CLASS_NAME, "processRequest", "Chosen cluster did not succeed, cluster not set to inactive - result status = " + result[0]);
                }
            }
        }
    }

    protected void runConnectionManager() {
        while (!this.isClosed()) {
            this.processClusters();
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SmCluster findCluster() {
        String methodName = "findCluster";
        SmCluster cluster = null;
        int index = this.getCurrentClusterIndex();
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "findCluster", "Looking for cluster index = " + index + ", clusters size = " + this.m_clusters.size());
        }
        if (index == -1) {
            Object object = this.m_connMgrLock;
            synchronized (object) {
                if (this.getCurrentClusterIndex() == -1) {
                    SmCluster next;
                    for (index = 0; index < this.m_clusters.size(); ++index) {
                        next = (SmCluster)this.m_clusters.get(index);
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "findCluster", "Processing cluster " + index + " status " + next.getStatus());
                        }
                        if (next.getState() != 2) continue;
                        cluster = next;
                        this.setCurrentClusterIndex(index);
                        if (!Util.isLogEnabled()) break;
                        Util.display(5, CLASS_NAME, "findCluster", "Found active cluster at index " + index);
                        break;
                    }
                    if (cluster == null) {
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "findCluster", "No active clusters found, looking for disabled clusters...");
                        }
                        for (index = 0; index < this.m_clusters.size(); ++index) {
                            next = (SmCluster)this.m_clusters.get(index);
                            if (next.getState() != 3) continue;
                            boolean bEnabled = false;
                            try {
                                bEnabled = next.enable();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            if (bEnabled) {
                                cluster = next;
                                cluster.setState(3, 2);
                                this.setCurrentClusterIndex(index);
                                if (!Util.isLogEnabled()) break;
                                Util.display(5, CLASS_NAME, "findCluster", "Enabled cluster at index " + index);
                                break;
                            }
                            next.setState(3, 1);
                            if (!Util.isLogEnabled()) continue;
                            Util.display(3, CLASS_NAME, "findCluster", "Failed to enable cluster at index " + index);
                        }
                    }
                }
                index = this.getCurrentClusterIndex();
            }
        }
        if (index >= 0 && index < this.m_clusters.size()) {
            cluster = (SmCluster)this.m_clusters.get(index);
        }
        if (cluster == null && Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "findCluster", "No active clusters found.");
        }
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processClusters() {
        String methodName = "processClusters";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "processClusters", "[connThread] Started w/cluster size = " + this.m_clusters.size());
        }
        boolean foundActive = false;
        int index = 0;
        while (index < this.m_clusters.size()) {
            int curState;
            SmCluster next = (SmCluster)this.m_clusters.get(index);
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "processClusters", "[connThread] Processing cluster " + index + " status " + next.getStatus());
                next.logStats();
            }
            Object object = this.m_connMgrLock;
            synchronized (object) {
                curState = next.getState();
            }
            switch (curState) {
                case 1: {
                    if (foundActive) {
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "processClusters", "[connThread] Disabling cluster index = " + index);
                        }
                        object = this.m_connMgrLock;
                        synchronized (object) {
                            next.disable();
                            next.setState(1, 3);
                            break;
                        }
                    }
                    try {
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "processClusters", "[connThread] Reviving cluster index " + index);
                        }
                        if (next.revive()) {
                            if (Util.isLogEnabled()) {
                                Util.display(4, CLASS_NAME, "processClusters", "[connThread] Success reviving cluster " + index);
                            }
                            object = this.m_connMgrLock;
                            synchronized (object) {
                                if (next.setState(1, 2)) {
                                    this.resetCurrentClusterIndex();
                                }
                                break;
                            }
                        }
                        if (!Util.isLogEnabled()) break;
                        Util.display(3, CLASS_NAME, "processClusters", "[connThread] Failed reviving cluster " + index);
                    }
                    catch (SmAgentApiException e) {
                        if (!Util.isLogEnabled()) break;
                        Util.display(3, CLASS_NAME, "processClusters", "[connThread] Exception reviving cluster " + index + ": " + e);
                    }
                    break;
                }
                case 2: {
                    Object e2;
                    try {
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "processClusters", "[connThread] Reviving cluster " + index);
                        }
                        if (next.revive()) {
                            if (!Util.isLogEnabled()) break;
                            Util.display(4, CLASS_NAME, "processClusters", "[connThread] Success reviving cluster " + index);
                            break;
                        }
                        if (Util.isLogEnabled()) {
                            Util.display(3, CLASS_NAME, "processClusters", "[connThread] Failed reviving cluster " + index);
                        }
                        e2 = this.m_connMgrLock;
                        synchronized (e2) {
                            next.setState(2, 1);
                        }
                    }
                    catch (SmAgentApiException e2) {
                        if (!Util.isLogEnabled()) break;
                        Util.display(3, CLASS_NAME, "processClusters", "[connThread] Exception reviving cluster " + index + ": " + e2);
                    }
                    break;
                }
                case 3: {
                    Object e2;
                    if (foundActive) break;
                    try {
                        if (Util.isLogEnabled()) {
                            Util.display(4, CLASS_NAME, "processClusters", "[connThread] Enabling cluster index = " + index);
                        }
                        e2 = this.m_connMgrLock;
                        synchronized (e2) {
                            if (next.enable()) {
                                if (Util.isLogEnabled()) {
                                    Util.display(5, CLASS_NAME, "processClusters", "[connThread] Enabling and setting active cluster index = " + index);
                                }
                                next.setState(3, 2);
                                this.setCurrentClusterIndex(index);
                            } else {
                                if (Util.isLogEnabled()) {
                                    Util.display(5, CLASS_NAME, "processClusters", "[connThread] Failed enabling cluster index = " + index);
                                }
                                next.setState(3, 1);
                            }
                        }
                    }
                    catch (SmAgentApiException e) {}
                    break;
                }
            }
            foundActive = foundActive || curState == 2;
            ++index;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.m_connMgrLock;
        synchronized (object) {
            return this.m_isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_connMgrLock;
        synchronized (object) {
            if (!this.m_isClosed) {
                if (this.m_timer != null) {
                    this.m_timer.cancel();
                }
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "close", "Closing");
                }
                this.m_isClosed = true;
            }
        }
    }

    private int getCurrentClusterIndex() {
        return this.m_currentClusterIndex;
    }

    private void setCurrentClusterIndex(int index) {
        String methodName = "setCurrentClusterIndex";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "setCurrentClusterIndex", "Started- index = " + index + ", current = " + this.m_currentClusterIndex + ", prevous = " + this.m_previousClusterIndex);
            Util.display(5, CLASS_NAME, "setCurrentClusterIndex", "Setting prev index to " + this.m_currentClusterIndex + ", current to " + index);
        }
        this.m_previousClusterIndex = this.m_currentClusterIndex;
        this.m_currentClusterIndex = index;
    }

    private void resetCurrentClusterIndex() {
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "resetCurrentClusterIndex", "Started");
        }
        this.m_previousClusterIndex = this.m_currentClusterIndex;
        this.setCurrentClusterIndex(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestamp() {
        Object object = this.m_connMgrLock;
        synchronized (object) {
            return this.m_timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(long timestamp) {
        Object object = this.m_connMgrLock;
        synchronized (object) {
            this.m_timestamp = timestamp;
        }
    }

    public String getAttribute(SmConfigAttribute attr) {
        if (this.getSmInitDef() == null) {
            return null;
        }
        SmConfigFile smConfigFile = this.getSmInitDef().getSmConfigFile();
        if (smConfigFile == null) {
            return null;
        }
        try {
            return smConfigFile.getAttribute(attr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAgentName(SmResourceContextDef resourceContextDef) {
        String agent = null;
        if (resourceContextDef != null) {
            agent = resourceContextDef.getAgent();
        }
        if (agent == null) {
            agent = "";
        }
        return agent;
    }

    public SmInitDef getSmInitDef() {
        return this.m_initDef;
    }

    public String getHostName() {
        String hostname = this.getAttribute(SM_CONF_HOST_NAME);
        if (hostname == null) {
            hostname = this.getSmInitDef().getHostName();
        }
        return hostname;
    }

    public SmConfigFile getHostConfigFile() {
        if (this.getSmInitDef() == null) {
            return null;
        }
        return this.getSmInitDef().getSmConfigFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxBufferSize() {
        int retval;
        Object object = this.m_connMgrLock;
        synchronized (object) {
            retval = SmAgentTliBuffer.getMaxBufferSize();
            for (int k = 0; k < this.m_clusters.size(); ++k) {
                int current;
                SmCluster cluster = (SmCluster)this.m_clusters.get(k);
                if (cluster == null || (current = cluster.getMaxBufferSize()) >= retval) continue;
                retval = current;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        int retval;
        Object object = this.m_connMgrLock;
        synchronized (object) {
            retval = SmAgentTliBuffer.getDefaultBufferSize();
            for (int k = 0; k < this.m_clusters.size(); ++k) {
                int current;
                SmCluster cluster = (SmCluster)this.m_clusters.get(k);
                if (cluster == null || (current = cluster.getMaxBufferSize()) >= retval) continue;
                retval = current;
            }
        }
        return retval;
    }

    public Timer getTimer() {
        return this.m_timer;
    }

    static {
        block2: {
            MESSAGES_CLASSNAME = SmConnectionMessages.getName();
            c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
            Date d = new Date();
            byte[] c1_key = d.toString().getBytes();
            String methodName = "static";
            try {
                c_keepCryptoLoaded = SmCryptoProvider.getInstance("RC2/SHA", null, true);
                c_keepCryptoLoaded.init(c1_key, c1_key, null, 128, true);
            }
            catch (SmCryptoProviderException e) {
                if (!Util.isLogEnabled()) break block2;
                Util.display(2, CLASS_NAME, "static", "Failed static load of security classes");
            }
        }
    }
}

