/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigException;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.resources.SmRegHostMessages;
import com.netegrity.util.Fips140Mode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;

public class Util
implements SmAgentApiConstants {
    public static final String CLASS_NAME = "Util";
    private static final String ADDRESS_SEPARATOR = ":";
    private static final String OPENING_SQUARE_BRACKET = "[";
    private static final String CLOSING_SQUARE_BRACKET = "]";
    private static final String IPV6_ADDRESS_SEPERATOR = "]:";
    private static final String MESSAGES_CLASSNAME = SmRegHostMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final Object KEY_READ = new Integer(131097);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String MULTI_AGENT_DELIMITER = ",";
    public static final int DEFAULT_FAILOVER_THRESHHOLD = 100;
    public static final String DEBUG_ENABLE_PROPERTY = "com.ca.siteminder.sdk.agentapi.enableDebug";
    public static final int LOG_LEVEL_FATAL = 1;
    public static final int LOG_LEVEL_ERROR = 2;
    public static final int LOG_LEVEL_WARNING = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_TRACE = 5;
    public static final String FATAL_LOG_KEY = "SMFATAL: ";
    public static final String WARNING_LOG_KEY = "SMWARNING: ";
    public static final String ERROR_LOG_KEY = "SMERROR: ";
    public static final String INFO_LOG_KEY = "SMINFO: ";
    public static final String TRACE_LOG_KEY = "SMTRACE: ";
    public static final String LOG_PARTS_SEPARATOR = ", ";
    public static final String FIPS_MODE_COMPAT = "COMPAT";
    public static final String FIPS_MODE_MIGRATE = "MIGRATE";
    public static final String FIPS_MODE_FIPSONLY = "ONLY";
    public static final String FIPS140_MODE_ENV = "CA_SM_PS_FIPS140";
    private static boolean c_logEnabled = Boolean.getBoolean("com.ca.siteminder.sdk.agentapi.enableDebug");
    private static final String AGENTAPI_BUILD_PROPERTIES = "/smagentapibuild.properties";
    private static String c_versionInfo;

    public static void display(int logLevel, String className, String methodName, String message) {
        if (!c_logEnabled) {
            return;
        }
        StringBuffer appendedBuffer = new StringBuffer();
        appendedBuffer.append(className);
        appendedBuffer.append(LOG_PARTS_SEPARATOR);
        appendedBuffer.append(methodName);
        appendedBuffer.append(LOG_PARTS_SEPARATOR);
        appendedBuffer.append(message);
        String appendedMessage = appendedBuffer.toString();
        switch (logLevel) {
            case 1: {
                Util.displayFatal(appendedMessage);
                break;
            }
            case 2: {
                Util.displayError(appendedMessage);
                break;
            }
            case 3: {
                Util.displayWarning(appendedMessage);
                break;
            }
            case 4: {
                Util.displayInfo(appendedMessage);
                break;
            }
            case 5: {
                Util.displayTrace(appendedMessage);
            }
        }
    }

    public static void displayError(String message) {
        Util.displayError(ERROR_LOG_KEY, message);
    }

    public static void displayWarning(String message) {
        Util.displayError(WARNING_LOG_KEY, message);
    }

    public static void displayFatal(String message) {
        Util.displayError(FATAL_LOG_KEY, message);
    }

    public static void displayInfo(String message) {
        Util.displayOut(INFO_LOG_KEY, message);
    }

    public static void displayTrace(String message) {
        Util.displayOut(TRACE_LOG_KEY, message);
    }

    public static boolean isLogEnabled() {
        return c_logEnabled;
    }

    protected static void displayError(String prependKey, String message) {
        Date time = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.err.println(DATE_FORMAT.format(time) + " [" + Thread.currentThread().getName() + "] " + prependKey + message);
        }
    }

    protected static void displayOut(String prependKey, String message) {
        Date time = new Date(System.currentTimeMillis());
        if (c_logEnabled) {
            System.out.println(DATE_FORMAT.format(time) + " [" + Thread.currentThread().getName() + "] " + prependKey + message);
        }
    }

    public static final boolean isTrueOrYes(String value) {
        if (value == null) {
            return false;
        }
        String normalizedValue = value.trim().toLowerCase();
        return normalizedValue.equals("yes") || normalizedValue.equals("true");
    }

    private static void setFipsMode(Map props) {
        String fipsModeInFile = (String)props.get(SM_CONF_FIPS_MODE);
        Fips140Mode fipsModeObj = Fips140Mode.getFips140ModeObject();
        if (FIPS_MODE_MIGRATE.equals(fipsModeInFile)) {
            fipsModeObj.setMode(2);
        } else if (FIPS_MODE_FIPSONLY.equals(fipsModeInFile)) {
            fipsModeObj.setMode(3);
        } else {
            fipsModeObj.setMode(1);
        }
    }

    public static Map getConfigAttributes(String configPath, String passed4xAgentName) throws SmConfigException, SmCryptoProviderException {
        String methodName = "getConfigAttributes";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getConfigAttributes", "Retrieving contents for config file = " + configPath);
        }
        Map sourceConfigAttributes = Util.getConfigFileAttributes(configPath);
        String hostConfigObject = (String)sourceConfigAttributes.get(SM_CONF_HOSTCONFIG);
        String hostConfigFile = (String)sourceConfigAttributes.get(SM_CONF_HOSTCONFIGFILE);
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getConfigAttributes", "hostConfigObject = " + hostConfigObject + ", hostConfigFile = " + hostConfigFile);
        }
        HashMap<String, String> initDefConfig = new HashMap<String, String>();
        if (hostConfigObject != null) {
            initDefConfig.put(SM_CONF_HOSTCONFIG.getName(), hostConfigObject);
            Util.display(5, CLASS_NAME, "getConfigAttributes", "Processing a 5.x config file with hostConfigObject");
            Util.setFipsMode(sourceConfigAttributes);
            Util.fillHostConfigAttributes(initDefConfig, sourceConfigAttributes);
            initDefConfig.put(SM_CONF_HOSTCONFIGFILE.getName(), configPath);
        } else if (hostConfigFile != null) {
            Util.display(5, CLASS_NAME, "getConfigAttributes", "Processing a 5.x config file with host configuration in file " + hostConfigFile);
            Map hostConfigAttributes = Util.getConfigFileAttributes(hostConfigFile);
            Util.setFipsMode(hostConfigAttributes);
            Util.fillHostConfigAttributes(initDefConfig, hostConfigAttributes);
            initDefConfig.put(SM_CONF_HOSTCONFIGFILE.getName(), hostConfigFile);
        } else {
            Util.display(5, CLASS_NAME, "getConfigAttributes", "Processing a 4.x config file");
            Util.display(5, CLASS_NAME, "getConfigAttributes", "Map=" + sourceConfigAttributes);
            Util.setFipsMode(sourceConfigAttributes);
            String agentName = Util.resolve4xAgentName(passed4xAgentName, (List)sourceConfigAttributes.get(SM_CONF_AGENTNAME), (String)sourceConfigAttributes.get(SM_CONF_DEFAULT_AGENTNAME));
            if (agentName == null) {
                throw new SmConfigException("Missing 4.x agent name");
            }
            Util.fillHostConfigAttributes(initDefConfig, sourceConfigAttributes);
            initDefConfig.put(SM_CONF_HOST_NAME.getName(), agentName);
            initDefConfig.put(SM_CONF_AGENTNAME.getName(), agentName);
            initDefConfig.put(SM_CONF_HOSTCONFIGFILE.getName(), configPath);
        }
        return initDefConfig;
    }

    public static SmInitDef createSmInitDef(Map configAttributes, String sourceConfigFile) throws SmAgentApiNotInitializedException, SmAgentApiConnectionException, SmConfigException {
        String methodName = "createSmInitDef";
        Util.display(5, CLASS_NAME, "createSmInitDef", "Started");
        String failoverAttribute = (String)configAttributes.get(SM_CONF_ENABLE_FAILOVER.getName());
        boolean failover = false;
        if (Util.isTrueOrYes(failoverAttribute)) {
            failover = true;
        }
        SmConfigFile smHostConfig = null;
        smHostConfig = configAttributes.get(SM_CONF_HOSTCONFIGFILE.getName()) != null ? SmConfigFile.getInstance((String)configAttributes.get(SM_CONF_HOSTCONFIGFILE.getName())) : SmConfigFile.getInstance(sourceConfigFile);
        List policyServers = (List)configAttributes.get(SM_CONF_POLICY_SERVER.getName());
        String policyServer = null;
        if (policyServers != null && policyServers.size() > 0) {
            StringBuffer appendedServers = new StringBuffer();
            for (int i = 0; i < policyServers.size(); ++i) {
                appendedServers.append(Util.parseServer((String)policyServers.get(i)));
                if (i >= policyServers.size()) continue;
                appendedServers.append(SmInitDef.SERVER_SEPARATOR);
            }
            policyServer = appendedServers.toString();
        }
        SmInitDef smInitDef = new SmInitDef(smHostConfig, policyServer, (String)configAttributes.get(SM_CONF_HOST_NAME.getName()), (String)configAttributes.get(SM_CONF_SHARED_SECRET.getName()), (String)configAttributes.get(SM_CONF_MAX_SOCKETS_PER_PORT.getName()), (String)configAttributes.get(SM_CONF_MIN_SOCKETS_PER_PORT.getName()), (String)configAttributes.get(SM_CONF_NEW_SOCKET_STEP.getName()), (String)configAttributes.get(SM_CONF_REQUEST_TIMEOUT.getName()), failover, failover ? 100 : 0, null);
        Util.display(5, CLASS_NAME, "createSmInitDef", "Created SmInitDef: " + smInitDef);
        return smInitDef;
    }

    private static String parseServer(String hostNPorts) {
        String[] allParts = hostNPorts.split(MULTI_AGENT_DELIMITER);
        String hostname = allParts[0];
        String port = String.valueOf(44442);
        if (allParts.length > 1 && allParts[1] != null && allParts[1].trim().length() != 0) {
            port = allParts[1];
        } else if (allParts.length > 2 && allParts[2] != null && allParts[2].trim().length() != 0) {
            port = allParts[2];
        } else if (allParts.length > 3 && allParts[3] != null && allParts[3].trim().length() != 0) {
            port = allParts[3];
        }
        return Util.cleanIPv6Address(hostname) + ADDRESS_SEPARATOR + port;
    }

    public static String cleanIPv6Address(String IPAddress) {
        int index = -1;
        if (!IPAddress.startsWith(OPENING_SQUARE_BRACKET) && !IPAddress.endsWith(CLOSING_SQUARE_BRACKET)) {
            index = IPAddress.indexOf(ADDRESS_SEPARATOR);
            if (index == -1) {
                return IPAddress;
            }
            return OPENING_SQUARE_BRACKET + IPAddress + CLOSING_SQUARE_BRACKET;
        }
        return IPAddress;
    }

    public static SmInitDef createSmInitDef(String configFile) throws SmConfigException, SmCryptoProviderException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        return Util.createSmInitDef(configFile, null);
    }

    public static SmInitDef createSmInitDef(String configFile, String passed4xAgentname) throws SmConfigException, SmCryptoProviderException, SmAgentApiConnectionException, SmAgentApiNotInitializedException {
        String methodName = "createSmInitDef-agentName";
        Util.display(5, CLASS_NAME, "createSmInitDef-agentName", "Started");
        Map configAttributes = Util.getConfigAttributes(configFile, passed4xAgentname);
        return Util.createSmInitDef(configAttributes, configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map getConfigFileAttributes(String configFile) throws SmConfigException, SmCryptoProviderException {
        Map configAttributes;
        block5: {
            String methodName = "getConfigFileAttributes";
            configAttributes = null;
            SmConfigFile sourceConfigFile = null;
            try {
                sourceConfigFile = SmConfigFile.getInstance(configFile);
                sourceConfigFile.read();
                configAttributes = sourceConfigFile.getAllAttributes();
                Object var5_4 = null;
                if (sourceConfigFile == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (sourceConfigFile != null) {
                    sourceConfigFile.close();
                }
                throw throwable;
            }
            sourceConfigFile.close();
        }
        if (Util.isLogEnabled()) {
            for (Object key : configAttributes.keySet()) {
                Util.display(5, CLASS_NAME, "getConfigFileAttributes", " Key:" + key + ", Value:" + configAttributes.get(key));
            }
        }
        return configAttributes;
    }

    private static void fillHostConfigAttributes(Map attributes, Map configProperties) {
        String methodName = "fillHostConfigAttributes";
        Util.display(5, CLASS_NAME, "fillHostConfigAttributes", "Started");
        attributes.put(SM_CONF_HOSTCONFIG.getName(), configProperties.get(SM_CONF_HOSTCONFIG));
        attributes.put(SM_CONF_HOST_NAME.getName(), configProperties.get(SM_CONF_HOST_NAME));
        attributes.put(SM_CONF_SHARED_SECRET.getName(), configProperties.get(SM_CONF_SHARED_SECRET));
        attributes.put(SM_CONF_MAX_SOCKETS_PER_PORT.getName(), configProperties.get(SM_CONF_MAX_SOCKETS_PER_PORT));
        attributes.put(SM_CONF_MIN_SOCKETS_PER_PORT.getName(), configProperties.get(SM_CONF_MIN_SOCKETS_PER_PORT));
        attributes.put(SM_CONF_NEW_SOCKET_STEP.getName(), configProperties.get(SM_CONF_NEW_SOCKET_STEP));
        attributes.put(SM_CONF_REQUEST_TIMEOUT.getName(), configProperties.get(SM_CONF_REQUEST_TIMEOUT));
        attributes.put(SM_CONF_ENABLE_FAILOVER.getName(), configProperties.get(SM_CONF_ENABLE_FAILOVER));
        List policyServers = (List)configProperties.get(SM_CONF_POLICY_SERVER);
        if (policyServers == null) {
            Util.display(2, CLASS_NAME, "fillHostConfigAttributes", "smhost.conf missing server property = " + SM_CONF_POLICY_SERVER.getName());
            throw new IllegalArgumentException("Missing smhost.conf server property = " + SM_CONF_POLICY_SERVER.getName());
        }
        attributes.put(SM_CONF_POLICY_SERVER.getName(), policyServers);
    }

    private static String resolve4xAgentName(String passed4xAgentName, List agentNames, String defaultAgentName) {
        String methodName = "resolve4xAgentName";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "resolve4xAgentName", "Passed name = " + passed4xAgentName + ", agentNames = " + agentNames + ", default name = " + defaultAgentName);
        }
        if (passed4xAgentName == null || passed4xAgentName.trim().equals("")) {
            if (defaultAgentName == null) {
                Util.display(2, CLASS_NAME, "resolve4xAgentName", "No agent named resolved from 4.x config file");
            } else {
                Util.display(4, CLASS_NAME, "resolve4xAgentName", "Resolved 4.x config file to default agent name = " + defaultAgentName);
            }
            return defaultAgentName;
        }
        String[] attributeNames = null;
        if (agentNames != null) {
            for (int i = 0; i < agentNames.size(); ++i) {
                attributeNames = ((String)agentNames.get(i)).split(MULTI_AGENT_DELIMITER);
                if (attributeNames == null || attributeNames.length == 0) continue;
                for (int j = 0; j < attributeNames.length; ++j) {
                    if (!passed4xAgentName.equals(attributeNames[j])) continue;
                    Util.display(4, CLASS_NAME, "resolve4xAgentName", "Resolved 4.x config file to passed agent name = " + passed4xAgentName);
                    return passed4xAgentName;
                }
            }
        }
        if (defaultAgentName == null) {
            Util.display(2, CLASS_NAME, "resolve4xAgentName", "4.x config file does not contain matching agent name or default agent to " + passed4xAgentName);
            return null;
        }
        if (!defaultAgentName.equals(passed4xAgentName)) {
            Util.display(2, CLASS_NAME, "resolve4xAgentName", "4.x passed agent name does not match default agent name");
            return null;
        }
        return passed4xAgentName;
    }

    public static String getVersion() {
        return c_versionInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InetSocketAddress parseHostNPort(String hostNPort) throws SmAgentApiException {
        int DEFAULT_POLICY_SERVER_PORT = 44442;
        int port = 44442;
        int index = -1;
        if (hostNPort.startsWith(OPENING_SQUARE_BRACKET)) {
            index = hostNPort.indexOf(CLOSING_SQUARE_BRACKET);
            if (index <= 0) throw new SmAgentApiException(-1, c_bundle.getString("M_INVALID_ADDRESS"));
            index = hostNPort.indexOf(IPV6_ADDRESS_SEPERATOR);
            if (index <= 0) return new InetSocketAddress(hostNPort, port);
            try {
                port = Integer.parseInt(hostNPort.substring(index + IPV6_ADDRESS_SEPERATOR.length()));
                hostNPort = hostNPort.substring(0, index + 1);
                return new InetSocketAddress(hostNPort, port);
            }
            catch (NumberFormatException e) {
                port = 44442;
            }
            return new InetSocketAddress(hostNPort, port);
        }
        index = hostNPort.indexOf(ADDRESS_SEPARATOR);
        if (index <= 0) return new InetSocketAddress(hostNPort, port);
        int secondIndex = hostNPort.indexOf(ADDRESS_SEPARATOR, index + 1);
        if (secondIndex > 0) {
            port = 44442;
            return new InetSocketAddress(hostNPort, port);
        }
        try {
            port = Integer.parseInt(hostNPort.substring(index + ADDRESS_SEPARATOR.length()));
            hostNPort = hostNPort.substring(0, index);
            return new InetSocketAddress(hostNPort, port);
        }
        catch (NumberFormatException e) {
            port = 44442;
        }
        return new InetSocketAddress(hostNPort, port);
    }

    public static String getValueFromRegistry(String RootNode, String key) {
        String Regvalue = null;
        try {
            Preferences systemRoot = Preferences.systemRoot();
            Class<?> clz = systemRoot.getClass();
            Method openKey = null;
            Method closeKey = null;
            Method winRegQueryValue = null;
            Integer handle = new Integer(-1);
            byte[] byteVal = null;
            if (clz != null) {
                Class[] openKeyClass;
                if (System.getProperty("java.version").startsWith("1.4.1")) {
                    openKeyClass = new Class[]{byte[].class, Integer.TYPE};
                    openKey = clz.getDeclaredMethod("openKey", openKeyClass);
                } else {
                    openKeyClass = new Class[]{byte[].class, Integer.TYPE, Integer.TYPE};
                    openKey = clz.getDeclaredMethod("openKey", openKeyClass);
                }
                if (openKey != null) {
                    Class[] winRegQueryClass;
                    openKey.setAccessible(true);
                    Class[] closeKeyClass = new Class[]{Integer.TYPE};
                    closeKey = clz.getDeclaredMethod("closeKey", closeKeyClass);
                    if (closeKey != null) {
                        closeKey.setAccessible(true);
                    }
                    if ((winRegQueryValue = clz.getDeclaredMethod("WindowsRegQueryValueEx", winRegQueryClass = new Class[]{Integer.TYPE, byte[].class})) != null) {
                        winRegQueryValue.setAccessible(true);
                    }
                    if (System.getProperty("java.version").startsWith("1.4.1")) {
                        Object[] openObj = new Object[]{Util.toByteArray(RootNode), KEY_READ};
                        handle = (Integer)openKey.invoke((Object)systemRoot, openObj);
                    } else {
                        Object[] openObj = new Object[]{Util.toByteArray(RootNode), KEY_READ, KEY_READ};
                        handle = (Integer)openKey.invoke((Object)systemRoot, openObj);
                    }
                }
                if (winRegQueryValue != null) {
                    Object[] winRegObj = new Object[]{handle, Util.toByteArray(key)};
                    byteVal = (byte[])winRegQueryValue.invoke((Object)systemRoot, winRegObj);
                }
                Regvalue = byteVal != null ? new String(byteVal).trim() : null;
                Object[] closeObj = new Object[]{handle};
                if (closeKey != null) {
                    closeKey.invoke((Object)Preferences.systemRoot(), closeObj);
                }
            }
        }
        catch (Exception e) {
            Regvalue = null;
        }
        return Regvalue;
    }

    private static byte[] toByteArray(String str) {
        byte[] result = null;
        if (str != null) {
            result = new byte[str.length() + 1];
            for (int i = 0; i < str.length(); ++i) {
                result[i] = (byte)str.charAt(i);
            }
            result[str.length()] = 0;
        }
        return result;
    }

    public static int resolveSetting() {
        String fipsEnv = null;
        String javaVer = System.getProperty("java.version");
        int fipsMode = 0;
        fipsEnv = javaVer != null && javaVer.startsWith("1.4") ? System.getProperty(FIPS140_MODE_ENV) : System.getenv(FIPS140_MODE_ENV);
        fipsMode = FIPS_MODE_MIGRATE.equals(fipsEnv) ? 2 : (FIPS_MODE_FIPSONLY.equals(fipsEnv) ? 3 : 1);
        return fipsMode;
    }

    static {
        InputStream inStream = Util.class.getResourceAsStream(AGENTAPI_BUILD_PROPERTIES);
        if (inStream == null) {
            throw new MissingResourceException("Can't find resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Properties buildProperties = new Properties();
        try {
            buildProperties.load(inStream);
        }
        catch (IOException e) {
            throw new MissingResourceException("Can't load resource with name /smagentapibuild.properties", AGENTAPI_BUILD_PROPERTIES, "");
        }
        Enumeration<Object> keys = buildProperties.keys();
        StringBuffer versionStringBuffer = new StringBuffer();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = buildProperties.getProperty(key);
            versionStringBuffer.append(key + "=" + value);
            if (!keys.hasMoreElements()) continue;
            versionStringBuffer.append(LOG_PARTS_SEPARATOR);
        }
        c_versionInfo = versionStringBuffer.toString();
        if (c_logEnabled) {
            Util.displayInfo(c_versionInfo);
        }
    }
}

