/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.policyapi;

import com.netegrity.sdk.apiutil.NotificationProcessingStatus;
import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.apiutil.SmExportFileHandler;
import com.netegrity.sdk.apiutil.SmImportFileHandler;
import com.netegrity.sdk.apiutil.SmUserPasswordState;
import com.netegrity.sdk.policyapi.SmAdmin;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmAgentConfig;
import com.netegrity.sdk.policyapi.SmAgentGroup;
import com.netegrity.sdk.policyapi.SmAgentType;
import com.netegrity.sdk.policyapi.SmAgentTypeAttr;
import com.netegrity.sdk.policyapi.SmAuthAzMap;
import com.netegrity.sdk.policyapi.SmAuthValidateMap;
import com.netegrity.sdk.policyapi.SmCertMap;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmDomainObject;
import com.netegrity.sdk.policyapi.SmDomainObjectImpl;
import com.netegrity.sdk.policyapi.SmExport;
import com.netegrity.sdk.policyapi.SmExportAttr;
import com.netegrity.sdk.policyapi.SmHostConfig;
import com.netegrity.sdk.policyapi.SmImport;
import com.netegrity.sdk.policyapi.SmImportAttr;
import com.netegrity.sdk.policyapi.SmKeyManagement;
import com.netegrity.sdk.policyapi.SmODBCQuery;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmObjectImpl;
import com.netegrity.sdk.policyapi.SmPasswordPolicy;
import com.netegrity.sdk.policyapi.SmPolicy;
import com.netegrity.sdk.policyapi.SmPolicyApi;
import com.netegrity.sdk.policyapi.SmPolicyLink;
import com.netegrity.sdk.policyapi.SmPwdPolicyRegularExpression;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmResponseAttr;
import com.netegrity.sdk.policyapi.SmResponseGroup;
import com.netegrity.sdk.policyapi.SmRootConfig;
import com.netegrity.sdk.policyapi.SmRule;
import com.netegrity.sdk.policyapi.SmRuleGroup;
import com.netegrity.sdk.policyapi.SmScheme;
import com.netegrity.sdk.policyapi.SmSelfReg;
import com.netegrity.sdk.policyapi.SmSharedSecretPolicy;
import com.netegrity.sdk.policyapi.SmTrustedHost;
import com.netegrity.sdk.policyapi.SmUserContext;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import com.netegrity.sdk.policyapi.SmUserPolicy;
import com.netegrity.sdk.policyapi.SmVariable;
import com.netegrity.sdk.policyapi.SmVariableType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class SmPolicyApiImpl
implements SmPolicyApi {
    private static final String MIGRATION_FILETYPE = "config";
    private static final String PROCESSING_ONHOLD_KEY = "processingonhold";
    private static final int TIMEOUT_STATUS = 7;
    private SmApiSession m_ApiSession = null;
    private int m_Version = 512;

    public SmPolicyApiImpl(SmApiSession smApiSession) {
        this(smApiSession, 512);
    }

    public SmPolicyApiImpl(SmApiSession smApiSession, int n) {
        this.m_ApiSession = smApiSession;
        this.m_Version = n;
    }

    public void setApiSession(SmApiSession smApiSession) {
        this.m_ApiSession = smApiSession;
    }

    public SmApiResult search(SmObject smObject, String[] stringArray, Vector vector) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeSearchProperties(hashtable, stringArray);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SEARCH, smApiObject);
        if (smApiResult.isSuccess()) {
            Hashtable hashtable2 = smApiResult.getDecoderObject().getProperties();
            this.putPropsToStringVector(hashtable2, vector);
        }
        return smApiResult;
    }

    public SmApiResult addRule(SmRule smRule) throws SmApiException {
        return this.addDomainObject(smRule);
    }

    public SmApiResult addRule(SmRule smRule, boolean bl) throws SmApiException {
        if (bl) {
            return this.addGlobalObject(smRule);
        }
        return this.addDomainObject(smRule);
    }

    public SmApiResult modifyRule(SmRule smRule) throws SmApiException {
        return this.modifyDomainObject(smRule);
    }

    public SmApiResult deleteRule(SmRule smRule) throws SmApiException {
        return this.deleteDomainObject(smRule);
    }

    public SmApiResult getRule(String string, String string2, String string3, SmRule smRule) throws SmApiException {
        smRule.setRealm(string2);
        return this.getDomainObject(string, string3, smRule);
    }

    public SmApiResult addPolicy(SmPolicy smPolicy) throws SmApiException {
        return this.addDomainObject(smPolicy);
    }

    public SmApiResult addPolicy(SmPolicy smPolicy, boolean bl) throws SmApiException {
        if (bl) {
            return this.addGlobalObject(smPolicy);
        }
        return this.addDomainObject(smPolicy);
    }

    public SmApiResult addVariable(SmVariable smVariable) throws SmApiException {
        return this.addDomainObject(smVariable);
    }

    public SmApiResult getVariable(String string, String string2, SmVariable smVariable) throws SmApiException {
        return this.getDomainObject(string, string2, smVariable);
    }

    public SmApiResult getDomainVariables(String string, Vector vector) throws SmApiException {
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getDomainObjectNames("Variables", string, vector2);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SmVariable smVariable = new SmVariable();
            smApiResult = this.getVariable(vector2.elementAt(i).toString(), string, smVariable);
            vector.addElement(smVariable);
        }
        return smApiResult;
    }

    public SmApiResult modifyVariable(SmVariable smVariable) throws SmApiException {
        return this.modifyDomainObject(smVariable);
    }

    public SmApiResult deleteVariable(SmVariable smVariable) throws SmApiException {
        return this.deleteDomainObject(smVariable);
    }

    public SmApiResult modifyPolicy(SmPolicy smPolicy) throws SmApiException {
        return this.modifyDomainObject(smPolicy);
    }

    public SmApiResult deletePolicy(SmPolicy smPolicy) throws SmApiException {
        return this.deleteDomainObject(smPolicy);
    }

    public SmApiResult getPolicy(String string, String string2, SmPolicy smPolicy) throws SmApiException {
        return this.getDomainObject(string, string2, smPolicy);
    }

    public SmApiResult getVariableType(String string, SmVariableType smVariableType) throws SmApiException {
        return this.getObject(string, smVariableType);
    }

    public SmApiResult addPolicyLink(SmPolicyLink smPolicyLink) throws SmApiException {
        return this.addDomainObject(smPolicyLink);
    }

    public SmApiResult addPolicyLink(SmPolicyLink smPolicyLink, boolean bl) throws SmApiException {
        if (bl) {
            return this.addGlobalObject(smPolicyLink);
        }
        return this.addDomainObject(smPolicyLink);
    }

    public SmApiResult modifyPolicyLink(SmPolicyLink smPolicyLink) throws SmApiException {
        return this.modifyDomainObject(smPolicyLink);
    }

    public SmApiResult deletePolicyLink(SmObjId smObjId, String string) throws SmApiException {
        SmPolicyLink smPolicyLink = new SmPolicyLink();
        smPolicyLink.setOid(smObjId);
        smPolicyLink.setDomain(string);
        return this.deleteDomainObject(smPolicyLink);
    }

    public SmApiResult getPolicyLinks(String string, String string2, Vector vector) throws SmApiException {
        SmPolicy smPolicy = new SmPolicy(string);
        smPolicy.setDomain(string2);
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getObjectLinkNames(smPolicy, "PolicyLinks", vector2, new SmPolicyLink());
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SmPolicyLink smPolicyLink;
            String string3 = (String)vector2.elementAt(i);
            if (!this.getDomainObjectByOid(string2, string3, smPolicyLink = new SmPolicyLink()).isSuccess()) continue;
            vector.addElement(smPolicyLink);
        }
        return smApiResult;
    }

    public SmApiResult setResponseInPolicyLink(SmPolicyLink smPolicyLink) throws SmApiException {
        return this.modifyPolicyLink(smPolicyLink);
    }

    public SmApiResult addUserPolicy(SmUserPolicy smUserPolicy) throws SmApiException {
        return this.addDomainObject(smUserPolicy);
    }

    public SmApiResult deleteUserPolicy(SmObjId smObjId, String string) throws SmApiException {
        SmUserPolicy smUserPolicy = new SmUserPolicy();
        smUserPolicy.setOid(smObjId);
        smUserPolicy.setDomain(string);
        return this.deleteDomainObject(smUserPolicy);
    }

    public SmApiResult getUserPolicies(String string, String string2, Vector vector) throws SmApiException {
        SmPolicy smPolicy = new SmPolicy(string);
        if (string2.equals(SmObjId.NULL_OID.toString())) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        smPolicy.setDomain(string2);
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getObjectLinkNames(smPolicy, "UserPolicies", vector2, new SmUserPolicy());
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SmUserPolicy smUserPolicy;
            String string3 = (String)vector2.elementAt(i);
            if (!this.getDomainObjectByOid(string2, string3, smUserPolicy = new SmUserPolicy()).isSuccess()) continue;
            vector.addElement(smUserPolicy);
        }
        return smApiResult;
    }

    public SmApiResult addRealm(SmRealm smRealm) throws SmApiException {
        return this.addDomainObject(smRealm);
    }

    public SmApiResult modifyRealm(SmRealm smRealm) throws SmApiException {
        return this.modifyDomainObject(smRealm);
    }

    public SmApiResult deleteRealm(SmRealm smRealm) throws SmApiException {
        return this.deleteDomainObject(smRealm);
    }

    public SmApiResult getRealm(String string, String string2, SmRealm smRealm) throws SmApiException {
        return this.getDomainObject(string, string2, smRealm);
    }

    public SmApiResult getRealmRules(String string, String string2, Vector vector) throws SmApiException {
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getDomainObjectNames("Rules", string2, vector2);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmRealm smRealm = new SmRealm();
        smApiResult = this.getRealm(string, string2, smRealm);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string3 = smRealm.getOid().toString();
        Hashtable<String, SmRule> hashtable = new Hashtable<String, SmRule>();
        for (int i = 0; i < vector2.size(); ++i) {
            SmRule smRule;
            String string4 = (String)vector2.elementAt(i);
            if (!this.getRule(string4, string, string2, smRule = new SmRule()).isSuccess() || !string3.equals(smRule.getRealm().toString())) continue;
            hashtable.put(string4, smRule);
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return smApiResult;
    }

    public SmApiResult getRealmRealms(String string, String string2, Vector vector) throws SmApiException {
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getDomainObjectNames("Realms", string2, vector2);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmRealm smRealm = new SmRealm();
        smApiResult = this.getRealm(string, string2, smRealm);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string3 = smRealm.getOid().toString();
        for (int i = 0; i < vector2.size(); ++i) {
            SmRealm smRealm2;
            String string4 = (String)vector2.elementAt(i);
            if (!this.getRealm(string4, string2, smRealm2 = new SmRealm()).isSuccess() || !string3.equals(smRealm2.getParentRealmOid().toString())) continue;
            vector.addElement(smRealm2);
        }
        return smApiResult;
    }

    public SmApiResult addResponse(SmResponse smResponse) throws SmApiException {
        return this.addDomainObject(smResponse);
    }

    public SmApiResult addResponse(SmResponse smResponse, boolean bl) throws SmApiException {
        if (bl) {
            return this.addGlobalObject(smResponse);
        }
        return this.addDomainObject(smResponse);
    }

    public SmApiResult modifyResponse(SmResponse smResponse) throws SmApiException {
        return this.modifyDomainObject(smResponse);
    }

    public SmApiResult deleteResponse(SmResponse smResponse) throws SmApiException {
        return this.deleteDomainObject(smResponse);
    }

    public SmApiResult getResponse(String string, String string2, SmResponse smResponse) throws SmApiException {
        return this.getDomainObject(string, string2, smResponse);
    }

    public SmApiResult addResponseAttr(SmResponseAttr smResponseAttr) throws SmApiException {
        return this.addDomainObject(smResponseAttr);
    }

    public SmApiResult addResponseAttr(SmResponseAttr smResponseAttr, boolean bl) throws SmApiException {
        if (bl) {
            return this.addGlobalObject(smResponseAttr);
        }
        return this.addDomainObject(smResponseAttr);
    }

    public SmApiResult deleteResponseAttr(SmObjId smObjId, String string) throws SmApiException {
        SmResponseAttr smResponseAttr = new SmResponseAttr();
        smResponseAttr.setOid(smObjId);
        smResponseAttr.setDomain(string);
        return this.deleteDomainObject(smResponseAttr);
    }

    public SmApiResult getResponseAttrs(String string, String string2, Vector vector) throws SmApiException {
        SmResponse smResponse = new SmResponse(string);
        smResponse.setDomain(string2);
        Vector vector2 = new Vector(5);
        SmApiResult smApiResult = this.getObjectLinkNames(smResponse, "Attributes", vector2, new SmResponseAttr());
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            SmResponseAttr smResponseAttr;
            String string3 = (String)vector2.elementAt(i);
            if (!this.getDomainObjectByOid(string2, string3, smResponseAttr = new SmResponseAttr()).isSuccess()) continue;
            vector.addElement(smResponseAttr);
        }
        return smApiResult;
    }

    public SmApiResult getResponseAttrs(String string, String string2, Map map) throws SmApiException {
        SmResponse smResponse = new SmResponse(string);
        smResponse.setDomain(string2);
        Vector vector = new Vector(5);
        SmApiResult smApiResult = this.getObjectLinkNames(smResponse, "Attributes", vector, new SmResponseAttr());
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SmResponseAttr smResponseAttr;
            String string3 = (String)vector.elementAt(i);
            if (!this.getDomainObjectByOid(string2, string3, smResponseAttr = new SmResponseAttr()).isSuccess()) continue;
            map.put(string3, smResponseAttr);
        }
        return smApiResult;
    }

    public SmApiResult modifyResponseAttr(SmResponseAttr smResponseAttr) throws SmApiException {
        return this.modifyDomainObject(smResponseAttr);
    }

    public SmApiResult addAuthAzMap(SmAuthAzMap smAuthAzMap) throws SmApiException {
        return this.addObject(smAuthAzMap);
    }

    public SmApiResult modifyAuthAzMap(SmAuthAzMap smAuthAzMap) throws SmApiException {
        return this.modifyObject(smAuthAzMap);
    }

    public SmApiResult getAuthAzMap(SmObjId smObjId, SmAuthAzMap smAuthAzMap) throws SmApiException {
        return this.getObject(smObjId.toString(), smAuthAzMap);
    }

    public SmApiResult deleteAuthAzMap(SmObjId smObjId) throws SmApiException {
        return this.deleteObject(new SmAuthAzMap(smObjId.toString()));
    }

    public SmApiResult addCertMap(SmCertMap smCertMap) throws SmApiException {
        return this.addObject(smCertMap);
    }

    public SmApiResult modifyCertMap(SmCertMap smCertMap) throws SmApiException {
        return this.modifyObject(smCertMap);
    }

    public SmApiResult deleteCertMap(SmObjId smObjId) throws SmApiException {
        return this.deleteObject(new SmCertMap(smObjId.toString()));
    }

    public SmApiResult getCertMap(SmObjId smObjId, SmCertMap smCertMap) throws SmApiException {
        return this.getObject(smObjId.toString(), smCertMap);
    }

    public SmApiResult addODBCQuery(SmODBCQuery smODBCQuery) throws SmApiException {
        return this.addObject(smODBCQuery);
    }

    public SmApiResult modifyODBCQuery(SmODBCQuery smODBCQuery) throws SmApiException {
        return this.modifyObject(smODBCQuery);
    }

    public SmApiResult deleteODBCQuery(String string) throws SmApiException {
        return this.deleteObject(new SmODBCQuery(string));
    }

    public SmApiResult getODBCQuery(String string, SmODBCQuery smODBCQuery) throws SmApiException {
        return this.getObject(string, smODBCQuery);
    }

    public SmApiResult addUserDirectory(SmUserDirectory smUserDirectory) throws SmApiException {
        return this.addObject(smUserDirectory);
    }

    public SmApiResult modifyUserDirectory(SmUserDirectory smUserDirectory) throws SmApiException {
        return this.modifyObject(smUserDirectory);
    }

    public SmApiResult deleteUserDirectory(String string) throws SmApiException {
        return this.deleteObject(new SmUserDirectory(string));
    }

    public SmApiResult getUserDirectory(String string, SmUserDirectory smUserDirectory) throws SmApiException {
        return this.getObject(string, smUserDirectory);
    }

    public SmApiResult addUserDirToDomain(String string, String string2) throws SmApiException {
        SmDomain smDomain = new SmDomain(string2);
        return this.addObjectLink(smDomain, "UserDirectories", new SmUserDirectory(string));
    }

    public SmApiResult removeUserDirFromDomain(String string, String string2) throws SmApiException {
        SmDomain smDomain = new SmDomain(string2);
        return this.removeObjectLink(smDomain, "UserDirectories", new SmUserDirectory(string));
    }

    public SmApiResult getUserDirSearchOrder(String string, Vector vector) throws SmApiException {
        return this.getObjectLinkNames(new SmDomain(string), "UserDirectories", vector, new SmUserDirectory());
    }

    public SmApiResult setUserDirSearchOrder(String string, Vector vector) throws SmApiException {
        return this.setObjectLinkNames(new SmDomain(string), "UserDirectories", vector, new SmUserDirectory());
    }

    public SmApiResult getDirectoryContents(String string, Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY, string);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_ENUMERATE, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        smApiObject.getPropsFromSepartor(hashtable);
        return smApiResult;
    }

    public SmApiResult lookupDirectory(String string, String string2, Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_SEARCHPATTERN, string2);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_LOOKUP, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmApiObject smApiObject2 = smApiResult.getDecoderObject();
        smApiObject2.getPropsFromSepartor(hashtable);
        return smApiResult;
    }

    public SmApiResult getUserGroups(SmObjId smObjId, String string, boolean bl, Vector vector) throws SmApiException {
        if (smObjId == null || string == null || vector == null) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_RECURSIVE, new Boolean(bl));
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_USER_GROUPS, smApiObject);
        Enumeration enumeration = smApiObject.getProperties().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return smApiResult;
    }

    public SmApiResult getUserContext(SmObjId smObjId, String string, String string2, SmUserContext smUserContext) throws SmApiException {
        if (smObjId == null || string == null || smUserContext == null) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_USER_CONTEXT, smApiObject);
        smUserContext.setApiSession(this.m_ApiSession);
        smUserContext.setSessionID(string2);
        try {
            smUserContext.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        catch (Exception exception) {
            return SmApiResult.SERVER_FAILURE;
        }
        return smApiResult;
    }

    public SmApiResult addRootConfig(SmRootConfig smRootConfig) throws SmApiException {
        return this.addObject(smRootConfig);
    }

    public SmApiResult modifyRootConfig(SmRootConfig smRootConfig) throws SmApiException {
        return this.modifyObject(smRootConfig);
    }

    public SmApiResult deleteRootConfig(SmObjId smObjId) throws SmApiException {
        return this.deleteObject(new SmRootConfig(smObjId.toString()));
    }

    public SmApiResult getRootConfig(SmObjId smObjId, SmRootConfig smRootConfig) throws SmApiException {
        return this.getObject(smObjId.toString(), smRootConfig);
    }

    public SmApiResult addAgent(SmAgent smAgent) throws SmApiException {
        return this.addObject(smAgent);
    }

    public SmApiResult modifyAgent(SmAgent smAgent) throws SmApiException {
        return this.modifyObject(smAgent);
    }

    public SmApiResult deleteAgent(String string) throws SmApiException {
        return this.deleteObject(new SmAgent(string));
    }

    public SmApiResult getAgent(String string, SmAgent smAgent) throws SmApiException {
        return this.getObject(string, smAgent);
    }

    private SmApiResult validateAgentType(SmAgentType smAgentType) throws SmApiException {
        if (smAgentType.getAgentType() != 0 && smAgentType.getAgentType() != 1) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPE;
        }
        if (!(smAgentType.getAgentType() != 0 || smAgentType.getActions().length <= 1 && smAgentType.getActions()[0].equals("Authenticate"))) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPE_ACTION;
        }
        if (smAgentType.getResourceType() < 0 || smAgentType.getResourceType() > 5) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPE_RESOURCE;
        }
        if (smAgentType.getAgentType() == 1 && smAgentType.getAgentTypeSpecific() != 0) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPE_SPECIFIC;
        }
        return SmApiResult.CLIENT_SUCCESS;
    }

    public SmApiResult addAgentType(SmAgentType smAgentType) throws SmApiException {
        SmApiResult smApiResult = this.validateAgentType(smAgentType);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return this.addObject(smAgentType);
    }

    public SmApiResult modifyAgentType(SmAgentType smAgentType) throws SmApiException {
        SmApiResult smApiResult = this.validateAgentType(smAgentType);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return this.modifyObject(smAgentType);
    }

    public SmApiResult deleteAgentType(String string) throws SmApiException {
        return this.deleteObject(new SmAgentType(string));
    }

    public SmApiResult getAgentType(String string, SmAgentType smAgentType) throws SmApiException {
        return this.getObject(string, smAgentType);
    }

    private SmApiResult validateAgentTypeAttr(SmAgentTypeAttr smAgentTypeAttr) throws SmApiException {
        if (smAgentTypeAttr.getAgentType().toString().equals(SmObjId.NULL_OID.toString())) {
            return SmApiResult.CLIENT_NO_AGENTTYPE;
        }
        if (smAgentTypeAttr.getId() < 0 || smAgentTypeAttr.getId() > 255) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_ID;
        }
        if (smAgentTypeAttr.getDataType() < 0 || smAgentTypeAttr.getDataType() > 4) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_DATATYPE;
        }
        if (smAgentTypeAttr.getRadiusType() < 0 || smAgentTypeAttr.getRadiusType() > 2) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_RADIUSTYPE;
        }
        int[] nArray = smAgentTypeAttr.getRadiusBehavior();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0 && nArray[i] <= 3) continue;
            return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_RADIUSBEHAVIOR;
        }
        if (smAgentTypeAttr.getDataType() != 1 && smAgentTypeAttr.getValues().size() > 0) {
            return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_DATATYPE_VALUE;
        }
        Enumeration enumeration = smAgentTypeAttr.getValues().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (k instanceof Integer) continue;
            try {
                Integer.parseInt(k.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return SmApiResult.CLIENT_INVALID_AGENTTYPEATTR_NUMERICVALUE;
            }
        }
        return SmApiResult.CLIENT_SUCCESS;
    }

    public SmApiResult addAgentTypeAttr(SmAgentTypeAttr smAgentTypeAttr) throws SmApiException {
        SmApiResult smApiResult = this.validateAgentTypeAttr(smAgentTypeAttr);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return this.addObject(smAgentTypeAttr);
    }

    public SmApiResult modifyAgentTypeAttr(SmAgentTypeAttr smAgentTypeAttr) throws SmApiException {
        SmApiResult smApiResult = this.validateAgentTypeAttr(smAgentTypeAttr);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return this.modifyObject(smAgentTypeAttr);
    }

    public SmApiResult deleteAgentTypeAttr(String string) throws SmApiException {
        return this.deleteObject(new SmAgentTypeAttr(string));
    }

    public SmApiResult getAgentTypeAttrs(String string, Vector vector) throws SmApiException {
        SmAgentType smAgentType = new SmAgentType(string.trim());
        SmApiResult smApiResult = this.getObjectLinkNames(smAgentType, "Attributes", vector, new SmAgentTypeAttr());
        return smApiResult;
    }

    public SmApiResult getAgentTypeAttr(String string, SmAgentTypeAttr smAgentTypeAttr) throws SmApiException {
        return this.getObject(string, smAgentTypeAttr);
    }

    public SmApiResult addAgentConfig(SmAgentConfig smAgentConfig) throws SmApiException {
        return this.addConfigObject(smAgentConfig);
    }

    public SmApiResult modifyAgentConfig(SmAgentConfig smAgentConfig) throws SmApiException {
        SmApiResult smApiResult = this.modifyConfigObject(smAgentConfig);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return this.updateAgentConfig(smAgentConfig.getName());
    }

    public SmApiResult deleteAgentConfig(String string) throws SmApiException {
        return this.deleteConfigObject(new SmAgentConfig(string));
    }

    public SmApiResult getAgentConfig(String string, SmAgentConfig smAgentConfig) throws SmApiException {
        return this.getConfigObject(string, smAgentConfig);
    }

    public SmApiResult addHostConfig(SmHostConfig smHostConfig) throws SmApiException {
        return this.addConfigObject(smHostConfig);
    }

    public SmApiResult modifyHostConfig(SmHostConfig smHostConfig) throws SmApiException {
        return this.modifyConfigObject(smHostConfig);
    }

    public SmApiResult deleteHostConfig(String string) throws SmApiException {
        return this.deleteConfigObject(new SmHostConfig(string));
    }

    public SmApiResult getHostConfig(String string, SmHostConfig smHostConfig) throws SmApiException {
        return this.getConfigObject(string, smHostConfig);
    }

    public SmApiResult addTrustedHost(SmTrustedHost smTrustedHost) throws SmApiException, IOException, InterruptedException {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        smTrustedHost.writeProperties(hashtable);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        int n = 0;
        SmApiResult smApiResult = SmApiResult.CLIENT_SUCCESS;
        Object object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            int n2;
            object = (String)object2.nextElement();
            String string9 = hashtable.get(object).toString();
            hashtable.put((String)object, string9);
            if (((String)object).equals("Name")) {
                string4 = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (((String)object).equals("IpAddr")) {
                string = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (((String)object).equals("Admin")) {
                string2 = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (((String)object).equals("Password")) {
                string3 = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (((String)object).equals("HostConfig")) {
                string5 = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (((String)object).equals("File")) {
                string6 = smTrustedHost.getStringProp(hashtable, (String)object);
                continue;
            }
            if (!((String)object).equals("RolloverEnabled") || (n2 = smTrustedHost.getIntProp(hashtable, (String)object)) == 0) continue;
            string7 = "-rs";
        }
        object2 = Runtime.getRuntime();
        object = ((Runtime)object2).exec(string8 = "smreghost -i " + string + " -u " + string2 + " -p " + string3 + " -hn " + string4 + " -hc " + string5 + " -f " + string6 + " " + string7);
        n = ((Process)object).waitFor();
        if (n != 0) {
            smApiResult = SmApiResult.SERVER_FAILURE;
        }
        return smApiResult;
    }

    public SmApiResult deleteTrustedHost(String string) throws SmApiException {
        return this.deleteObject(new SmTrustedHost(string));
    }

    public SmApiResult addDomain(SmDomain smDomain) throws SmApiException {
        return this.addObject(smDomain);
    }

    public SmApiResult modifyDomain(SmDomain smDomain) throws SmApiException {
        return this.modifyObject(smDomain);
    }

    public SmApiResult deleteDomain(String string) throws SmApiException {
        return this.deleteObject(new SmDomain(string));
    }

    public SmApiResult getDomain(String string, SmDomain smDomain) throws SmApiException {
        return this.getObject(string, smDomain);
    }

    public SmApiResult addScheme(SmScheme smScheme) throws SmApiException {
        return this.addObject(smScheme);
    }

    public SmApiResult modifyScheme(SmScheme smScheme) throws SmApiException {
        return this.modifyObject(smScheme);
    }

    public SmApiResult deleteScheme(String string) throws SmApiException {
        return this.deleteObject(new SmScheme(string));
    }

    public SmApiResult getScheme(String string, SmScheme smScheme) throws SmApiException {
        return this.getObject(string, smScheme);
    }

    public SmApiResult addPasswordPolicy(SmPasswordPolicy smPasswordPolicy) throws SmApiException {
        return this.addObject(smPasswordPolicy);
    }

    public SmApiResult modifyPasswordPolicy(SmPasswordPolicy smPasswordPolicy) throws SmApiException {
        return this.modifyObject(smPasswordPolicy);
    }

    public SmApiResult deletePasswordPolicy(String string) throws SmApiException {
        return this.deleteObject(new SmPasswordPolicy(string));
    }

    public SmApiResult getPasswordPolicy(String string, SmPasswordPolicy smPasswordPolicy) throws SmApiException {
        return this.getObject(string, smPasswordPolicy);
    }

    public SmApiResult addRegularExpressionToPasswordPolicy(SmPwdPolicyRegularExpression smPwdPolicyRegularExpression) throws SmApiException {
        return this.addObject(smPwdPolicyRegularExpression);
    }

    public SmApiResult removeRegularExpressionFromPasswordPolicy(SmPwdPolicyRegularExpression smPwdPolicyRegularExpression) throws SmApiException {
        return this.deleteObject(smPwdPolicyRegularExpression);
    }

    public SmApiResult getRegularExpressions(String string, Vector vector) throws SmApiException {
        SmPasswordPolicy smPasswordPolicy = new SmPasswordPolicy(string.trim());
        SmApiResult smApiResult = this.getObjectLinkNames(smPasswordPolicy, "RegularExpressions", vector, new SmPwdPolicyRegularExpression());
        return smApiResult;
    }

    public SmApiResult getUserState(SmObjId smObjId, String string, SmUserPasswordState smUserPasswordState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT_FUNC_NAME, "getUserState");
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT, smApiObject);
        if (smApiResult.isSuccess()) {
            smUserPasswordState.populate(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    public SmApiResult setUserState(SmObjId smObjId, String string, SmUserPasswordState smUserPasswordState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER_STATE, new Integer(smUserPasswordState.getUserState()));
        smApiObject.setProperty(SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT_FUNC_NAME, "setUserState");
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT, smApiObject);
        return smApiResult;
    }

    public SmApiResult getPasswordState(SmObjId smObjId, String string, SmUserPasswordState smUserPasswordState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT_FUNC_NAME, "getUserPasswordState");
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT, smApiObject);
        if (smApiResult.isSuccess()) {
            smUserPasswordState.populate(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    public SmApiResult setPasswordState(SmObjId smObjId, String string, SmUserPasswordState smUserPasswordState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_DISABLED_TIME, new Integer(smUserPasswordState.getDisabledTime()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_EMPTY_PW_HISTORY, new Boolean(smUserPasswordState.getEmptyPasswordHistory()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_LOGIN_TIME, new Integer(smUserPasswordState.getLastLoginTime()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_PWCHANGE_TIME, new Integer(smUserPasswordState.getLastPasswordChange()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LOGIN_FAILURES, new Integer(smUserPasswordState.getLoginFailures()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_PREVIOUS_LOGIN_TIME, new Integer(smUserPasswordState.getPreviousLoginTime()));
        smApiObject.setProperty(SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT_FUNC_NAME, "setUserPasswordState");
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_USER_MANAGEMENT, smApiObject);
        return smApiResult;
    }

    public SmApiResult addSelfReg(SmSelfReg smSelfReg) throws SmApiException {
        return this.addObject(smSelfReg);
    }

    public SmApiResult modifySelfReg(SmSelfReg smSelfReg) throws SmApiException {
        return this.modifyObject(smSelfReg);
    }

    public SmApiResult deleteSelfReg(String string) throws SmApiException {
        return this.deleteObject(new SmSelfReg(string));
    }

    public SmApiResult getSelfReg(String string, SmSelfReg smSelfReg) throws SmApiException {
        return this.getObject(string, smSelfReg);
    }

    public SmApiResult addAdmin(SmAdmin smAdmin) throws SmApiException {
        return this.addObject(smAdmin);
    }

    public SmApiResult modifyAdmin(SmAdmin smAdmin) throws SmApiException {
        return this.modifyObject(smAdmin);
    }

    public SmApiResult deleteAdmin(String string) throws SmApiException {
        return this.deleteObject(new SmAdmin(string));
    }

    public SmApiResult getAdmin(String string, SmAdmin smAdmin) throws SmApiException {
        return this.getObject(string, smAdmin);
    }

    public SmApiResult addAdminToDomain(String string, String string2) throws SmApiException {
        return this.addObjectLink(new SmDomain(string2), "Admins", new SmAdmin(string));
    }

    public SmApiResult removeAdminFromDomain(String string, String string2) throws SmApiException {
        return this.removeObjectLink(new SmDomain(string2), "Admins", new SmAdmin(string));
    }

    public SmApiResult getAdminUserDirs(String string, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_ADMIN_USERDIRS, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmApiObject smApiObject2 = smApiResult.getDecoderObject();
        this.putPropsToStringVector(smApiObject2.getProperties(), vector);
        return smApiResult;
    }

    public SmApiResult getAdminDomains(String string, Vector vector) throws SmApiException {
        SmAdmin smAdmin = new SmAdmin(string.trim());
        SmApiResult smApiResult = this.getObjectLinkNames(smAdmin, "Domains", vector, new SmDomain());
        return smApiResult;
    }

    public SmApiResult getDomainObjectNames(String string, String string2, Vector vector) throws SmApiException {
        if (string2.equals(SmObjId.NULL_OID.toString()) && !string.equals("Rules") && !string.equals("Responses") && !string.equals("Policies")) {
            throw new SmApiException(SmApiResult.SERVER_INVALID_OBJECTCLASS);
        }
        return this.getObjectLinkNames(new SmDomain(string2), string, vector, null);
    }

    public SmApiResult getGlobalObjectNames(String string, Vector vector) throws SmApiException {
        return this.getObjectLinkNames(null, string, vector, null);
    }

    public SmApiResult addGroup(String string, SmObject smObject) throws SmApiException {
        if (smObject.isDomainObject()) {
            SmDomainObject smDomainObject = (SmDomainObject)smObject;
            smDomainObject.setDomain(string);
            return this.addDomainObject(smDomainObject);
        }
        return this.addObject(smObject);
    }

    public SmApiResult modifyGroup(String string, SmObject smObject) throws SmApiException {
        if (smObject.isDomainObject()) {
            SmDomainObject smDomainObject = (SmDomainObject)smObject;
            smDomainObject.setDomain(string);
            return this.modifyDomainObject(smDomainObject);
        }
        return this.modifyObject(smObject);
    }

    public SmApiResult deleteGroup(int n, String string, String string2) throws SmApiException {
        SmObjectImpl smObjectImpl = null;
        switch (n) {
            case 3: {
                smObjectImpl = new SmAgentGroup(string);
                break;
            }
            case 1: {
                smObjectImpl = new SmRuleGroup(string);
                break;
            }
            case 2: {
                smObjectImpl = new SmResponseGroup(string);
                break;
            }
            default: {
                return SmApiResult.POLICY_INVALID_GROUP_TYPE;
            }
        }
        if (smObjectImpl.isDomainObject()) {
            SmDomainObject smDomainObject = (SmDomainObject)((Object)smObjectImpl);
            smDomainObject.setDomain(string2);
            return this.deleteDomainObject(smDomainObject);
        }
        return this.deleteObject(smObjectImpl);
    }

    public SmApiResult getGroup(String string, String string2, SmObject smObject) throws SmApiException {
        if (smObject.isDomainObject()) {
            return this.getDomainObject(string, string2, (SmDomainObject)smObject);
        }
        return this.getObject(string, smObject);
    }

    public SmApiResult getGroupMembers(int n, String string, String string2, Vector vector) throws SmApiException {
        SmObjectImpl smObjectImpl = null;
        SmObjectImpl smObjectImpl2 = null;
        String string3 = null;
        switch (n) {
            case 3: {
                smObjectImpl = new SmAgentGroup(string);
                string3 = "Agents";
                smObjectImpl2 = new SmAgent();
                break;
            }
            case 1: {
                smObjectImpl = new SmRuleGroup(string);
                string3 = "Rules";
                smObjectImpl2 = new SmRule();
                break;
            }
            case 2: {
                smObjectImpl = new SmResponseGroup(string);
                string3 = "Responses";
                smObjectImpl2 = new SmResponse();
                break;
            }
            default: {
                return SmApiResult.POLICY_INVALID_GROUP_TYPE;
            }
        }
        if (smObjectImpl.isDomainObject()) {
            ((SmDomainObject)((Object)smObjectImpl)).setDomain(string2);
        }
        return this.getObjectLinkNames(smObjectImpl, string3, vector, smObjectImpl2);
    }

    public SmApiResult addToGroup(int n, String string, String string2, String string3) throws SmApiException {
        SmObjectImpl smObjectImpl = null;
        String string4 = null;
        SmObjectImpl smObjectImpl2 = null;
        switch (n) {
            case 3: {
                smObjectImpl = new SmAgentGroup(string2);
                string4 = "Agents";
                smObjectImpl2 = new SmAgent(string);
                break;
            }
            case 1: {
                smObjectImpl = new SmRuleGroup(string2);
                string4 = "Rules";
                smObjectImpl2 = new SmRule(string);
                break;
            }
            case 2: {
                smObjectImpl = new SmResponseGroup(string2);
                string4 = "Responses";
                smObjectImpl2 = new SmResponse(string);
                break;
            }
            default: {
                return SmApiResult.POLICY_INVALID_GROUP_TYPE;
            }
        }
        if (smObjectImpl.isDomainObject()) {
            ((SmDomainObject)((Object)smObjectImpl)).setDomain(string3);
        }
        return this.addObjectLink(smObjectImpl, string4, smObjectImpl2);
    }

    public SmApiResult removeFromGroup(int n, String string, String string2, String string3) throws SmApiException {
        SmObjectImpl smObjectImpl = null;
        String string4 = null;
        SmObjectImpl smObjectImpl2 = null;
        switch (n) {
            case 3: {
                smObjectImpl = new SmAgentGroup(string2);
                string4 = "Agents";
                smObjectImpl2 = new SmAgent(string);
                break;
            }
            case 1: {
                smObjectImpl = new SmRuleGroup(string2);
                string4 = "Rules";
                smObjectImpl2 = new SmRule(string);
                break;
            }
            case 2: {
                smObjectImpl = new SmResponseGroup(string2);
                string4 = "Responses";
                smObjectImpl2 = new SmResponse(string);
                break;
            }
            default: {
                return SmApiResult.POLICY_INVALID_GROUP_TYPE;
            }
        }
        if (smObjectImpl.isDomainObject()) {
            ((SmDomainObject)((Object)smObjectImpl)).setDomain(string3);
        }
        return this.removeObjectLink(smObjectImpl, string4, smObjectImpl2);
    }

    public SmApiResult flushAll() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_FLUSHALL);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_FLUSH, smApiObject);
    }

    public SmApiResult holdUpdatesNotificationsProcessing() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_HOLD_SERVERCMD_PROCESSING);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SERVERCMD_PROCESSING_MGMT, smApiObject);
    }

    public SmApiResult resumeUpdatesNotificationsProcessing() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_RESUME_SERVERCMD_PROCESSING);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SERVERCMD_PROCESSING_MGMT, smApiObject);
    }

    public SmApiResult isUpdatesNotificationsProcessingOnHold(NotificationProcessingStatus notificationProcessingStatus) throws SmApiException {
        if (notificationProcessingStatus == null) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_GET_SERVERCMD_PROCESSING_STATUS);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SERVERCMD_PROCESSING_MGMT, smApiObject);
        if (smApiResult.isSuccess()) {
            Hashtable hashtable = smApiResult.getDecoderObject().getProperties();
            String string = (String)hashtable.get(PROCESSING_ONHOLD_KEY);
            if (string.equals("true")) {
                notificationProcessingStatus.setValue(true);
            } else {
                notificationProcessingStatus.setValue(false);
            }
        }
        return smApiResult;
    }

    public SmApiResult flushUsers() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_FLUSHUSERS);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_FLUSH, smApiObject);
    }

    public SmApiResult flushUser(String string, String string2) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_FLUSHUSER);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DIRECTORY, string);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_USER, string2);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_FLUSH, smApiObject);
    }

    public SmApiResult flushRealms() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_FLUSHREALMS);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_FLUSH, smApiObject);
    }

    public SmApiResult flushRealm(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_FLUSHREALM);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_REALMOID, string);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_FLUSH, smApiObject);
    }

    public SmApiResult changeDynamicKey() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_CHANGE_DYNAMIC_KEY);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CHANGE_KEY, smApiObject);
    }

    public SmApiResult changePersistentKey(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_CHANGE_PERSISTENT_KEY);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_KEY, string);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CHANGE_KEY, smApiObject);
    }

    public SmApiResult changeSessionKey(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_CHANGE_SESSION_KEY);
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_KEY, string);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CHANGE_KEY, smApiObject);
    }

    public SmApiResult changeSharedSecretKey() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_MANAGEMENT_COMMAND, SmApiConstants.POLICYAPI_KEY_CHANGE_SHARED_SECRET_KEY);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CHANGE_KEY, smApiObject);
    }

    public SmApiResult getRealmUserPolicies(String string, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_REALMOID, string);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_REALM_USER_POLICIES, smApiObject);
        if (smApiResult.isSuccess()) {
            vector.removeAllElements();
            Enumeration enumeration = smApiObject.getProperties().elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                vector.addElement(string2);
            }
        }
        return smApiResult;
    }

    private SmApiResult addDomainObject(SmDomainObject smDomainObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        if (smDomainObject.getDomain().isNull()) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        smDomainObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CREATE_DOMAIN_OBJ, smApiObject);
        if (smApiResult.isSuccess()) {
            smDomainObject.setOid(smApiObject.getProperty("Oid"));
        }
        return smApiResult;
    }

    private SmApiResult addGlobalObject(SmDomainObject smDomainObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        if (!smDomainObject.getDomain().isNull()) {
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
        smDomainObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CREATE_GLOBAL_OBJ, smApiObject);
        if (smApiResult.isSuccess()) {
            smDomainObject.setOid(smApiObject.getProperty("Oid"));
        }
        return smApiResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SmApiResult modifyDomainObject(SmDomainObject smDomainObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        SmApiConstants smApiConstants = SmApiConstants.POLICYAPI_CMD_SET_DOMAIN_OBJ_PROPS;
        smDomainObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        if (smDomainObject instanceof SmRule) {
            if (smDomainObject.getDomain().isNull() && ((SmRule)smDomainObject).getRealm().isNull()) {
                smApiConstants = SmApiConstants.POLICYAPI_CMD_SET_GLOBAL_OBJ_PROPS;
                return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
            } else {
                if (smDomainObject.getDomain().isNull() || ((SmRule)smDomainObject).getRealm().isNull()) throw new SmApiException(SmApiResult.SERVER_INVALID_OBJECTCLASS);
                smApiConstants = SmApiConstants.POLICYAPI_CMD_SET_DOMAIN_OBJ_PROPS;
            }
            return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
        } else {
            if (!smDomainObject.getDomain().isNull() || !(smDomainObject instanceof SmResponse) && !(smDomainObject instanceof SmResponseAttr) && !(smDomainObject instanceof SmPolicy) && !(smDomainObject instanceof SmPolicyLink)) return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
            smApiConstants = SmApiConstants.POLICYAPI_CMD_SET_GLOBAL_OBJ_PROPS;
        }
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SmApiResult deleteDomainObject(SmDomainObject smDomainObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        SmApiConstants smApiConstants = SmApiConstants.POLICYAPI_CMD_DELETE_DOMAIN_OBJ;
        smDomainObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        if (smDomainObject instanceof SmRule) {
            if (smDomainObject.getDomain().isNull() && ((SmRule)smDomainObject).getRealm().isNull()) {
                smApiConstants = SmApiConstants.POLICYAPI_CMD_DELETE_GLOBAL_OBJ;
                return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
            } else {
                if (smDomainObject.getDomain().isNull() || ((SmRule)smDomainObject).getRealm().isNull()) throw new SmApiException(SmApiResult.SERVER_INVALID_OBJECTCLASS);
                smApiConstants = SmApiConstants.POLICYAPI_CMD_DELETE_DOMAIN_OBJ;
            }
            return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
        } else if (smDomainObject.getDomain().isNull() && (smDomainObject instanceof SmResponse || smDomainObject instanceof SmResponseAttr || smDomainObject instanceof SmPolicy || smDomainObject instanceof SmPolicyLink)) {
            smApiConstants = SmApiConstants.POLICYAPI_CMD_DELETE_GLOBAL_OBJ;
            return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
        } else {
            if (!smDomainObject.getDomain().isNull() || !(smDomainObject instanceof SmUserPolicy)) return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
            throw new SmApiException(SmApiResult.INVALID_PARAMETERS);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SmApiResult getDomainObject(String string, String string2, SmDomainObject smDomainObject) throws SmApiException {
        String string3 = smDomainObject.getObjectClassname();
        SmApiConstants smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_DOMAIN_OBJ_PROPS;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(4);
        hashtable.put("DomainOid", string2);
        hashtable.put("ObjectClassName", string3);
        hashtable.put("Name", string);
        if (string3.compareTo("Rule") == 0) {
            hashtable.put("Realm", ((SmRule)smDomainObject).getRealm());
        } else if (string3.compareTo("Realm") == 0) {
            hashtable.put("ParentRealmOid", ((SmRealm)smDomainObject).getParentRealmOid());
        }
        SmApiObject smApiObject = new SmApiObject(hashtable);
        if (smDomainObject instanceof SmRule) {
            if (string2.equals(SmObjId.NULL_OID.toString()) && ((SmRule)smDomainObject).getRealm().isNull()) {
                smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_GLOBAL_OBJ_PROPS;
            } else {
                if (string2.equals(SmObjId.NULL_OID.toString()) || ((SmRule)smDomainObject).getRealm().isNull()) throw new SmApiException(SmApiResult.SERVER_INVALID_OBJECTCLASS);
                smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_DOMAIN_OBJ_PROPS;
            }
        } else if (string2.equals(SmObjId.NULL_OID.toString()) && (smDomainObject instanceof SmResponse || smDomainObject instanceof SmPolicy)) {
            smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_GLOBAL_OBJ_PROPS;
        }
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, smApiObject);
        if (!smApiResult.isSuccess()) return smApiResult;
        smDomainObject.readProperties(smApiResult.getDecoderObject().getProperties());
        return smApiResult;
    }

    private SmApiResult getDomainObjectByOid(String string, String string2, SmDomainObject smDomainObject) throws SmApiException {
        SmApiResult smApiResult;
        String string3 = smDomainObject.getObjectClassname();
        SmApiConstants smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_DOMAIN_OBJ_PROPS;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        hashtable.put("DomainOid", string);
        hashtable.put("ObjectClassName", string3);
        hashtable.put("Oid", string2);
        if (string.equals(SmObjId.NULL_OID.toString()) && (smDomainObject instanceof SmResponseAttr || smDomainObject instanceof SmPolicyLink)) {
            smApiConstants = SmApiConstants.POLICYAPI_CMD_GET_GLOBAL_OBJ_PROPS;
        }
        if ((smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), smApiConstants, new SmApiObject(hashtable))).isSuccess()) {
            smDomainObject.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    private SmApiResult addObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CREATE_OBJ, smApiObject);
        if (smApiResult.isSuccess()) {
            smObject.setOid(smApiObject.getProperty("Oid"));
        }
        return smApiResult;
    }

    private SmApiResult modifyObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SET_OBJ_PROPS, new SmApiObject(hashtable));
    }

    private SmApiResult deleteObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_DELETE_OBJ, smApiObject);
    }

    public SmApiResult getObject(String string, SmObject smObject) throws SmApiException {
        if (smObject instanceof SmAgentConfig) {
            return this.getAgentConfig(string, (SmAgentConfig)smObject);
        }
        if (smObject instanceof SmHostConfig) {
            return this.getHostConfig(string, (SmHostConfig)smObject);
        }
        if (smObject instanceof SmAuthValidateMap) {
            return this.getAuthValidateMap(SmObjId.valueOf(string), (SmAuthValidateMap)smObject);
        }
        smObject.setName(string);
        String string2 = smObject.getObjectClassname();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        hashtable.put("ObjectClassName", string2);
        if (smObject.getName() == null) {
            hashtable.put("Name", string);
        } else {
            hashtable.put("Name", smObject.getName());
        }
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_OBJ_PROPS, new SmApiObject(hashtable));
        if (smApiResult.isSuccess()) {
            smObject.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    private SmApiResult addConfigObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CREATE_CONFIG_OBJ, smApiObject);
        if (smApiResult.isSuccess()) {
            smObject.setOid(smApiObject.getProperty("Oid"));
        }
        return smApiResult;
    }

    private SmApiResult modifyConfigObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SET_CONFIG_OBJ_PROPS, new SmApiObject(hashtable));
    }

    private SmApiResult deleteConfigObject(SmObject smObject) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_DELETE_CONFIG_OBJ, smApiObject);
    }

    private SmApiResult updateAgentConfig(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_DATA, "agent/" + string);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_UPDATE_CONFIG_OBJ, smApiObject);
    }

    public SmApiResult getConfigObject(String string, SmObject smObject) throws SmApiException {
        smObject.setName(string);
        String string2 = smObject.getObjectClassname();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        hashtable.put("ObjectClassName", string2);
        if (smObject.getName() == null) {
            hashtable.put("Name", string);
        } else {
            hashtable.put("Name", smObject.getName());
        }
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_CONFIG_OBJ_PROPS, new SmApiObject(hashtable));
        if (smApiResult.isSuccess()) {
            smObject.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    public SmApiResult renameObject(SmObjId smObjId, String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_OID, smObjId.toString());
        smApiObject.setProperty(SmApiConstants.POLICYAPI_KEY_NAME, string);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_RENAME_OBJECT, smApiObject);
        return smApiResult;
    }

    public int getVersion() {
        return this.m_Version;
    }

    private String getSessionspec() {
        return this.m_ApiSession.getSessionSpec();
    }

    protected SmApiResult addObjectLink(SmObject smObject, String string, SmObject smObject2) throws SmApiException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        if (smObject.isDomainObject()) {
            hashtable.put("DomainOid", ((SmDomainObject)smObject).getDomainName());
        }
        hashtable.put("ObjectClassName", smObject.getObjectClassname());
        hashtable.put("Name", smObject.getName());
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_PROP_NAME.toString(), string);
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_CLASS_NAME.toString(), smObject2.getObjectClassname());
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_NAME.toString(), smObject2.getName());
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_ADD_LINK, new SmApiObject(hashtable));
    }

    protected SmApiResult removeObjectLink(SmObject smObject, String string, SmObject smObject2) throws SmApiException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        if (smObject.isDomainObject()) {
            hashtable.put("DomainOid", ((SmDomainObject)smObject).getDomainName());
        }
        hashtable.put("ObjectClassName", smObject.getObjectClassname());
        hashtable.put("Name", smObject.getName());
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_PROP_NAME.toString(), string);
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_CLASS_NAME.toString(), smObject2.getObjectClassname());
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_NAME.toString(), smObject2.getName());
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_REMOVE_LINK, new SmApiObject(hashtable));
    }

    private SmApiResult addObjectLinks(SmObject smObject, String string, Vector vector, SmObject smObject2) throws SmApiException {
        SmApiResult smApiResult = SmApiResult.CLIENT_SUCCESS;
        for (int i = 0; i < vector.size(); ++i) {
            SmObject smObject3 = (SmObject)vector.elementAt(i);
            smApiResult = this.addObjectLink(smObject, string, smObject3);
            if (smApiResult.isSuccess()) continue;
        }
        return smApiResult;
    }

    private SmApiResult removeObjectLinks(SmObject smObject, String string, Vector vector, SmObject smObject2) throws SmApiException {
        SmApiResult smApiResult = SmApiResult.CLIENT_SUCCESS;
        for (int i = 0; i < vector.size(); ++i) {
            SmObject smObject3 = (SmObject)vector.elementAt(i);
            smApiResult = this.removeObjectLink(smObject, string, smObject3);
            if (smApiResult.isSuccess()) continue;
        }
        return smApiResult;
    }

    private SmApiResult getObjectLinkNames(SmObject smObject, String string, Vector vector, SmObject smObject2) throws SmApiException {
        boolean bl = false;
        String string2 = SmObjId.NULL_OID.toString();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(30);
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_PROP_NAME.toString(), string);
        if (smObject2 != null) {
            hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_CLASS_NAME.toString(), smObject2.getObjectClassname());
        }
        if (smObject == null) {
            hashtable.put("ObjectClassName", "Root");
        } else {
            if (smObject.isDomainObject()) {
                bl = true;
                string2 = ((SmDomainObject)smObject).getDomainName();
                hashtable.put("DomainOid", string2);
            }
            hashtable.put("ObjectClassName", smObject.getObjectClassname());
            hashtable.put("Name", smObject.getName());
            hashtable.put("Oid", smObject.getName());
        }
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_LINKS, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        SmApiObject smApiObject2 = smApiResult.getDecoderObject();
        this.putPropsToStringVector(smApiObject2.getProperties(), vector);
        return smApiResult;
    }

    private SmApiResult setObjectLinks(SmObject smObject, String string, Vector vector, SmObject smObject2) throws SmApiException {
        Vector<String> vector2 = new Vector<String>(vector.size());
        for (int i = 0; i < vector2.size(); ++i) {
            SmObject smObject3 = (SmObject)vector.elementAt(i);
            vector2.addElement(smObject3.getName());
        }
        return this.setObjectLinkNames(smObject, string, vector2, smObject2);
    }

    private SmApiResult setObjectLinkNames(SmObject smObject, String string, Vector vector, SmObject smObject2) throws SmApiException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(20);
        if (smObject.isDomainObject()) {
            String string2 = ((SmDomainObject)smObject).getDomainName();
            hashtable.put("DomainOid", string2);
        }
        hashtable.put("ObjectClassName", smObject.getObjectClassname());
        hashtable.put("Name", smObject.getName());
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_PROP_NAME.toString(), string);
        hashtable.put(SmApiConstants.POLICYAPI_PROP_LINK_CLASS_NAME.toString(), smObject2.getObjectClassname());
        for (int i = 0; i < vector.size(); ++i) {
            hashtable.put(new String("object" + i), (String)vector.elementAt(i));
        }
        SmApiObject smApiObject = new SmApiObject(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SET_LINKS, smApiObject);
    }

    private void putPropsToStringVector(Hashtable hashtable, Vector vector) {
        Vector vector2 = new Vector(hashtable.keySet());
        Collections.sort(vector2);
        vector.removeAllElements();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(hashtable.get((String)enumeration.nextElement()));
        }
    }

    private SmApiResult executeExport(SmObject smObject, SmObject smObject2) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.CMD_EXECUTE_EXPORT, smApiObject);
        if (smApiResult.isSuccess()) {
            smObject2.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    private SmApiResult executeImport(SmObject smObject, SmObject smObject2) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        smObject.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.CMD_EXECUTE_IMPORT, smApiObject);
        if (smApiResult.isSuccess()) {
            smObject2.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    public SmApiResult doExport(SmExportAttr smExportAttr) throws SmApiException {
        int n = 0;
        SmExport smExport = new SmExport();
        SmExportFileHandler smExportFileHandler = new SmExportFileHandler();
        SmApiResult smApiResult = this.checkExportAttr(smExportAttr, smExport, smExportFileHandler);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        boolean bl = true;
        SmExport smExport2 = new SmExport();
        smExport.setInitExportFlag(true);
        smExport.setFileIndex(n);
        try {
            smApiResult = this.executeExport(smExport, smExport2);
        }
        catch (SmApiException smApiException) {
            if (smApiException.getStatus() == 7) {
                File file = new File(smExportFileHandler.getSmdifFile());
                file.delete();
                file = new File(smExportFileHandler.getConfigFile());
                file.delete();
            }
            throw smApiException;
        }
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        if (bl) {
            smExportFileHandler.writeSmdifData(smExport2.getData(), smExport2.getDataSize(), n);
        } else {
            smExportFileHandler.writeConfigData(smExport2.getData(), smExport2.getDataSize(), n);
        }
        ++n;
        String string = smExport2.getSmdifFile();
        String string2 = smExport2.getConfigFile();
        int n2 = 0;
        while (n2 <= 1) {
            smExport.resetObject();
            smExport2.resetObject();
            smExport.setSmdifFile(string);
            smExport.setConfigFile(string2);
            smExport.setFileIndex(n);
            smExport.setInitExportFlag(false);
            if (!bl) {
                smExport.setFileType(MIGRATION_FILETYPE);
            }
            try {
                smApiResult = this.executeExport(smExport, smExport2);
            }
            catch (SmApiException smApiException) {
                if (smApiException.getStatus() == 7) {
                    File file = new File(smExportFileHandler.getSmdifFile());
                    file.delete();
                    file = new File(smExportFileHandler.getConfigFile());
                    file.delete();
                }
                throw smApiException;
            }
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
            if (bl) {
                smExportFileHandler.writeSmdifData(smExport2.getData(), smExport2.getDataSize(), n);
            } else {
                smExportFileHandler.writeConfigData(smExport2.getData(), smExport2.getDataSize(), n);
            }
            ++n;
            if (smExport2.getMoreDataFlag()) continue;
            ++n2;
            n = 0;
            bl = false;
        }
        return SmApiResult.CLIENT_SUCCESS;
    }

    public SmApiResult doImport(SmImportAttr smImportAttr) throws SmApiException {
        SmImport smImport = new SmImport();
        SmImportFileHandler smImportFileHandler = new SmImportFileHandler();
        SmApiResult smApiResult = this.checkImportAttr(smImportAttr, smImport, smImportFileHandler);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        int n = 0;
        boolean bl = true;
        boolean bl2 = this.checkFileExist(smImportFileHandler.getConfigFile());
        int n2 = 0;
        if (bl2) {
            ++n2;
        }
        String string4 = "";
        string4 = bl ? smImportFileHandler.readSmdifData() : smImportFileHandler.readConfigData();
        SmImport smImport2 = new SmImport();
        smImport2.setFileIndex(n);
        SmImport smImport3 = new SmImport();
        boolean bl3 = true;
        if (smImportFileHandler.getIndex() == -1) {
            if (bl2) {
                n = 1;
                bl = false;
            }
        } else {
            ++n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            smImport2.setData(string4);
            smImport2.setMoreDataFlag(true);
            if (bl3) {
                smImport2.setInitImportFlag(true);
                bl3 = false;
            } else {
                smImport2.setInitImportFlag(false);
                smImport2.setSmdifFile(string);
                smImport2.setConfigFile(string2);
                smImport2.setTempFile(string3);
            }
            smImport2.setDataSize(20480);
            smApiResult = this.executeImport(smImport2, smImport3);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
            string = smImport3.getSmdifFile();
            string2 = smImport3.getConfigFile();
            string3 = smImport3.getTempFile();
            smImport2.resetObject();
            smImport3.resetObject();
            smImport2.setFileIndex(n);
            string4 = bl ? smImportFileHandler.readSmdifData() : smImportFileHandler.readConfigData();
            if (smImportFileHandler.getIndex() != 1) continue;
            if (bl2) {
                n = 1;
                bl = false;
            }
            ++n3;
        }
        if (bl3) {
            smImport.setInitImportFlag(true);
            bl3 = false;
        } else {
            smImport.setInitImportFlag(false);
            smImport.setSmdifFile(string);
            smImport.setConfigFile(string2);
            smImport.setTempFile(string3);
        }
        smImport.setData(string4);
        smImport.setMoreDataFlag(false);
        smImport.setDataSize(20480);
        smImport.setFileIndex(n);
        smApiResult = this.executeImport(smImport, smImport3);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        return SmApiResult.CLIENT_SUCCESS;
    }

    private SmApiResult checkExportAttr(SmExportAttr smExportAttr, SmExport smExport, SmExportFileHandler smExportFileHandler) throws SmApiException {
        String string = smExportAttr.getFileName();
        string = string.trim();
        boolean bl = smExportAttr.getOverwrite();
        boolean bl2 = string.equals("");
        if (bl && bl2) {
            return SmApiResult.CLIENT_EXPORT_FILENAME_F;
        }
        if (bl2) {
            string = "stdout.smdif";
        }
        String string2 = this.stringAddExtension(string, ".cfg");
        if (!bl) {
            boolean bl3 = this.checkFileExist(string);
            if (bl3) {
                return SmApiResult.CLIENT_EXPORT_SMDIFFILE_F;
            }
            bl3 = this.checkFileExist(string2);
            if (bl3) {
                return SmApiResult.CLIENT_EXPORT_CONFIG_F;
            }
        }
        smExport.setDomain(smExportAttr.getDomain());
        smExport.setIMSEnv(smExportAttr.getIMSEnv());
        smExport.setIMSDir(smExportAttr.getIMSDir());
        smExport.setFlags(smExportAttr.getFlags());
        smExportFileHandler.setSmdifFile(string);
        smExportFileHandler.setConfigFile(string2);
        return SmApiResult.CLIENT_SUCCESS;
    }

    private SmApiResult checkImportAttr(SmImportAttr smImportAttr, SmImport smImport, SmImportFileHandler smImportFileHandler) throws SmApiException {
        String string = smImportAttr.getFileName();
        if ((string = string.trim()).equals("")) {
            return SmApiResult.CLIENT_IMPORT_NO_INPUTFILE_I;
        }
        boolean bl = this.checkFileExist(string);
        if (!bl) {
            return SmApiResult.CLIENT_IMPORT_OPEN_ERROR;
        }
        String string2 = this.stringAddExtension(string, ".cfg");
        smImport.setFlags(smImportAttr.getFlags());
        smImportFileHandler.setSmdifFile(string);
        smImportFileHandler.setConfigFile(string2);
        return SmApiResult.CLIENT_SUCCESS;
    }

    private String stringAddExtension(String string, String string2) {
        String string3 = "";
        int n = string.indexOf(46);
        string3 = n == -1 ? string : string.substring(0, n);
        string3 = string3 + string2;
        return string3;
    }

    private boolean checkFileExist(String string) throws SmApiException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (Exception exception) {
            throw new SmApiException(SmApiResult.CLIENT_IMPORT_FILE_READ_ERROR);
        }
        return bl;
    }

    public SmApiResult getPolicyStoreVersion(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GETPOLICYSTOREVERSION, smApiObject);
        if (smApiResult.isSuccess()) {
            stringBuffer.append(smApiObject.getProperty(SmApiConstants.POLICYAPI_KEY_PSMAJORVERSION));
            stringBuffer2.append(smApiObject.getProperty(SmApiConstants.POLICYAPI_KEY_PSMINORVERSION));
            stringBuffer3.append(smApiObject.getProperty(SmApiConstants.POLICYAPI_KEY_PSMODE));
        }
        return smApiResult;
    }

    public SmApiResult addAuthValidateMap(SmAuthValidateMap smAuthValidateMap) throws SmApiException {
        SmApiResult smApiResult = this.validateAuthValidateMap(smAuthValidateMap);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        Hashtable hashtable = new Hashtable();
        smAuthValidateMap.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_CREATE_AUTHVALIDATEMAP, smApiObject);
        if (smApiResult.isSuccess()) {
            smAuthValidateMap.setOid(smApiObject.getProperty("Oid"));
        }
        return smApiResult;
    }

    public SmApiResult modifyAuthValidateMap(SmAuthValidateMap smAuthValidateMap) throws SmApiException {
        SmApiResult smApiResult = this.validateAuthValidateMap(smAuthValidateMap);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        Hashtable hashtable = new Hashtable();
        smAuthValidateMap.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_SET_AUTHVALIDATEMAP_PROPS, smApiObject);
    }

    public SmApiResult deleteAuthValidateMap(SmObjId smObjId) throws SmApiException {
        Hashtable hashtable = new Hashtable();
        SmAuthValidateMap smAuthValidateMap = new SmAuthValidateMap(smObjId.toString());
        smAuthValidateMap.writeProperties(hashtable);
        SmApiObject smApiObject = new SmApiObject(hashtable);
        return this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_DELETE_AUTHVALIDATEMAP, smApiObject);
    }

    public SmApiResult getAuthValidateMap(SmObjId smObjId, SmAuthValidateMap smAuthValidateMap) throws SmApiException {
        String string = smAuthValidateMap.getObjectClassname();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        hashtable.put("ObjectClassName", string);
        hashtable.put("Oid", smObjId);
        SmApiResult smApiResult = this.m_ApiSession.getApiConnection().execute(this.getSessionspec(), SmApiConstants.POLICYAPI_CMD_GET_AUTHVALIDATEMAP_PROPS, new SmApiObject(hashtable));
        if (smApiResult.isSuccess()) {
            smAuthValidateMap.readProperties(smApiResult.getDecoderObject().getProperties());
        }
        return smApiResult;
    }

    private SmApiResult validateAuthValidateMap(SmAuthValidateMap smAuthValidateMap) throws SmApiException {
        if (smAuthValidateMap.getAuthUserDir().trim().equals("") || smAuthValidateMap.getAuthValidateType().trim().equals("") || smAuthValidateMap.getValidateUserDir() == SmObjId.NULL_OID) {
            return SmApiResult.CLIENT_MISSING_AUTHVALIDATEMAP_PROPERTY;
        }
        if (!smAuthValidateMap.getAuthValidateType().equals("UserDN") && !smAuthValidateMap.getAuthValidateType().equals("UniversalID")) {
            return SmApiResult.CLIENT_INVALID_AUTHVALIDATEMAP_MAPPING_TYPE;
        }
        if (smAuthValidateMap.getAuthUserDir().indexOf(38) != -1) {
            return SmApiResult.CLIENT_INVALID_AUTHDIRNAME;
        }
        return SmApiResult.CLIENT_SUCCESS;
    }

    public SmApiResult getChildren(String string, Vector vector) throws SmApiException {
        String string2 = SmObjId.getObjectClass(string);
        SmApiResult smApiResult = new SmApiResult();
        if (string2.equals("SmDomain")) {
            Vector vector2 = new Vector();
            smApiResult = this.getDomainObjectNames("Realms", string, vector2);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                SmRealm smRealm = new SmRealm();
                smApiResult = this.getRealm(vector2.elementAt(i).toString(), string, smRealm);
                if (!smApiResult.isSuccess()) {
                    return smApiResult;
                }
                if (!smRealm.getParentRealmOid().toString().equals(string)) continue;
                vector.add(smRealm.getOid().toString());
            }
        } else if (string2.equals("SmRealm")) {
            SmDomainObjectImpl smDomainObjectImpl;
            SmRealm smRealm = new SmRealm();
            int n = 0;
            smApiResult = this.getObject(string, smRealm);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
            Vector vector3 = new Vector();
            String string3 = smRealm.getDomain().toString();
            smApiResult = this.getRealmRealms(string, string3, vector3);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
            for (n = 0; n <= vector3.size() - 1; ++n) {
                smDomainObjectImpl = new SmRealm();
                this.getRealm(vector3.elementAt(n).toString(), string3, (SmRealm)smDomainObjectImpl);
                if (!((SmRealm)smDomainObjectImpl).getParentRealmOid().toString().equals(string)) continue;
                vector.add(n, smDomainObjectImpl.getOid().toString());
            }
            smApiResult = this.getRealmRules(string, string3, vector3);
            while (n <= vector3.size() - 1) {
                smDomainObjectImpl = new SmRule();
                this.getRule(vector3.elementAt(n).toString(), string, string3, (SmRule)smDomainObjectImpl);
                vector.add(n, smDomainObjectImpl.getOid().toString());
                ++n;
            }
        } else {
            throw new SmApiException(SmApiResult.CLIENT_INVALID_OID);
        }
        return smApiResult;
    }

    public boolean IsGroup(String string) throws SmApiException {
        String string2 = SmObjId.getObjectClass(string);
        return string2.equals("SmRuleGroup") || string2.equals("SmResponseGroup") || string2.equals("SmAgentGroup");
    }

    public SmApiResult getSharedSecretPolicy(String string, SmSharedSecretPolicy smSharedSecretPolicy) throws SmApiException {
        return this.getObject(string, smSharedSecretPolicy);
    }

    public SmApiResult modifySharedSecretPolicy(SmSharedSecretPolicy smSharedSecretPolicy) throws SmApiException {
        return this.modifyObject(smSharedSecretPolicy);
    }

    public SmApiResult getKeyManagement(String string, SmKeyManagement smKeyManagement) throws SmApiException {
        return this.getObject(string, smKeyManagement);
    }

    public SmApiResult modifyKeyManagement(SmKeyManagement smKeyManagement) throws SmApiException {
        return this.modifyObject(smKeyManagement);
    }
}

