/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.policyapi;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.policyapi.SmDomainObjectImpl;
import com.netegrity.sdk.policyapi.SmIPAddress;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmTime;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmPolicy
extends SmDomainObjectImpl {
    public static final String PropActiveExpr = "ActiveExpr";
    public static final String PropTime = "Time";
    public static final String PropPolicyLinks = "PolicyLinks";
    public static final String PropUserPolicies = "UserPolicies";
    public static final String PropEnable = "IsEnabled";
    public static final String PropIPAddress = "IPAddress";
    public static final String PropVariableExpr = "VariableExpr";
    private String m_szActiveExpr = "";
    private Vector m_PolicyLinks = new Vector();
    private Vector m_UserPolicies = new Vector();
    private String m_szIPRestriction = "";
    private String m_szTimeRestriction = new SmTime().toString();
    private String m_szVarExpr = "";
    private boolean m_bEnable = true;

    public SmPolicy() {
        super("Policy", "", "", SmObjId.SmNullOid);
    }

    public SmPolicy(String string) {
        this();
        this.setName(string);
    }

    public String getActiveExpression() {
        return this.m_szActiveExpr;
    }

    public void setActiveExpression(String string) {
        this.m_szActiveExpr = string;
    }

    public void setIPRestriction(Vector vector) {
        this.m_szIPRestriction = this.getStringFromIP(vector);
    }

    private void setIPRestriction(String string) {
        this.m_szIPRestriction = string;
    }

    public Vector getIPRestriction() throws SmApiException {
        return this.getIPFromString();
    }

    public void setTime(SmTime smTime) {
        this.m_szTimeRestriction = smTime.toString();
    }

    public SmTime getTime() {
        SmTime smTime = new SmTime(this.m_szTimeRestriction);
        return smTime;
    }

    public boolean getEnabled() {
        return this.m_bEnable;
    }

    public void setEnabled(boolean bl) {
        this.m_bEnable = bl;
    }

    public String getVariableExpr() {
        return this.m_szVarExpr;
    }

    public void setVariableExpr(String string) {
        this.m_szVarExpr = string;
    }

    public void writeProperties(Hashtable hashtable) {
        super.writeProperties(hashtable);
        if (this.getActiveExpression() != null) {
            hashtable.put(PropActiveExpr, this.getActiveExpression());
        }
        hashtable.put(PropVariableExpr, this.getVariableExpr());
        hashtable.put(PropTime, this.m_szTimeRestriction);
        hashtable.put(PropIPAddress, this.m_szIPRestriction);
        hashtable.put(PropEnable, new Boolean(this.getEnabled()));
    }

    public void readProperties(Hashtable hashtable) {
        super.readProperties(hashtable);
        this.setActiveExpression(this.getStringProp(hashtable, PropActiveExpr));
        this.setVariableExpr(this.getStringProp(hashtable, PropVariableExpr));
        this.setTime(this.getStringProp(hashtable, PropTime));
        this.setIPRestriction(this.getStringProp(hashtable, PropIPAddress));
        this.setEnabled(this.getBoolProp(hashtable, PropEnable));
    }

    private void setTime(String string) {
        this.m_szTimeRestriction = string;
    }

    private Vector getIPFromString() throws SmApiException {
        Vector<SmIPAddress> vector = new Vector<SmIPAddress>();
        if (this.m_szIPRestriction == null || this.m_szIPRestriction.length() == 0) {
            return null;
        }
        String string = this.m_szIPRestriction;
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            SmIPAddress smIPAddress = new SmIPAddress();
            if (string2.startsWith("#")) {
                smIPAddress.setIPMode(3);
                smIPAddress.setHostname(string2.substring(1));
                vector.addElement(smIPAddress);
            } else {
                String string3 = string2.substring(0, 8);
                String string4 = this.hexStrTodecStr(string3);
                smIPAddress.setIPAddress(string4);
                if (string2.length() > 8) {
                    string3 = string2.substring(8);
                    if (string3.startsWith("/")) {
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt(string3.substring(1));
                            smIPAddress.setIPMode(2);
                            smIPAddress.setSubnetBits(n2);
                            vector.addElement(smIPAddress);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (string3.startsWith(":")) {
                        String string5 = this.hexStrTodecStr(string3.substring(1));
                        smIPAddress.setIPMode(1);
                        smIPAddress.setEndIPAddress(string5);
                        vector.addElement(smIPAddress);
                    }
                } else {
                    smIPAddress.setIPMode(0);
                    vector.addElement(smIPAddress);
                }
            }
            ++n;
        }
        return vector;
    }

    private String getStringFromIP(Vector vector) {
        String string = "";
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SmIPAddress smIPAddress = (SmIPAddress)vector.elementAt(i);
            switch (smIPAddress.getIPMode()) {
                case 0: {
                    string = string + this.decStrTohexStr(smIPAddress.getIPAddress());
                    break;
                }
                case 3: {
                    string = string + '#' + smIPAddress.getHostName();
                    break;
                }
                case 2: {
                    string = string + this.decStrTohexStr(smIPAddress.getIPAddress());
                    string = string + "/";
                    string = string + smIPAddress.getSubnetBits();
                    break;
                }
                case 1: {
                    string = string + this.decStrTohexStr(smIPAddress.getIPAddress());
                    string = string + ":";
                    string = string + this.decStrTohexStr(smIPAddress.getEndIPAddress());
                }
            }
            if (i >= n - 1) continue;
            string = string + ",";
        }
        return string;
    }

    private String decStrTohexStr(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ".");
        if (stringTokenizer.countTokens() != 4) {
            return new String("");
        }
        for (int i = 0; i < 4; ++i) {
            int n = Integer.parseInt((String)stringTokenizer.nextElement());
            string2 = string2 + this.int2hex(n / 16);
            string2 = string2 + this.int2hex(n % 16);
        }
        return string2;
    }

    private String int2hex(int n) {
        String string = "i";
        if (n >= 0 && n < 10) {
            string = String.valueOf(n);
        } else if (n == 10) {
            string = "A";
        } else if (n == 11) {
            string = "B";
        } else if (n == 12) {
            string = "C";
        } else if (n == 13) {
            string = "D";
        } else if (n == 14) {
            string = "E";
        } else if (n == 15) {
            string = "F";
        }
        return string;
    }

    private String hexStrTodecStr(String string) {
        String string2 = "";
        for (int i = 0; i < 8; i += 2) {
            int n = 0;
            int n2 = Character.digit(string.charAt(i), 16);
            n += n2 * 16;
            n2 = Character.digit(string.charAt(i + 1), 16);
            string2 = string2 + String.valueOf(n += n2);
            if (i >= 6) continue;
            string2 = string2 + ".";
        }
        return string2;
    }
}

