/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.policyapi;

import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SmIPAddress {
    public static final int IPADDRESS = 0;
    public static final int IPRANGE = 1;
    public static final int SUBNET = 2;
    public static final int HOSTNAME = 3;
    public static final int SUBNETBITS = 24;
    private int m_nIPMode = 0;
    private String m_szIPAddress = "";
    private String m_szEndIPAddress = "";
    private int m_nSubnetBits = 24;
    private String m_szHostname = "";

    public SmIPAddress() {
    }

    public SmIPAddress(int n) throws SmApiException {
        this.setIPMode(n);
    }

    public void setIPMode(int n) throws SmApiException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_nIPMode = n;
                break;
            }
            default: {
                throw new SmApiException(SmApiResult.POLICY_INVALID_ADDRESS_MODE);
            }
        }
    }

    public int getIPMode() {
        return this.m_nIPMode;
    }

    public void setIPAddress(String string) throws SmApiException {
        if (!this.validateIPAddress(string)) {
            throw new SmApiException(SmApiResult.POLICY_INVALID_ADDRESS);
        }
        this.m_szIPAddress = string;
    }

    public String getIPAddress() {
        return this.m_szIPAddress;
    }

    public void setEndIPAddress(String string) throws SmApiException {
        if (!this.validateIPAddress(string)) {
            throw new SmApiException(SmApiResult.POLICY_INVALID_ADDRESS);
        }
        this.m_szEndIPAddress = string;
    }

    public String getEndIPAddress() {
        return this.m_szEndIPAddress;
    }

    public void setSubnetBits(int n) {
        this.m_nSubnetBits = n;
    }

    public int getSubnetBits() {
        return this.m_nSubnetBits;
    }

    public void setHostname(String string) {
        this.m_szHostname = string;
    }

    public String getHostName() {
        return this.m_szHostname;
    }

    public boolean validateIPAddress(String string) {
        boolean bl = false;
        if (string == null) {
            return bl;
        }
        Pattern pattern = Pattern.compile("^(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find() && !"0.0.0.0".equals(string) && !"255.255.255.255".equals(string)) {
            bl = true;
        }
        return bl;
    }
}

