/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.dmsapi.SmDmsConfig;
import com.netegrity.sdk.dmsapi.SmDmsObject;
import com.netegrity.sdk.dmsapi.SmDmsRealmContext;
import com.netegrity.sdk.dmsapi.SmDmsRole;
import com.netegrity.sdk.dmsapi.SmDmsUserPWState;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SmDmsUser
extends SmDmsObject {
    public static final int DMSUSER_DISABLED_DISABLEDMASK = 0xFFFFFF;
    public static final int DMSUSER_DISABLED_ENABLED = 0;
    public static final int DMSUSER_DISABLED_ADMINDISABLED = 1;
    public static final int DMSUSER_DISABLED_MAXLOGINFAIL = 2;
    public static final int DMSUSER_DISABLED_INACTIVITY = 4;
    public static final int DMSUSER_DISABLED_PWEXPIRED = 8;
    public static final int DMSUSER_DISABLED_PEERDISABLED = 16;
    public static final int DMSUSER_DISABLED_PWMUSTCHANGE = 0x1000000;

    protected SmDmsUser(SmApiSession smApiSession, SmRealm smRealm, SmUserDirectory smUserDirectory, SmDmsConfig smDmsConfig, String string, String string2) {
        super(1, smApiSession, smRealm, smUserDirectory, smDmsConfig, string, string2);
    }

    public SmApiResult getDisabledState(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_DISABLED_STATE, smApiObject);
        if (smApiResult.isSuccess()) {
            String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_USER_DISABLED_STATE);
            Integer n = new Integer(string);
            vector.add(n);
        }
        return smApiResult;
    }

    public SmApiResult getDisabledStateNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_DISABLED_STATE_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_USER_DISABLED_STATE);
            Integer n = new Integer(string);
            vector.add(n);
        }
        return smApiResult;
    }

    public SmApiResult setDisabledState(int n) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_USER_DISABLED_STATE, new Integer(n));
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_DISABLED_STATE, smApiObject);
    }

    public SmApiResult setDisabledStateNoAdminCheck(int n) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_USER_DISABLED_STATE, new Integer(n));
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_DISABLED_STATE_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult setEnable() throws SmApiException {
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ENABLE_USER, new SmApiObject());
    }

    public SmApiResult setEnableNoAdminCheck() throws SmApiException {
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ENABLE_USER_NO_ADMIN_CHECK, new SmApiObject());
    }

    public SmApiResult setDisable() throws SmApiException {
        return this.tunnel(SmApiConstants.DMSAPI_CMD_DISABLE_USER, new SmApiObject());
    }

    public SmApiResult setDisableNoAdminCheck() throws SmApiException {
        return this.tunnel(SmApiConstants.DMSAPI_CMD_DISABLE_USER_NO_ADMIN_CHECK, new SmApiObject());
    }

    public SmApiResult changePassword(String string, String string2, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_PASSWORD, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_OLD_PASSWORD, string2);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_DONOTREQUIRE_OLD_PASSWORD, new Boolean(bl));
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_MODIFY_PASSWORD, smApiObject);
        if (smApiResult.isSuccess()) {
            Vector vector = new Vector();
            SmApiResult smApiResult2 = this.getDisabledState(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n != 0x1000000) continue;
                SmApiResult smApiResult3 = this.setDisabledState(0);
            }
        }
        return smApiResult;
    }

    public SmApiResult changePassword(String string, String string2, boolean bl, boolean bl2) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_PASSWORD, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_OLD_PASSWORD, string2);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_DONOTREQUIRE_OLD_PASSWORD, new Boolean(bl));
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_VALIDATE_NEW_PASSWORD, new Boolean(bl2));
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_MODIFY_PASSWORD, smApiObject);
        if (smApiResult.isSuccess()) {
            Vector vector = new Vector();
            SmApiResult smApiResult2 = this.getDisabledState(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n != 0x1000000) continue;
                SmApiResult smApiResult3 = this.setDisabledState(0);
            }
        }
        return smApiResult;
    }

    public SmApiResult changePasswordNoAdminCheck(String string, String string2, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_PASSWORD, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_OLD_PASSWORD, string2);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_DONOTREQUIRE_OLD_PASSWORD, new Boolean(bl));
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_MODIFY_PASSWORD_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            Vector vector = new Vector();
            SmApiResult smApiResult2 = this.getDisabledStateNoAdminCheck(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                if (n != 0x1000000) continue;
                SmApiResult smApiResult3 = this.setDisabledStateNoAdminCheck(0);
            }
        }
        return smApiResult;
    }

    public SmApiResult getUserPWState(SmDmsUserPWState smDmsUserPWState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_PASSWORD_STATE, smApiObject);
        if (smApiResult.isSuccess()) {
            this.parsePWStateApiObject(smApiObject, smDmsUserPWState);
        }
        return smApiResult;
    }

    public SmApiResult getUserPWStateNoAdminCheck(SmDmsUserPWState smDmsUserPWState) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_PASSWORD_STATE_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.parsePWStateApiObject(smApiObject, smDmsUserPWState);
        }
        return smApiResult;
    }

    public SmApiResult setUserPWState(SmDmsUserPWState smDmsUserPWState) throws SmApiException {
        return this.setUserPWState(smDmsUserPWState, false);
    }

    public SmApiResult setUserPWStateNoAdminCheck(SmDmsUserPWState smDmsUserPWState) throws SmApiException {
        return this.setUserPWStateNoAdminCheck(smDmsUserPWState, false);
    }

    public SmApiResult setUserPWState(SmDmsUserPWState smDmsUserPWState, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LOGIN_FAILURES, new Integer(smDmsUserPWState.getLoginFailures()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_LOGIN_TIME, "" + smDmsUserPWState.getLastLoginTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_PREVIOUS_LOGIN_TIME, "" + smDmsUserPWState.getPrevLoginTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_DISABLED_TIME, "" + smDmsUserPWState.getDisabledTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_PWCHANGE_TIME, "" + smDmsUserPWState.getLastPWChangeTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_EMPTY_PW_HISTORY, bl ? "true" : "false");
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_PASSWORD_STATE, smApiObject);
        if (smApiResult.isSuccess()) {
            this.parsePWStateApiObject(smApiObject, smDmsUserPWState);
        }
        return smApiResult;
    }

    public SmApiResult setUserPWStateNoAdminCheck(SmDmsUserPWState smDmsUserPWState, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LOGIN_FAILURES, new Integer(smDmsUserPWState.getLoginFailures()));
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_LOGIN_TIME, "" + smDmsUserPWState.getLastLoginTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_PREVIOUS_LOGIN_TIME, "" + smDmsUserPWState.getPrevLoginTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_DISABLED_TIME, "" + smDmsUserPWState.getDisabledTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_PWCHANGE_TIME, "" + smDmsUserPWState.getLastPWChangeTime().getTime() / 1000L);
        smApiObject.setProperty(SmApiConstants.SMAPI_KEY_PWSTATE_EMPTY_PW_HISTORY, bl ? "true" : "false");
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_PASSWORD_STATE_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.parsePWStateApiObject(smApiObject, smDmsUserPWState);
        }
        return smApiResult;
    }

    private void parsePWStateApiObject(SmApiObject smApiObject, SmDmsUserPWState smDmsUserPWState) {
        String string = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LOGIN_FAILURES);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        smDmsUserPWState.setLoginFailures(n);
        long l = 0L;
        string = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_LOGIN_TIME);
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        smDmsUserPWState.setLastLoginTime(l * 1000L);
        string = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_PWSTATE_PREVIOUS_LOGIN_TIME);
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        smDmsUserPWState.setPrevLoginTime(l * 1000L);
        string = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_PWSTATE_DISABLED_TIME);
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        smDmsUserPWState.setDisabledTime(l * 1000L);
        string = (String)smApiObject.getProperty(SmApiConstants.SMAPI_KEY_PWSTATE_LAST_PWCHANGE_TIME);
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        smDmsUserPWState.setLastPWChangeTime(l * 1000L);
    }

    public SmApiResult setPasswordMustChange() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_PW_MUST_CHANGE, smApiObject);
    }

    public SmApiResult setPasswordMustChangeNoAdminCheck() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_USER_PW_MUST_CHANGE_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult authenticate(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_PASSWORD, string);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_AUTHENTICATE_USER, smApiObject);
    }

    public SmApiResult authenticateNoAdminCheck(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_PASSWORD, string);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_AUTHENTICATE_USER_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult getPrivileges(Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getKeyValues(SmApiConstants.DMSAPI_CMD_GET_USER_PRIVILEGES, smApiObject, hashtable);
    }

    public SmApiResult getPrivilegesNoAdminCheck(Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getKeyValues(SmApiConstants.DMSAPI_CMD_GET_USER_PRIVILEGES_NO_ADMIN_CHECK, smApiObject, hashtable);
    }

    public SmApiResult getRealmPrivileges(String string, Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_REALMOID, string);
        return this.getKeyValues(SmApiConstants.DMSAPI_CMD_GET_USER_REALM_PRIVILEGES, smApiObject, hashtable);
    }

    public SmApiResult getRealmPrivilegesNoAdminCheck(String string, Hashtable hashtable) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_REALMOID, string);
        return this.getKeyValues(SmApiConstants.DMSAPI_CMD_GET_USER_REALM_PRIVILEGES_NO_ADMIN_CHECK, smApiObject, hashtable);
    }

    public SmApiResult getRealmContext(String string, String string2, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_NAME, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_REALMTYPE, new Integer(-1));
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_APPCATEGORY, string2);
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_APPLICATIONS, smApiObject);
        if (smApiResult.isSuccess()) {
            Hashtable hashtable = smApiObject.getProperties();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                SmDmsRealmContext smDmsRealmContext = this.constructRealmContext(string3, string);
                vector.add(smDmsRealmContext);
            }
        }
        return smApiResult;
    }

    public SmApiResult getRealmContextNoAdminCheck(String string, String string2, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_NAME, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_REALMTYPE, new Integer(-1));
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_APPCATEGORY, string2);
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_APPLICATIONS_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            Hashtable hashtable = smApiObject.getProperties();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                SmDmsRealmContext smDmsRealmContext = this.constructRealmContext(string3, string);
                vector.add(smDmsRealmContext);
            }
        }
        return smApiResult;
    }

    public SmApiResult addToRole(SmDmsRole smDmsRole) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_ROLE, smDmsRole.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ADD_USER_TO_ROLE, smApiObject);
    }

    public SmApiResult addToRoleNoAdminCheck(SmDmsRole smDmsRole) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_ROLE, smDmsRole.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ADD_USER_TO_ROLE_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult removeFromRole(SmDmsRole smDmsRole) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_ROLE, smDmsRole.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_REMOVE_USER_FROM_ROLE, smApiObject);
    }

    public SmApiResult removeFromRoleNoAdminCheck(SmDmsRole smDmsRole) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_ROLE, smDmsRole.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_REMOVE_USER_FROM_ROLE_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult getRoles(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_USER_ROLES, smApiObject, vector);
    }

    public SmApiResult getRolesNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_USER_ROLES_NO_ADMIN_CHECK, smApiObject, vector);
    }

    private SmDmsRealmContext constructRealmContext(String string, String string2) {
        if (string.length() == 0) {
            return null;
        }
        SmDmsRealmContext smDmsRealmContext = new SmDmsRealmContext();
        smDmsRealmContext.setRuleName(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, SmApiConstants.CONST_MULTI_ATTR_SEPARATOR.toString());
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            switch (n) {
                case 1: {
                    smDmsRealmContext.setRealmName(string3);
                    break;
                }
                case 2: {
                    smDmsRealmContext.setRealmDesc(string3);
                    break;
                }
                case 3: {
                    smDmsRealmContext.setRealmOid(string3);
                    break;
                }
                case 4: {
                    smDmsRealmContext.setRuleOid(string3);
                    break;
                }
                case 5: {
                    smDmsRealmContext.setRuleDesc(string3);
                    break;
                }
                case 6: {
                    smDmsRealmContext.setResponses(string3);
                    break;
                }
            }
            ++n;
        }
        return smDmsRealmContext;
    }
}

