/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.dmsapi.SmDmsConfig;
import com.netegrity.sdk.dmsapi.SmDmsCursor;
import com.netegrity.sdk.dmsapi.SmDmsGroup;
import com.netegrity.sdk.dmsapi.SmDmsOrganization;
import com.netegrity.sdk.dmsapi.SmDmsRole;
import com.netegrity.sdk.dmsapi.SmDmsUser;
import com.netegrity.sdk.policyapi.SmObjId;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SmDmsObject {
    public static final int DMSOBJECT_CLASS_UNKNOWN = 0;
    public static final int DMSOBJECT_CLASS_DIRECTORY = 7;
    public static final int DMSOBJECT_CLASS_ORGANIZATION = 5;
    public static final int DMSOBJECT_CLASS_GROUP = 2;
    public static final int DMSOBJECT_CLASS_USER = 1;
    public static final int DMSOBJECT_CLASS_ROLE = 4;
    protected SmApiSession m_ApiSession = null;
    protected SmRealm m_Realm = null;
    protected SmUserDirectory m_UserDirectory = null;
    protected SmDmsConfig m_dmsConfig = null;
    protected int m_nClassId = 0;
    protected String m_Dn = "";
    protected String m_OrgDn = "";
    protected Hashtable m_Attributes = new Hashtable(25);
    protected Hashtable m_UpdatedAttributes = new Hashtable(25);
    protected int m_Version = 512;
    protected boolean m_bActiveDir = false;

    protected SmDmsObject(int n, SmApiSession smApiSession, SmRealm smRealm, SmUserDirectory smUserDirectory, SmDmsConfig smDmsConfig, String string, String string2) {
        this.m_nClassId = n;
        this.m_ApiSession = smApiSession;
        this.m_Realm = smRealm;
        this.m_UserDirectory = smUserDirectory;
        this.m_dmsConfig = smDmsConfig;
        this.m_Dn = string;
        this.m_OrgDn = string2.equals("") ? "o=org" : string2;
    }

    public SmDmsObject newDmsObject(int n, String string) {
        switch (n) {
            case 1: {
                return new SmDmsUser(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.getDn());
            }
            case 2: {
                return new SmDmsGroup(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.getDn());
            }
            case 5: {
                return new SmDmsOrganization(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.getDn());
            }
            case 4: {
                return new SmDmsRole(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.getDn());
            }
        }
        return new SmDmsObject(n, this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string, this.getDn());
    }

    public SmApiSession getApiSession() {
        return this.m_ApiSession;
    }

    public SmRealm getRealm() {
        return this.m_Realm;
    }

    public SmUserDirectory getUserDirectory() {
        return this.m_UserDirectory;
    }

    public SmDmsConfig getDmsConfig() {
        return this.m_dmsConfig;
    }

    public int getClassId() {
        return this.m_nClassId;
    }

    public void setClassId(int n) {
        this.m_nClassId = n;
    }

    public String getDn() {
        return this.m_Dn;
    }

    protected void setDn(String string) {
        this.m_Dn = string;
    }

    public String getOrganizationDn() {
        return this.m_OrgDn;
    }

    protected void setOrganizationDn(String string) {
        this.m_OrgDn = string;
    }

    SmApiResult getValues(SmApiConstants smApiConstants, SmApiObject smApiObject, Vector vector) throws SmApiException {
        SmApiResult smApiResult = this.tunnel(smApiConstants, smApiObject);
        if (smApiResult.isSuccess()) {
            Hashtable hashtable = smApiObject.getProperties();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    vector.addElement(enumeration.nextElement().toString());
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
            }
        }
        return smApiResult;
    }

    SmApiResult getKeyValues(SmApiConstants smApiConstants, SmApiObject smApiObject, Hashtable hashtable) throws SmApiException {
        SmApiResult smApiResult = this.tunnel(smApiConstants, smApiObject);
        if (smApiResult.isSuccess()) {
            hashtable.clear();
            Enumeration enumeration = smApiObject.getProperties().keys();
            Enumeration enumeration2 = smApiObject.getProperties().elements();
            while (enumeration2.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), enumeration2.nextElement());
            }
        }
        return smApiResult;
    }

    public Hashtable getAttributes() {
        return this.m_Attributes;
    }

    public void setAttributes(Hashtable hashtable) {
        this.m_UpdatedAttributes = hashtable;
    }

    public void clearAttributes() {
        this.m_Attributes.clear();
    }

    public void setAttribute(String string, Object object) {
        this.m_UpdatedAttributes.put(string, object);
    }

    public Object getAttribute(String string) {
        Object var2_2 = null;
        var2_2 = this.m_Attributes.get(string.toLowerCase());
        if (var2_2 == null) {
            return "";
        }
        return var2_2;
    }

    public void readAttributes(Hashtable hashtable) {
        this.copyAttributes(hashtable, this.m_Attributes);
    }

    public void writeAttributes(Hashtable hashtable) {
        this.copyAttributes(this.m_Attributes, hashtable);
    }

    public void writeUpdatedAttributes(Hashtable hashtable) {
        this.copyAttributes(this.m_UpdatedAttributes, hashtable);
    }

    public String toString() {
        return this.getDn();
    }

    public SmApiResult getObject() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_PROPERTIES, smApiObject);
        if (smApiResult.isSuccess()) {
            this.setDn(smApiObject.getDn());
            this.readAttributes(smApiObject.getProperties());
        }
        return smApiResult;
    }

    public SmApiResult getObjectNoAdminCheck() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_PROPERTIES_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.setDn(smApiObject.getDn());
            this.readAttributes(smApiObject.getProperties());
        }
        return smApiResult;
    }

    public SmApiResult getObject(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        smApiObject.setProperty("attrnames", vector);
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_PROPERTIES, smApiObject);
        if (smApiResult.isSuccess()) {
            this.setDn(smApiObject.getDn());
            this.readAttributes(smApiObject.getProperties());
        }
        return smApiResult;
    }

    public SmApiResult getObjectNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        smApiObject.setProperty("attrnames", vector);
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_PROPERTIES_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.setDn(smApiObject.getDn());
            this.readAttributes(smApiObject.getProperties());
        }
        return smApiResult;
    }

    public SmApiResult addObject() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeUpdatedAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_CREATE, smApiObject);
        if (smApiResult.isSuccess()) {
            this.updateLocalAttributes();
        }
        return smApiResult;
    }

    public SmApiResult addObjectNoAdminCheck() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeUpdatedAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_CREATE_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.updateLocalAttributes();
        }
        return smApiResult;
    }

    public SmApiResult deleteObject() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_DELETE, smApiObject);
    }

    public SmApiResult deleteObjectNoAdminCheck() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeAttributes(smApiObject.getProperties());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_DELETE_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult modifyObject() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeUpdatedAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_SET_PROPERTIES, smApiObject);
        if (smApiResult.isSuccess()) {
            this.updateLocalAttributes();
        }
        return smApiResult;
    }

    public SmApiResult modifyObjectNoAdminCheck() throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        this.writeUpdatedAttributes(smApiObject.getProperties());
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_SET_PROPERTIES_NO_ADMIN_CHECK, smApiObject);
        if (smApiResult.isSuccess()) {
            this.updateLocalAttributes();
        }
        return smApiResult;
    }

    public SmApiResult modifyObjectClass(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        for (int i = 0; i < vector.size(); ++i) {
            String string = "objectclass" + i;
            smApiObject.setProperty(string, (String)vector.elementAt(i));
        }
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_OBJECTCLASS, smApiObject);
    }

    public SmApiResult modifyObjectClassNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setDn(this.getDn());
        for (int i = 0; i < vector.size(); ++i) {
            String string = "objectclass" + i;
            smApiObject.setProperty(string, (String)vector.elementAt(i));
        }
        return this.tunnel(SmApiConstants.DMSAPI_CMD_SET_OBJECTCLASS_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult addToGroup(SmDmsGroup smDmsGroup) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_GROUP, smDmsGroup.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ADD_TO_GROUP, smApiObject);
    }

    public SmApiResult addToGroupNoAdminCheck(SmDmsGroup smDmsGroup) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_GROUP, smDmsGroup.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_ADD_TO_GROUP_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult removeFromGroup(SmDmsGroup smDmsGroup) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_GROUP, smDmsGroup.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_REMOVE_FROM_GROUP, smApiObject);
    }

    public SmApiResult removeFromGroupNoAdminCheck(SmDmsGroup smDmsGroup) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_GROUP, smDmsGroup.getDn());
        return this.tunnel(SmApiConstants.DMSAPI_CMD_REMOVE_FROM_GROUP_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult getGroups(Vector vector, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_RECURSIVE, new Boolean(bl));
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_GROUPS, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        Hashtable hashtable = smApiObject.getProperties();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            vector.addElement(string);
        }
        return smApiResult;
    }

    public SmApiResult getGroupsNoAdminCheck(Vector vector, boolean bl) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_RECURSIVE, new Boolean(bl));
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_GROUPS_NO_ADMIN_CHECK, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        Hashtable hashtable = smApiObject.getProperties();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            vector.addElement(string);
        }
        return smApiResult;
    }

    public SmApiResult getGroups(SmDmsCursor smDmsCursor, Vector vector, Vector vector2, boolean bl, int n) throws SmApiException {
        if (smDmsCursor != null) {
            switch (n) {
                case 1: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset() + smDmsCursor.getBlockSize());
                    break;
                }
                case 2: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset() - smDmsCursor.getBlockSize());
                    break;
                }
                case 3: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset());
                    break;
                }
                default: {
                    smDmsCursor.setOffset(1);
                }
            }
        }
        Hashtable hashtable = new Hashtable();
        if (smDmsCursor != null) {
            smDmsCursor.writeProperties(hashtable);
        }
        SmApiObject smApiObject = new SmApiObject(hashtable);
        smApiObject.setProperty("attrnames", vector);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_RECURSIVE, new Boolean(bl));
        SmApiResult smApiResult = SmApiResult.CLIENT_SUCCESS;
        if (smDmsCursor != null && smDmsCursor.getTotalSize() >= 0 && smDmsCursor.getTotalSize() < smDmsCursor.getOffset()) {
            smDmsCursor.setResultSize(0);
        } else {
            smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_GROUPS, smApiObject);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
        }
        if (smDmsCursor != null) {
            smDmsCursor.readProperties(smApiObject.getProperties());
        }
        Enumeration enumeration = smApiObject.getProperties().elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Integer n3 = new Integer(n2++);
            String string = "object#" + n3.toString();
            SmApiObject smApiObject2 = (SmApiObject)hashtable.get(string);
            if (smApiObject2 != null) {
                String string2 = smApiObject2.getDn();
                SmDmsObject smDmsObject = this.newDmsObject(smApiObject2.getClassId(), string2);
                smDmsObject.setDn(string2);
                smDmsObject.setAttributes(smApiObject2.getProperties());
                vector2.addElement(smDmsObject);
            }
            enumeration.nextElement();
        }
        return smApiResult;
    }

    public SmApiResult getGroupsNoAdminCheck(SmDmsCursor smDmsCursor, Vector vector, Vector vector2, boolean bl, int n) throws SmApiException {
        if (smDmsCursor != null) {
            switch (n) {
                case 1: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset() + smDmsCursor.getBlockSize());
                    break;
                }
                case 2: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset() - smDmsCursor.getBlockSize());
                    break;
                }
                case 3: {
                    smDmsCursor.setOffset(smDmsCursor.getOffset());
                    break;
                }
                default: {
                    smDmsCursor.setOffset(1);
                }
            }
        }
        Hashtable hashtable = new Hashtable();
        if (smDmsCursor != null) {
            smDmsCursor.writeProperties(hashtable);
        }
        SmApiObject smApiObject = new SmApiObject(hashtable);
        smApiObject.setProperty("attrnames", vector);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_RECURSIVE, new Boolean(bl));
        SmApiResult smApiResult = SmApiResult.CLIENT_SUCCESS;
        if (smDmsCursor != null && smDmsCursor.getTotalSize() >= 0 && smDmsCursor.getTotalSize() < smDmsCursor.getOffset()) {
            smDmsCursor.setResultSize(0);
        } else {
            smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_GROUPS_NO_ADMIN_CHECK, smApiObject);
            if (!smApiResult.isSuccess()) {
                return smApiResult;
            }
        }
        if (smDmsCursor != null) {
            smDmsCursor.readProperties(smApiObject.getProperties());
        }
        Enumeration enumeration = smApiObject.getProperties().elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Integer n3 = new Integer(n2++);
            String string = "object#" + n3.toString();
            SmApiObject smApiObject2 = (SmApiObject)hashtable.get(string);
            if (smApiObject2 != null) {
                String string2 = smApiObject2.getDn();
                SmDmsObject smDmsObject = this.newDmsObject(smApiObject2.getClassId(), string2);
                smDmsObject.setDn(string2);
                smDmsObject.setAttributes(smApiObject2.getProperties());
                vector2.addElement(smDmsObject);
            }
            enumeration.nextElement();
        }
        return smApiResult;
    }

    public int getVersion() {
        return this.m_Version;
    }

    void setVersion(int n) {
        this.m_Version = n;
    }

    public boolean isActiveDir() {
        return this.m_bActiveDir;
    }

    @Deprecated
    public void setActiveDir() {
        this.m_bActiveDir = true;
    }

    protected void copyAttributes(Hashtable hashtable, Hashtable hashtable2) {
        hashtable2.clear();
        if (hashtable.size() < 1) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration2.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof String) {
                String string = (String)object;
                object = string.toLowerCase();
            }
            hashtable2.put(object, enumeration2.nextElement());
        }
    }

    protected void updateLocalAttributes() {
        Enumeration enumeration = this.m_UpdatedAttributes.keys();
        Enumeration enumeration2 = this.m_UpdatedAttributes.elements();
        while (enumeration2.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof String) {
                String string = (String)object;
                object = string.toLowerCase();
            }
            this.m_Attributes.put(object, enumeration2.nextElement());
        }
        this.m_UpdatedAttributes.clear();
    }

    protected SmApiResult tunnel(SmApiConstants smApiConstants, SmApiObject smApiObject) throws SmApiException {
        smApiObject.setRealmOid(this.m_Realm.getOid().getOidString());
        if (this.m_UserDirectory.getOid().getOidString().equals(SmObjId.SmNullOid.getOidString())) {
            smApiObject.setDirOid(this.m_UserDirectory.getName());
        } else {
            smApiObject.setDirOid(this.m_UserDirectory.getOid().getOidString());
        }
        smApiObject.setDn(this.getDn());
        smApiObject.setOrganizationDn(this.getOrganizationDn());
        smApiObject.setClassId(this.getClassId());
        smApiObject.setPasswordAttr(this.m_UserDirectory.getPasswordAttr());
        this.m_dmsConfig.encodeCommand(smApiObject);
        return this.m_ApiSession.getApiConnection().execute(this.m_ApiSession.getSessionSpec(), smApiConstants, smApiObject);
    }
}

