/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.apiutil.SmApiConstants;
import com.netegrity.sdk.apiutil.SmApiException;
import com.netegrity.sdk.apiutil.SmApiObject;
import com.netegrity.sdk.apiutil.SmApiResult;
import com.netegrity.sdk.apiutil.SmApiSession;
import com.netegrity.sdk.dmsapi.SmDmsConfig;
import com.netegrity.sdk.dmsapi.SmDmsObject;
import com.netegrity.sdk.dmsapi.SmDmsOrganization;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import java.util.Vector;

public final class SmDmsDirectory
extends SmDmsObject {
    public static final int CAPABILITY_CREATE_PASSWORDPOLICY = 1;
    public static final int CAPABILITY_CREATE_REGISTRATIONPOLICY = 2;
    public static final int CAPABILITY_RESET_USERPASSWORD = 4;
    public static final int CAPABILITY_CHANGE_USERPASSWORD = 8;
    public static final int CAPABILITY_DISABLE_USER = 16;
    public static final int CAPABILITY_DMSCAPABLE = 32;
    public static final int CAPABILITY_RECURSIVE = 64;
    public static final int CAPABILITY_SORTING = 128;
    public static final int CAPABILITY_PAGING = 256;
    public static final int CAPABILITY_DISABLED_ATTR = 0x100000;
    public static final int CAPABILITY_UNIVERSALID_ATTR = 0x200000;
    public static final int CAPABILITY_ANONYMOUSID_ATTR = 0x400000;
    public static final int CAPABILITY_PASSWORDDATA_ATTR = 0x800000;
    public static final int CAPABILITY_USERPASSWORD_ATTR = 0x1000000;
    public static final int CAPABILITY_EMAILADDRESS_ATTR = 0x2000000;
    public static final int CAPABILITY_CHALLENGERESP_ATTR = 0x4000000;

    public SmDmsDirectory(SmApiSession smApiSession, SmRealm smRealm, SmUserDirectory smUserDirectory, SmDmsConfig smDmsConfig) {
        super(7, smApiSession, smRealm, smUserDirectory, smDmsConfig, smUserDirectory.getSearchRoot(), smUserDirectory.getSearchRoot());
    }

    protected void setUserDirectory(SmUserDirectory smUserDirectory) {
        this.m_UserDirectory = smUserDirectory;
    }

    protected void setApiSession(SmApiSession smApiSession) {
        this.m_ApiSession = smApiSession;
    }

    public SmRealm getRealm() {
        return this.m_Realm;
    }

    public SmUserDirectory getUserDirectory() {
        return this.m_UserDirectory;
    }

    public SmApiResult getCapabilities(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_CAPABILITIES, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_CAPABILITIES);
        Integer n = new Integer(string);
        vector.add(n);
        return smApiResult;
    }

    public SmApiResult getCapabilitiesNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        SmApiResult smApiResult = this.tunnel(SmApiConstants.DMSAPI_CMD_GET_CAPABILITIES_NO_ADMIN_CHECK, smApiObject);
        if (!smApiResult.isSuccess()) {
            return smApiResult;
        }
        String string = (String)smApiObject.getProperty(SmApiConstants.DMSAPI_KEY_CAPABILITIES);
        Integer n = new Integer(string);
        vector.add(n);
        return smApiResult;
    }

    public SmApiResult getDmsRoles(String string, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_DOMAIN, string);
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_DMS_ROLES, smApiObject, vector);
    }

    public SmApiResult getDmsRolesNoAdminCheck(String string, Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_DOMAIN, string);
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_DMS_ROLES_NO_ADMIN_CHECK, smApiObject, vector);
    }

    public SmDmsOrganization newOrganization(String string) throws SmApiException {
        String string2 = string;
        if (string2.length() == 0) {
            string2 = this.getDn();
        }
        return new SmDmsOrganization(this.m_ApiSession, this.m_Realm, this.m_UserDirectory, this.m_dmsConfig, string2, this.getDn());
    }

    public SmApiResult getOrganizations(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_ORG_ORGS, smApiObject, vector);
    }

    public SmApiResult getOrganizationsNoAdminCheck(Vector vector) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        return this.getValues(SmApiConstants.DMSAPI_CMD_GET_ORG_ORGS_NO_ADMIN_CHECK, smApiObject, vector);
    }

    public SmApiResult getUserChallengeText(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHROOT, this.m_Dn);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHPATTERN, string);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_CHALLENGE_TEXT, smApiObject);
    }

    public SmApiResult getUserChallengeTextNoAdminCheck(String string) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHROOT, this.m_Dn);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHPATTERN, string);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_CHALLENGE_TEXT_NO_ADMIN_CHECK, smApiObject);
    }

    public SmApiResult getUserTempPassword(String string, String string2) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHROOT, this.m_Dn);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHPATTERN, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_CHALLENGERESPONSE, string2);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_TEMP_PW, smApiObject);
    }

    public SmApiResult getUserTempPasswordNoAdminCheck(String string, String string2) throws SmApiException {
        SmApiObject smApiObject = new SmApiObject();
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHROOT, this.m_Dn);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_SEARCHPATTERN, string);
        smApiObject.setProperty(SmApiConstants.DMSAPI_KEY_CHALLENGERESPONSE, string2);
        return this.tunnel(SmApiConstants.DMSAPI_CMD_GET_USER_TEMP_PW_NO_ADMIN_CHECK, smApiObject);
    }

    public String getDirType() {
        return this.m_UserDirectory.getNamespace();
    }
}

