/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.dmsapi;

import com.netegrity.sdk.dmsapi.SmDmsCookie;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SmDmsCursor {
    private Vector sortOrder = null;
    private int blockSize = 0;
    private int offset = 1;
    private boolean bSortingCritical = false;
    private boolean bPagingCritical = false;
    private int resultSize = 0;
    private int totalSize = -1;
    private boolean bSorted = false;
    private boolean bPaginated = false;
    private String errorMessage = "";
    SmDmsCookie cookie = null;
    Hashtable cookieCache = null;
    private int prefetch = 0;
    private static final String PropNameSortOrder = "sortorder";
    private static final String PropNameOffset = "offset";
    private static final String PropNamePrefetch = "prefetch";
    private static final String PropNameBlockSize = "blocksize";
    private static final String PropNameSortCritical = "sortcritical";
    private static final String PropNamePageCritical = "pagingcritical";
    private static final String PropNameResultSize = "resultsize";
    private static final String PropNameTotalSize = "totalsize";
    private static final String PropNameMessage = "errormessage";
    private static final String PropNameIsPaginated = "ispaginated";
    private static final String PropNameIsSorted = "issorted";
    private static final String PropNameCookieSize = "cookiesize";
    private static final String PropNameCookie = "cookie";
    private static final int PageSizeLimit = 1000;

    public SmDmsCursor(Vector vector, int n, boolean bl, boolean bl2) {
        this.sortOrder = vector;
        this.setBlockSize(n);
        this.bSortingCritical = bl;
        this.bPagingCritical = bl2;
    }

    public Vector getSortOrder() {
        return this.sortOrder;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }

    public int getOffset() {
        return this.offset;
    }

    int getPrefetch() {
        return this.prefetch;
    }

    public void setOffset(int n) {
        this.prefetch = 0;
        if (n > 0) {
            boolean bl = n == this.offset + this.resultSize || n == this.offset + this.blockSize;
            this.offset = n;
            if (this.cookieCache != null && !bl) {
                this.cookie = null;
                SmDmsCookie smDmsCookie = (SmDmsCookie)this.cookieCache.get(new Integer(this.offset));
                if (smDmsCookie == null) {
                    this.setPrefetch();
                    smDmsCookie = (SmDmsCookie)this.cookieCache.get(new Integer(this.prefetch));
                }
                if (smDmsCookie != null) {
                    this.cookie = new SmDmsCookie(smDmsCookie);
                }
            }
        } else {
            this.offset = 1;
            this.cookie = null;
        }
    }

    void setPrefetch() {
        this.prefetch = 0;
        if (this.cookieCache != null) {
            Enumeration enumeration = this.cookieCache.keys();
            this.prefetch = 1;
            while (enumeration.hasMoreElements()) {
                int n = (Integer)enumeration.nextElement();
                if (n <= this.prefetch || n > this.offset) continue;
                this.prefetch = n;
            }
        }
    }

    public boolean isSortingCritical() {
        return this.bSortingCritical;
    }

    public boolean isPagingCritical() {
        return this.bPagingCritical;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    void setResultSize(int n) {
        this.resultSize = n;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    void setTotalSize(int n) {
        this.totalSize = n;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean isSorted() {
        return this.bSorted;
    }

    public boolean isPaginated() {
        return this.bPaginated;
    }

    void writeProperties(Hashtable hashtable) {
        hashtable.put(PropNameSortOrder, this.getSortOrder());
        hashtable.put(PropNameOffset, new Integer(this.getOffset()));
        hashtable.put(PropNamePrefetch, new Integer(this.getPrefetch()));
        hashtable.put(PropNameBlockSize, new Integer(this.getBlockSize()));
        hashtable.put(PropNameSortCritical, new Boolean(this.isSortingCritical()));
        hashtable.put(PropNamePageCritical, new Boolean(this.isPagingCritical()));
        if (this.cookie != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.cookie.getSize());
            hashtable.put(PropNameCookieSize, stringBuffer);
            hashtable.put(PropNameCookie, this.cookie.getBuffer());
        }
    }

    void readProperties(Hashtable hashtable) {
        this.resultSize = this.toInt(hashtable.get(PropNameResultSize), 0);
        this.totalSize = this.toInt(hashtable.get(PropNameTotalSize), -1);
        this.bSorted = this.toBool(hashtable.get(PropNameIsSorted), false);
        this.bPaginated = this.toBool(hashtable.get(PropNameIsPaginated), false);
        this.setErrorMessage((String)hashtable.get(PropNameMessage));
        this.prefetch = 0;
        int n = this.toInt(hashtable.get(PropNameCookieSize), 0);
        if (n > 0) {
            if (this.cookie == null) {
                this.cookie = new SmDmsCookie();
            }
            if (this.cookieCache == null) {
                this.cookieCache = new Hashtable();
            }
            this.cookie.setSize(n);
            this.cookie.setBuffer(hashtable.get(PropNameCookie).toString());
            this.saveCookie(this.cookie);
        } else {
            this.cookie = null;
        }
        hashtable.remove(PropNameResultSize);
        hashtable.remove(PropNameTotalSize);
        hashtable.remove(PropNameIsSorted);
        hashtable.remove(PropNameIsPaginated);
        hashtable.remove(PropNameMessage);
        hashtable.remove(PropNameCookieSize);
        hashtable.remove(PropNameCookie);
    }

    private boolean saveCookie(SmDmsCookie smDmsCookie) {
        boolean bl = true;
        int n = this.offset + this.resultSize;
        if (this.cookieCache == null) {
            this.cookieCache = new Hashtable();
        }
        Enumeration enumeration = this.cookieCache.keys();
        while (enumeration.hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            if (!(n2 < n && n - n2 < 500 || n2 > n && n2 - n < 500) && n2 != n) continue;
            bl = false;
            break;
        }
        if (bl) {
            SmDmsCookie smDmsCookie2 = new SmDmsCookie(smDmsCookie);
            this.cookieCache.put(new Integer(n), smDmsCookie2);
        }
        return bl;
    }

    private int toInt(Object object, int n) {
        try {
            Integer n2 = new Integer(object.toString());
            return n2;
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    private boolean toBool(Object object, boolean bl) {
        try {
            Boolean bl2 = new Boolean(object.toString());
            return bl2;
        }
        catch (Exception exception) {
            return bl;
        }
    }
}

